# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class AnalyticsApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_antivirus_server_stats(self, antivirusServerExtId, metrics, **kwargs):  # noqa: E501
        """Get Antivirus Stats
        Get the antivirus server stats for the given external identifier.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus server for which stats need to be fetched and comma separated list of metrics. The user can also specify `startTimeInUsecs` and `endTimeInUsecs` in query parameters  Available list of metrics are scanned_file_count, threat_count, cleaned_file_count, quarantined_file_count, latency_ms, throughput_bytes, disconnect_count 

        >>> response = api.get_antivirus_server_stats(antivirusServerExtId, metrics, (optional) startTimeInUsecs, (optional) endTimeInUsecs)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_antivirus_server_stats(antivirusServerExtId, metrics, async_req=True)
        >>> result = thread.get()

        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param str metrics: List of metrics. scanned_file_count, threat_count, cleaned_file_count, quarantined_file_count, latency_ms, throughput_bytes, disconnect_count (required)
        :param int startTimeInUsecs: Start time in microseconds to retrieve all the stats generated after this timestamp. For example: 1622705280584000
        :param int endTimeInUsecs: End time in microseconds to retrieve all the stats generated before this timestamp. For example: 1622791680585000
        :param bool async_req:
        :return: files.v4.stats.AntivirusServerStatsApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_antivirus_server_stats_with_http_info(antivirusServerExtId, metrics, **kwargs)  # noqa: E501
        else:
            (data) = self.get_antivirus_server_stats_with_http_info(antivirusServerExtId, metrics, **kwargs)  # noqa: E501
            return data

    def get_antivirus_server_stats_with_http_info(self, antivirusServerExtId, metrics, **kwargs):  # noqa: E501
        """Get Antivirus Stats
        Get the antivirus server stats for the given external identifier.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus server for which stats need to be fetched and comma separated list of metrics. The user can also specify `startTimeInUsecs` and `endTimeInUsecs` in query parameters  Available list of metrics are scanned_file_count, threat_count, cleaned_file_count, quarantined_file_count, latency_ms, throughput_bytes, disconnect_count 

        >>> response = api.get_antivirus_server_stats(antivirusServerExtId, metrics, (optional) startTimeInUsecs, (optional) endTimeInUsecs)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_antivirus_server_stats_with_http_info(antivirusServerExtId, metrics, async_req=True)
        >>> result = thread.get()

        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param str metrics: List of metrics. scanned_file_count, threat_count, cleaned_file_count, quarantined_file_count, latency_ms, throughput_bytes, disconnect_count (required)
        :param int startTimeInUsecs: Start time in microseconds to retrieve all the stats generated after this timestamp. For example: 1622705280584000
        :param int endTimeInUsecs: End time in microseconds to retrieve all the stats generated before this timestamp. For example: 1622791680585000
        :param bool async_req:
        :return: files.v4.stats.AntivirusServerStatsApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirusServerExtId', 'metrics', 'startTimeInUsecs', 'endTimeInUsecs']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_antivirus_server_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirusServerExtId' is set
        if ('antivirusServerExtId' not in params or
                params['antivirusServerExtId'] is None):
            raise ValueError("Missing the required parameter `antivirusServerExtId` when calling `get_antivirus_server_stats`")  # noqa: E501
        # verify the required parameter 'metrics' is set
        if ('metrics' not in params or
                params['metrics'] is None):
            raise ValueError("Missing the required parameter `metrics` when calling `get_antivirus_server_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirusServerExtId' in params:
            path_params['antivirusServerExtId'] = params['antivirusServerExtId']  # noqa: E501

        query_params = []
        if 'metrics' in params:
            query_params.append(('metrics', params['metrics']))  # noqa: E501
        if 'startTimeInUsecs' in params:
            query_params.append(('startTimeInUsecs', params['startTimeInUsecs']))  # noqa: E501
        if 'endTimeInUsecs' in params:
            query_params.append(('endTimeInUsecs', params['endTimeInUsecs']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/stats/file-server/anti-virus-servers/{antivirusServerExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.stats.AntivirusServerStatsApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_server_stats(self, metrics, **kwargs):  # noqa: E501
        """Get File server stats
        Get the file server stats for the file server.  The user has to specify a comma separated list of `metrics`. User can also specify `startTimeInUsecs` and `endTimeInUsecs`  in path parameters.  Available list of metrics are number_of_files, number_of_connections, used_bytes, snapshot_used_bytes, latency,throughput, iops, write_latency, read_latency, metadata_latency, write_throughput, read_throughput, read_iops, write_iops, metadata_iops. 

        >>> response = api.get_file_server_stats(metrics, (optional) startTimeInUsecs, (optional) endTimeInUsecs)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_server_stats(metrics, async_req=True)
        >>> result = thread.get()

        :param str metrics: List of metrics. number_of_files, number_of_connections, used_bytes, snapshot_used_bytes, latency,throughput, iops, write_latency, read_latency, metadata_latency, write_throughput, read_throughput, read_iops, write_iops, metadata_iops (required)
        :param int startTimeInUsecs: Start time in microseconds to retrieve all the stats generated after this timestamp. For example: 1622705280584000
        :param int endTimeInUsecs: End time in microseconds to retrieve all the stats generated before this timestamp. For example: 1622791680585000
        :param bool async_req:
        :return: files.v4.stats.FileServerStatsApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_server_stats_with_http_info(metrics, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_server_stats_with_http_info(metrics, **kwargs)  # noqa: E501
            return data

    def get_file_server_stats_with_http_info(self, metrics, **kwargs):  # noqa: E501
        """Get File server stats
        Get the file server stats for the file server.  The user has to specify a comma separated list of `metrics`. User can also specify `startTimeInUsecs` and `endTimeInUsecs`  in path parameters.  Available list of metrics are number_of_files, number_of_connections, used_bytes, snapshot_used_bytes, latency,throughput, iops, write_latency, read_latency, metadata_latency, write_throughput, read_throughput, read_iops, write_iops, metadata_iops. 

        >>> response = api.get_file_server_stats(metrics, (optional) startTimeInUsecs, (optional) endTimeInUsecs)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_server_stats_with_http_info(metrics, async_req=True)
        >>> result = thread.get()

        :param str metrics: List of metrics. number_of_files, number_of_connections, used_bytes, snapshot_used_bytes, latency,throughput, iops, write_latency, read_latency, metadata_latency, write_throughput, read_throughput, read_iops, write_iops, metadata_iops (required)
        :param int startTimeInUsecs: Start time in microseconds to retrieve all the stats generated after this timestamp. For example: 1622705280584000
        :param int endTimeInUsecs: End time in microseconds to retrieve all the stats generated before this timestamp. For example: 1622791680585000
        :param bool async_req:
        :return: files.v4.stats.FileServerStatsApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['metrics', 'startTimeInUsecs', 'endTimeInUsecs']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_server_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'metrics' is set
        if ('metrics' not in params or
                params['metrics'] is None):
            raise ValueError("Missing the required parameter `metrics` when calling `get_file_server_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'metrics' in params:
            query_params.append(('metrics', params['metrics']))  # noqa: E501
        if 'startTimeInUsecs' in params:
            query_params.append(('startTimeInUsecs', params['startTimeInUsecs']))  # noqa: E501
        if 'endTimeInUsecs' in params:
            query_params.append(('endTimeInUsecs', params['endTimeInUsecs']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/stats/file-server', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.stats.FileServerStatsApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mount_target_stats(self, mountTargetExtId, metrics, **kwargs):  # noqa: E501
        """Get Mount target stats
        Get the mount target stats for the mount target with the given external identifier.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target for which the stats need to be fetched and comma separated list of metrics. The user can also specify `startTimeInUsecs` and `endTimeInUsecs` in query parameters  Available list of metrics are average_latency, average_throughput, read_latency, metadata_latency, write_throughput, read_throughput, average_iops, write_iops, read_iops, metadata_iops, number_of_files, number_of_connections, space_used_bytes, snapshot_used_bytes, s3_write_latency\" 

        >>> response = api.get_mount_target_stats(mountTargetExtId, metrics, (optional) startTimeInUsecs, (optional) endTimeInUsecs)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_stats(mountTargetExtId, metrics, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str metrics: List of metrics. average_latency, average_throughput, read_latency, metadata_latency, write_throughput, read_throughput, average_iops, write_iops, read_iops, metadata_iops, number_of_files, number_of_connections, space_used_bytes, snapshot_used_bytes (required)
        :param int startTimeInUsecs: Start time in microseconds to retrieve all the stats generated after this timestamp. For example: 1622705280584000
        :param int endTimeInUsecs: End time in microseconds to retrieve all the stats generated before this timestamp. For example: 1622791680585000
        :param bool async_req:
        :return: files.v4.stats.MountTargetStatsApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mount_target_stats_with_http_info(mountTargetExtId, metrics, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mount_target_stats_with_http_info(mountTargetExtId, metrics, **kwargs)  # noqa: E501
            return data

    def get_mount_target_stats_with_http_info(self, mountTargetExtId, metrics, **kwargs):  # noqa: E501
        """Get Mount target stats
        Get the mount target stats for the mount target with the given external identifier.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target for which the stats need to be fetched and comma separated list of metrics. The user can also specify `startTimeInUsecs` and `endTimeInUsecs` in query parameters  Available list of metrics are average_latency, average_throughput, read_latency, metadata_latency, write_throughput, read_throughput, average_iops, write_iops, read_iops, metadata_iops, number_of_files, number_of_connections, space_used_bytes, snapshot_used_bytes, s3_write_latency\" 

        >>> response = api.get_mount_target_stats(mountTargetExtId, metrics, (optional) startTimeInUsecs, (optional) endTimeInUsecs)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_stats_with_http_info(mountTargetExtId, metrics, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str metrics: List of metrics. average_latency, average_throughput, read_latency, metadata_latency, write_throughput, read_throughput, average_iops, write_iops, read_iops, metadata_iops, number_of_files, number_of_connections, space_used_bytes, snapshot_used_bytes (required)
        :param int startTimeInUsecs: Start time in microseconds to retrieve all the stats generated after this timestamp. For example: 1622705280584000
        :param int endTimeInUsecs: End time in microseconds to retrieve all the stats generated before this timestamp. For example: 1622791680585000
        :param bool async_req:
        :return: files.v4.stats.MountTargetStatsApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'metrics', 'startTimeInUsecs', 'endTimeInUsecs']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mount_target_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `get_mount_target_stats`")  # noqa: E501
        # verify the required parameter 'metrics' is set
        if ('metrics' not in params or
                params['metrics'] is None):
            raise ValueError("Missing the required parameter `metrics` when calling `get_mount_target_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []
        if 'metrics' in params:
            query_params.append(('metrics', params['metrics']))  # noqa: E501
        if 'startTimeInUsecs' in params:
            query_params.append(('startTimeInUsecs', params['startTimeInUsecs']))  # noqa: E501
        if 'endTimeInUsecs' in params:
            query_params.append(('endTimeInUsecs', params['endTimeInUsecs']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/stats/file-server/mount-targets/{mountTargetExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.stats.MountTargetStatsApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
