# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.storage.v4.config.AuthenticationType import AuthenticationType  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.storage.v4.config.SharingStatus import SharingStatus  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.storage.v4.config.StorageFeatures import StorageFeatures  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VolumeGroup(ExternalizableAbstractModel):
    """VolumeGroup - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'load_balance_vm_attachments': 'bool',
        'sharing_status': 'storage.v4.config.SharingStatus',
        'iscsi_target_prefix': 'str',
        'iscsi_target_name': 'str',
        'target_secret': 'str',
        'enabled_authentications': 'storage.v4.config.AuthenticationType',
        'created_by': 'str',
        'cluster_reference': 'str',
        'storage_features': 'storage.v4.config.StorageFeatures',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'load_balance_vm_attachments': 'loadBalanceVmAttachments',
        'sharing_status': 'sharingStatus',
        'iscsi_target_prefix': 'iscsiTargetPrefix',
        'iscsi_target_name': 'iscsiTargetName',
        'target_secret': 'targetSecret',
        'enabled_authentications': 'enabledAuthentications',
        'created_by': 'createdBy',
        'cluster_reference': 'clusterReference',
        'storage_features': 'storageFeatures',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, load_balance_vm_attachments=None, sharing_status=None, iscsi_target_prefix=None, iscsi_target_name=None, target_secret=None, enabled_authentications=None, created_by=None, cluster_reference=None, storage_features=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """VolumeGroup - a model defined in Swagger
            \nA model that represents Volume Group resources.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__load_balance_vm_attachments = None
        self.__sharing_status = None
        self.__iscsi_target_prefix = None
        self.__iscsi_target_name = None
        self.__target_secret = None
        self.__enabled_authentications = None
        self.__created_by = None
        self.__cluster_reference = None
        self.__storage_features = None
        self.discriminator = None
        if name is not None:
            self.__name = name
        if description is not None:
            self.__description = description
        if load_balance_vm_attachments is not None:
            self.__load_balance_vm_attachments = load_balance_vm_attachments
        if sharing_status is not None:
            self.__sharing_status = sharing_status
        if iscsi_target_prefix is not None:
            self.__iscsi_target_prefix = iscsi_target_prefix
        if iscsi_target_name is not None:
            self.__iscsi_target_name = iscsi_target_name
        if target_secret is not None:
            self.__target_secret = target_secret
        if enabled_authentications is not None:
            self.__enabled_authentications = enabled_authentications
        if created_by is not None:
            self.__created_by = created_by
        if cluster_reference is not None:
            self.__cluster_reference = cluster_reference
        if storage_features is not None:
            self.__storage_features = storage_features

    def _initialize_object_type(self):
        return 'storage.v4.config.VolumeGroup'

    def _initialize_fq_object_type(self):
        return 'storage.v4.r0.a1.config.VolumeGroup'


    @property
    def name(self):
        """`{ str }`
            \nThe name of the Volume Group.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is not None and len(name) > 256:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `256`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nThe description of the Volume Group.
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def load_balance_vm_attachments(self):
        """`{ bool }`
            \nWhether to enable volume group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa.
        """ # noqa: E501
        return self.__load_balance_vm_attachments

    @load_balance_vm_attachments.setter
    def load_balance_vm_attachments(self, load_balance_vm_attachments):

        self.__load_balance_vm_attachments = load_balance_vm_attachments

    @property
    def sharing_status(self):
        """`{ storage.v4.config.SharingStatus }`
            
        """ # noqa: E501
        return self.__sharing_status

    @sharing_status.setter
    def sharing_status(self, sharing_status):

        self.__sharing_status = sharing_status

    @property
    def iscsi_target_prefix(self):
        """`{ str }`
            \niSCSI target prefix-name. The spec should not comprise both iscsi target prefix and iscsi target name.
        """ # noqa: E501
        return self.__iscsi_target_prefix

    @iscsi_target_prefix.setter
    def iscsi_target_prefix(self, iscsi_target_prefix):
        if iscsi_target_prefix is not None and len(iscsi_target_prefix) > 512:
            raise ValueError("Invalid value for `iscsi_target_prefix`, length must be less than or equal to `512`")  # noqa: E501
        if iscsi_target_prefix is not None and not re.search('^[\\da-zA-Z:\\.\\-]+$', iscsi_target_prefix):  # noqa: E501
            raise ValueError(r"Invalid value for `iscsi_target_prefix`, must be a follow pattern or equal to `/^[\\da-zA-Z:\\.\\-]+$/`")  # noqa: E501

        self.__iscsi_target_prefix = iscsi_target_prefix

    @property
    def iscsi_target_name(self):
        """`{ str }`
            \niSCSI target full name. The spec should not comprise both iscsi target prefix and iscsi target name.
        """ # noqa: E501
        return self.__iscsi_target_name

    @iscsi_target_name.setter
    def iscsi_target_name(self, iscsi_target_name):

        self.__iscsi_target_name = iscsi_target_name

    @property
    def target_secret(self):
        """`{ str }`
            \nTarget Secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        """ # noqa: E501
        return self.__target_secret

    @target_secret.setter
    def target_secret(self, target_secret):

        self.__target_secret = target_secret

    @property
    def enabled_authentications(self):
        """`{ storage.v4.config.AuthenticationType }`
            
        """ # noqa: E501
        return self.__enabled_authentications

    @enabled_authentications.setter
    def enabled_authentications(self, enabled_authentications):

        self.__enabled_authentications = enabled_authentications

    @property
    def created_by(self):
        """`{ str }`
            \nService/user who created this Volume Group.
        """ # noqa: E501
        return self.__created_by

    @created_by.setter
    def created_by(self, created_by):
        if created_by is not None and len(created_by) > 512:
            raise ValueError("Invalid value for `created_by`, length must be less than or equal to `512`")  # noqa: E501

        self.__created_by = created_by

    @property
    def cluster_reference(self):
        """`{ str }`
            \nThe UUID of cluster that will host the Volume Group. This is mandatory to be specified for creating a volume group on PC.
        """ # noqa: E501
        return self.__cluster_reference

    @cluster_reference.setter
    def cluster_reference(self, cluster_reference):
        if cluster_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', cluster_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `cluster_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__cluster_reference = cluster_reference

    @property
    def storage_features(self):
        """`{ storage.v4.config.StorageFeatures }`
            
        """ # noqa: E501
        return self.__storage_features

    @storage_features.setter
    def storage_features(self, storage_features):

        self.__storage_features = storage_features

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VolumeGroup, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VolumeGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

