# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.config.EntityReference import EntityReference  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.storage.v4.config.DiskStorageFeatures import DiskStorageFeatures  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VolumeDisk(ExternalizableAbstractModel):
    """VolumeDisk - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'index': 'int',
        'disk_size_bytes': 'int',
        'storage_container_id': 'str',
        'description': 'str',
        'disk_data_source_reference': 'common.v1.config.EntityReference',
        'disk_storage_features': 'storage.v4.config.DiskStorageFeatures',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'index': 'index',
        'disk_size_bytes': 'diskSizeBytes',
        'storage_container_id': 'storageContainerId',
        'description': 'description',
        'disk_data_source_reference': 'diskDataSourceReference',
        'disk_storage_features': 'diskStorageFeatures',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, index=None, disk_size_bytes=None, storage_container_id=None, description=None, disk_data_source_reference=None, disk_storage_features=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """VolumeDisk - a model defined in Swagger
            \nA model that represents volume disk which is associated with a volume group, and is supported by a backing file on DSF.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__index = None
        self.__disk_size_bytes = None
        self.__storage_container_id = None
        self.__description = None
        self.__disk_data_source_reference = None
        self.__disk_storage_features = None
        self.discriminator = None
        if index is not None:
            self.__index = index
        if disk_size_bytes is not None:
            self.__disk_size_bytes = disk_size_bytes
        if storage_container_id is not None:
            self.__storage_container_id = storage_container_id
        if description is not None:
            self.__description = description
        if disk_data_source_reference is not None:
            self.__disk_data_source_reference = disk_data_source_reference
        if disk_storage_features is not None:
            self.__disk_storage_features = disk_storage_features

    def _initialize_object_type(self):
        return 'storage.v4.config.VolumeDisk'

    def _initialize_fq_object_type(self):
        return 'storage.v4.r0.a1.config.VolumeDisk'


    @property
    def index(self):
        """`{ int }`
            \nIndex of the disk in a Volume Group. This field is immutable.
        """ # noqa: E501
        return self.__index

    @index.setter
    def index(self, index):
        if index is not None and index > 16383:  # noqa: E501
            raise ValueError("Invalid value for `index`, must be a value less than or equal to `16383`")  # noqa: E501
        if index is not None and index < 0:  # noqa: E501
            raise ValueError("Invalid value for `index`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__index = index

    @property
    def disk_size_bytes(self):
        """`{ int }`
            \nSize of the disk in bytes.
        """ # noqa: E501
        return self.__disk_size_bytes

    @disk_size_bytes.setter
    def disk_size_bytes(self, disk_size_bytes):
        if disk_size_bytes is not None and disk_size_bytes < 524288:  # noqa: E501
            raise ValueError("Invalid value for `disk_size_bytes`, must be a value greater than or equal to `524288`")  # noqa: E501

        self.__disk_size_bytes = disk_size_bytes

    @property
    def storage_container_id(self):
        """`{ str }`
            \nStorage container on which the disk must be created.
        """ # noqa: E501
        return self.__storage_container_id

    @storage_container_id.setter
    def storage_container_id(self, storage_container_id):
        if storage_container_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', storage_container_id):  # noqa: E501
            raise ValueError(r"Invalid value for `storage_container_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__storage_container_id = storage_container_id

    @property
    def description(self):
        """`{ str }`
            \nDescription of the Volume disk.
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def disk_data_source_reference(self):
        """`{ common.v1.config.EntityReference }`
            
        """ # noqa: E501
        return self.__disk_data_source_reference

    @disk_data_source_reference.setter
    def disk_data_source_reference(self, disk_data_source_reference):

        self.__disk_data_source_reference = disk_data_source_reference

    @property
    def disk_storage_features(self):
        """`{ storage.v4.config.DiskStorageFeatures }`
            
        """ # noqa: E501
        return self.__disk_storage_features

    @disk_storage_features.setter
    def disk_storage_features(self, disk_storage_features):

        self.__disk_storage_features = disk_storage_features

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VolumeDisk, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VolumeDisk):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

