# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.config.IPAddressOrFQDN import IPAddressOrFQDN  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.storage.v4.config.AuthenticationType import AuthenticationType  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.storage.v4.config.TargetParam import TargetParam  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class IscsiClient(ExternalizableAbstractModel):
    """IscsiClient - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'iscsi_initiator_name': 'str',
        'iscsi_initiator_network_id': 'common.v1.config.IPAddressOrFQDN',
        'client_secret': 'str',
        'enabled_authentications': 'storage.v4.config.AuthenticationType',
        'target_params': 'list[storage.v4.config.TargetParam]',
        'cluster_reference': 'str',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'iscsi_initiator_name': 'iscsiInitiatorName',
        'iscsi_initiator_network_id': 'iscsiInitiatorNetworkId',
        'client_secret': 'clientSecret',
        'enabled_authentications': 'enabledAuthentications',
        'target_params': 'targetParams',
        'cluster_reference': 'clusterReference',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, iscsi_initiator_name=None, iscsi_initiator_network_id=None, client_secret=None, enabled_authentications=None, target_params=None, cluster_reference=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """IscsiClient - a model defined in Swagger
            \nA model that represents iSCSI Client that can be associated with a volume group as an external attachment.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__iscsi_initiator_name = None
        self.__iscsi_initiator_network_id = None
        self.__client_secret = None
        self.__enabled_authentications = None
        self.__target_params = None
        self.__cluster_reference = None
        self.discriminator = None
        if iscsi_initiator_name is not None:
            self.__iscsi_initiator_name = iscsi_initiator_name
        if iscsi_initiator_network_id is not None:
            self.__iscsi_initiator_network_id = iscsi_initiator_network_id
        if client_secret is not None:
            self.__client_secret = client_secret
        if enabled_authentications is not None:
            self.__enabled_authentications = enabled_authentications
        if target_params is not None:
            self.__target_params = target_params
        if cluster_reference is not None:
            self.__cluster_reference = cluster_reference

    def _initialize_object_type(self):
        return 'storage.v4.config.IscsiClient'

    def _initialize_fq_object_type(self):
        return 'storage.v4.r0.a1.config.IscsiClient'


    @property
    def iscsi_initiator_name(self):
        """`{ str }`
            \niSCSI Initiator Name.
        """ # noqa: E501
        return self.__iscsi_initiator_name

    @iscsi_initiator_name.setter
    def iscsi_initiator_name(self, iscsi_initiator_name):
        if iscsi_initiator_name is not None and len(iscsi_initiator_name) > 64:
            raise ValueError("Invalid value for `iscsi_initiator_name`, length must be less than or equal to `64`")  # noqa: E501

        self.__iscsi_initiator_name = iscsi_initiator_name

    @property
    def iscsi_initiator_network_id(self):
        """`{ common.v1.config.IPAddressOrFQDN }`
            
        """ # noqa: E501
        return self.__iscsi_initiator_network_id

    @iscsi_initiator_network_id.setter
    def iscsi_initiator_network_id(self, iscsi_initiator_network_id):

        self.__iscsi_initiator_network_id = iscsi_initiator_network_id

    @property
    def client_secret(self):
        """`{ str }`
            \niSCSI initiator Client Secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        """ # noqa: E501
        return self.__client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        if client_secret is not None and len(client_secret) > 16:
            raise ValueError("Invalid value for `client_secret`, length must be less than or equal to `16`")  # noqa: E501
        if client_secret is not None and len(client_secret) < 12:
            raise ValueError("Invalid value for `client_secret`, length must be greater than or equal to `12`")  # noqa: E501

        self.__client_secret = client_secret

    @property
    def enabled_authentications(self):
        """`{ storage.v4.config.AuthenticationType }`
            
        """ # noqa: E501
        return self.__enabled_authentications

    @enabled_authentications.setter
    def enabled_authentications(self, enabled_authentications):

        self.__enabled_authentications = enabled_authentications

    @property
    def target_params(self):
        """`{ list[storage.v4.config.TargetParam] }`
            
        """ # noqa: E501
        return self.__target_params

    @target_params.setter
    def target_params(self, target_params):

        self.__target_params = target_params

    @property
    def cluster_reference(self):
        """`{ str }`
            \nThe UUID of cluster that will host the Volume Group. This is mandatory to be specified for creating a volume group on PC.
        """ # noqa: E501
        return self.__cluster_reference

    @cluster_reference.setter
    def cluster_reference(self, cluster_reference):
        if cluster_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', cluster_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `cluster_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__cluster_reference = cluster_reference

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IscsiClient, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IscsiClient):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

