# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class StorageInfo(object):
    """StorageInfo - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'is_storage_info': 'bool',
        'is_verify_attachments_health': 'bool',
        'vg_set_list': 'list[str]',
        'are_attachments_healthy': 'bool',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'is_storage_info': 'isStorageInfo',
        'is_verify_attachments_health': 'isVerifyAttachmentsHealth',
        'vg_set_list': 'vgSetList',
        'are_attachments_healthy': 'areAttachmentsHealthy',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, is_storage_info=None, is_verify_attachments_health=None, vg_set_list=None, are_attachments_healthy=None, *args, **kwargs):  # noqa: E501
        """StorageInfo - a model defined in Swagger
            \nStorage information model. 
        """
        self.__is_storage_info = None
        self.__is_verify_attachments_health = None
        self.__vg_set_list = None
        self.__are_attachments_healthy = None
        self.discriminator = None
        if is_storage_info is not None:
            self.__is_storage_info = is_storage_info
        if is_verify_attachments_health is not None:
            self.__is_verify_attachments_health = is_verify_attachments_health
        if vg_set_list is not None:
            self.__vg_set_list = vg_set_list
        if are_attachments_healthy is not None:
            self.__are_attachments_healthy = are_attachments_healthy
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'files.v4.infra.StorageInfo'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.infra.StorageInfo'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def is_storage_info(self):
        """`{ bool }`
            \nGet request flag for storage information including volume group list. 
        """ # noqa: E501
        return self.__is_storage_info

    @is_storage_info.setter
    def is_storage_info(self, is_storage_info):

        self.__is_storage_info = is_storage_info

    @property
    def is_verify_attachments_health(self):
        """`{ bool }`
            \nGet request flag for storage health verification of ISCSI or hypervisor attachments. 
        """ # noqa: E501
        return self.__is_verify_attachments_health

    @is_verify_attachments_health.setter
    def is_verify_attachments_health(self, is_verify_attachments_health):

        self.__is_verify_attachments_health = is_verify_attachments_health

    @property
    def vg_set_list(self):
        """`{ list[str] }`
            \nList of volume groups set UUIDs for the file server. 
        """ # noqa: E501
        return self.__vg_set_list

    @vg_set_list.setter
    def vg_set_list(self, vg_set_list):

        self.__vg_set_list = vg_set_list

    @property
    def are_attachments_healthy(self):
        """`{ bool }`
            \nFlag that represents whether the storage attachments are healthy. 
        """ # noqa: E501
        return self.__are_attachments_healthy

    @are_attachments_healthy.setter
    def are_attachments_healthy(self, are_attachments_healthy):

        self.__are_attachments_healthy = are_attachments_healthy

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StorageInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StorageInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

