# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.config.IPv4Address import IPv4Address  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class PcConfig(object):
    """PcConfig - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'virtual_ip_address': 'common.v1.config.IPv4Address',
        'node_ips': 'list[common.v1.config.IPv4Address]',
        'fm_version': 'str',
        'pc_version': 'str',
        'ssh_public_keys': 'list[str]',
        'pc_cluster_ext_id': 'str',
        'pc_api_user': 'str',
        'pc_api_password': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'virtual_ip_address': 'virtualIpAddress',
        'node_ips': 'nodeIps',
        'fm_version': 'fmVersion',
        'pc_version': 'pcVersion',
        'ssh_public_keys': 'sshPublicKeys',
        'pc_cluster_ext_id': 'pcClusterExtId',
        'pc_api_user': 'pcApiUser',
        'pc_api_password': 'pcApiPassword',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, virtual_ip_address=None, node_ips=None, fm_version=None, pc_version=None, ssh_public_keys=None, pc_cluster_ext_id=None, pc_api_user=None, pc_api_password=None, *args, **kwargs):  # noqa: E501
        """PcConfig - a model defined in Swagger
            \nPrism central configuration model. 
        """
        self.__virtual_ip_address = None
        self.__node_ips = None
        self.__fm_version = None
        self.__pc_version = None
        self.__ssh_public_keys = None
        self.__pc_cluster_ext_id = None
        self.__pc_api_user = None
        self.__pc_api_password = None
        self.discriminator = None
        if virtual_ip_address is not None:
            self.__virtual_ip_address = virtual_ip_address
        if node_ips is not None:
            self.__node_ips = node_ips
        if fm_version is not None:
            self.__fm_version = fm_version
        if pc_version is not None:
            self.__pc_version = pc_version
        if ssh_public_keys is not None:
            self.__ssh_public_keys = ssh_public_keys
        if pc_cluster_ext_id is not None:
            self.__pc_cluster_ext_id = pc_cluster_ext_id
        if pc_api_user is not None:
            self.__pc_api_user = pc_api_user
        if pc_api_password is not None:
            self.__pc_api_password = pc_api_password
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'files.v4.infra.PcConfig'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.infra.PcConfig'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def virtual_ip_address(self):
        """`{ common.v1.config.IPv4Address }`
            
        """ # noqa: E501
        return self.__virtual_ip_address

    @virtual_ip_address.setter
    def virtual_ip_address(self, virtual_ip_address):

        self.__virtual_ip_address = virtual_ip_address

    @property
    def node_ips(self):
        """`{ list[common.v1.config.IPv4Address] }`
            \nPrism central node IP address list. 
        """ # noqa: E501
        return self.__node_ips

    @node_ips.setter
    def node_ips(self, node_ips):

        self.__node_ips = node_ips

    @property
    def fm_version(self):
        """`{ str }`
            \nFiles manager version. 
        """ # noqa: E501
        return self.__fm_version

    @fm_version.setter
    def fm_version(self, fm_version):

        self.__fm_version = fm_version

    @property
    def pc_version(self):
        """`{ str }`
            \nPrism central version. 
        """ # noqa: E501
        return self.__pc_version

    @pc_version.setter
    def pc_version(self, pc_version):

        self.__pc_version = pc_version

    @property
    def ssh_public_keys(self):
        """`{ list[str] }`
            \nPrism central SSH public keys. 
        """ # noqa: E501
        return self.__ssh_public_keys

    @ssh_public_keys.setter
    def ssh_public_keys(self, ssh_public_keys):

        self.__ssh_public_keys = ssh_public_keys

    @property
    def pc_cluster_ext_id(self):
        """`{ str }`
            \nThe Prism central UUID. 
        """ # noqa: E501
        return self.__pc_cluster_ext_id

    @pc_cluster_ext_id.setter
    def pc_cluster_ext_id(self, pc_cluster_ext_id):
        if pc_cluster_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', pc_cluster_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `pc_cluster_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__pc_cluster_ext_id = pc_cluster_ext_id

    @property
    def pc_api_user(self):
        """`{ str }`
            \nUsername for Prism central API authentications. 
        """ # noqa: E501
        return self.__pc_api_user

    @pc_api_user.setter
    def pc_api_user(self, pc_api_user):

        self.__pc_api_user = pc_api_user

    @property
    def pc_api_password(self):
        """`{ str }`
            \nPassword for Prism central API authentications. 
        """ # noqa: E501
        return self.__pc_api_password

    @pc_api_password.setter
    def pc_api_password(self, pc_api_password):

        self.__pc_api_password = pc_api_password

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PcConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PcConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

