# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.infra.AttachmentType import AttachmentType  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.infra.FilesVolumeGroup import FilesVolumeGroup  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class FileServerStorageSpec(ExternalizableAbstractModel):
    """FileServerStorageSpec - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'file_server_ext_id': 'str',
        'task_ext_id': 'str',
        'attachment_type': 'files.v4.infra.AttachmentType',
        'volume_groups': 'list[files.v4.infra.FilesVolumeGroup]',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'file_server_ext_id': 'fileServerExtId',
        'task_ext_id': 'taskExtId',
        'attachment_type': 'attachmentType',
        'volume_groups': 'volumeGroups',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, file_server_ext_id=None, task_ext_id=None, attachment_type=None, volume_groups=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """FileServerStorageSpec - a model defined in Swagger
            \nA model that represents the file server storage specification - a set of volume groups with volume disks and ISCSI clients.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__file_server_ext_id = None
        self.__task_ext_id = None
        self.__attachment_type = None
        self.__volume_groups = None
        self.discriminator = None
        self.__file_server_ext_id = file_server_ext_id
        if task_ext_id is not None:
            self.__task_ext_id = task_ext_id
        self.__attachment_type = attachment_type
        self.__volume_groups = volume_groups

    def _initialize_object_type(self):
        return 'files.v4.infra.FileServerStorageSpec'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.infra.FileServerStorageSpec'


    @property
    def file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the file server. This is a read-only field.
        """ # noqa: E501
        return self.__file_server_ext_id

    @file_server_ext_id.setter
    def file_server_ext_id(self, file_server_ext_id):
        if file_server_ext_id is None:
            raise ValueError("Invalid value for `file_server_ext_id`, must not be `None`")  # noqa: E501
        if file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__file_server_ext_id = file_server_ext_id

    @property
    def task_ext_id(self):
        """`{ str }`
            \nExtId of the task.
        """ # noqa: E501
        return self.__task_ext_id

    @task_ext_id.setter
    def task_ext_id(self, task_ext_id):
        if task_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', task_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `task_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__task_ext_id = task_ext_id

    @property
    def attachment_type(self):
        """`{ files.v4.infra.AttachmentType }`
            
        """ # noqa: E501
        return self.__attachment_type

    @attachment_type.setter
    def attachment_type(self, attachment_type):
        if attachment_type is None:
            raise ValueError("Invalid value for `attachment_type`, must not be `None`")  # noqa: E501

        self.__attachment_type = attachment_type

    @property
    def volume_groups(self):
        """`{ list[files.v4.infra.FilesVolumeGroup] }`
            \nList of volume group objects.
        """ # noqa: E501
        return self.__volume_groups

    @volume_groups.setter
    def volume_groups(self, volume_groups):
        if volume_groups is None:
            raise ValueError("Invalid value for `volume_groups`, must not be `None`")  # noqa: E501

        self.__volume_groups = volume_groups

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FileServerStorageSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileServerStorageSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

