# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.files.v4.infra.CaCert import CaCert  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class CaChain(object):
    """CaChain - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'ca_certificate_list': 'list[str]',
        'owner_cluster_ext_id': 'str',
        'additional_ca_cert_list': 'list[files.v4.infra.CaCert]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'ca_certificate_list': 'caCertificateList',
        'owner_cluster_ext_id': 'ownerClusterExtId',
        'additional_ca_cert_list': 'additionalCaCertList',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, ca_certificate_list=None, owner_cluster_ext_id=None, additional_ca_cert_list=None, *args, **kwargs):  # noqa: E501
        """CaChain - a model defined in Swagger
            \nCertificate chain to verify TLS certificates. 
        """
        self.__ca_certificate_list = None
        self.__owner_cluster_ext_id = None
        self.__additional_ca_cert_list = None
        self.discriminator = None
        if ca_certificate_list is not None:
            self.__ca_certificate_list = ca_certificate_list
        if owner_cluster_ext_id is not None:
            self.__owner_cluster_ext_id = owner_cluster_ext_id
        if additional_ca_cert_list is not None:
            self.__additional_ca_cert_list = additional_ca_cert_list
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'files.v4.infra.CaChain'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.infra.CaChain'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def ca_certificate_list(self):
        """`{ list[str] }`
            \nList of TLS certificates for root CA and ICA. 
        """ # noqa: E501
        return self.__ca_certificate_list

    @ca_certificate_list.setter
    def ca_certificate_list(self, ca_certificate_list):

        self.__ca_certificate_list = ca_certificate_list

    @property
    def owner_cluster_ext_id(self):
        """`{ str }`
            \nCluster UUID that owns the certificates. 
        """ # noqa: E501
        return self.__owner_cluster_ext_id

    @owner_cluster_ext_id.setter
    def owner_cluster_ext_id(self, owner_cluster_ext_id):
        if owner_cluster_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', owner_cluster_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `owner_cluster_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__owner_cluster_ext_id = owner_cluster_ext_id

    @property
    def additional_ca_cert_list(self):
        """`{ list[files.v4.infra.CaCert] }`
            \nAdditional CA certificates to be trusted. 
        """ # noqa: E501
        return self.__additional_ca_cert_list

    @additional_ca_cert_list.setter
    def additional_ca_cert_list(self, additional_ca_cert_list):

        self.__additional_ca_cert_list = additional_ca_cert_list

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CaChain, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CaChain):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

