# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VirusScanPolicy(ExternalizableAbstractModel):
    """VirusScanPolicy - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'file_server_ext_id': 'str',
        'scan_timeout_interval_in_secs': 'int',
        'scan_on_write': 'bool',
        'scan_on_read': 'bool',
        'file_size_exclusion_in_bytes': 'int',
        'block_access_file': 'bool',
        'enable_anti_virus': 'bool',
        'file_type_exclusions': 'list[str]',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'file_server_ext_id': 'fileServerExtId',
        'scan_timeout_interval_in_secs': 'scanTimeoutIntervalInSecs',
        'scan_on_write': 'scanOnWrite',
        'scan_on_read': 'scanOnRead',
        'file_size_exclusion_in_bytes': 'fileSizeExclusionInBytes',
        'block_access_file': 'blockAccessFile',
        'enable_anti_virus': 'enableAntiVirus',
        'file_type_exclusions': 'fileTypeExclusions',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, file_server_ext_id=None, scan_timeout_interval_in_secs=None, scan_on_write=None, scan_on_read=None, file_size_exclusion_in_bytes=None, block_access_file=None, enable_anti_virus=None, file_type_exclusions=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """VirusScanPolicy - a model defined in Swagger
            \nAntivirus server scan policy information.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__file_server_ext_id = None
        self.__scan_timeout_interval_in_secs = None
        self.__scan_on_write = None
        self.__scan_on_read = None
        self.__file_size_exclusion_in_bytes = None
        self.__block_access_file = None
        self.__enable_anti_virus = None
        self.__file_type_exclusions = None
        self.discriminator = None
        if file_server_ext_id is not None:
            self.__file_server_ext_id = file_server_ext_id
        if scan_timeout_interval_in_secs is not None:
            self.__scan_timeout_interval_in_secs = scan_timeout_interval_in_secs
        if scan_on_write is not None:
            self.__scan_on_write = scan_on_write
        if scan_on_read is not None:
            self.__scan_on_read = scan_on_read
        if file_size_exclusion_in_bytes is not None:
            self.__file_size_exclusion_in_bytes = file_size_exclusion_in_bytes
        if block_access_file is not None:
            self.__block_access_file = block_access_file
        if enable_anti_virus is not None:
            self.__enable_anti_virus = enable_anti_virus
        if file_type_exclusions is not None:
            self.__file_type_exclusions = file_type_exclusions

    def _initialize_object_type(self):
        return 'files.v4.config.VirusScanPolicy'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.VirusScanPolicy'


    @property
    def file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the file server. This is a read-only field.
        """ # noqa: E501
        return self.__file_server_ext_id

    @file_server_ext_id.setter
    def file_server_ext_id(self, file_server_ext_id):
        if file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__file_server_ext_id = file_server_ext_id

    @property
    def scan_timeout_interval_in_secs(self):
        """`{ int }`
            \nScan time interval in seconds.
        """ # noqa: E501
        return self.__scan_timeout_interval_in_secs

    @scan_timeout_interval_in_secs.setter
    def scan_timeout_interval_in_secs(self, scan_timeout_interval_in_secs):
        if scan_timeout_interval_in_secs is not None and scan_timeout_interval_in_secs < 0:  # noqa: E501
            raise ValueError("Invalid value for `scan_timeout_interval_in_secs`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__scan_timeout_interval_in_secs = scan_timeout_interval_in_secs

    @property
    def scan_on_write(self):
        """`{ bool }`
            \nScan on write policy.
        """ # noqa: E501
        return self.__scan_on_write

    @scan_on_write.setter
    def scan_on_write(self, scan_on_write):

        self.__scan_on_write = scan_on_write

    @property
    def scan_on_read(self):
        """`{ bool }`
            \nScan on read policy.
        """ # noqa: E501
        return self.__scan_on_read

    @scan_on_read.setter
    def scan_on_read(self, scan_on_read):

        self.__scan_on_read = scan_on_read

    @property
    def file_size_exclusion_in_bytes(self):
        """`{ int }`
            \nFile size exclusion. It is the size of a file below which AV scan won't run. Default value is 0 (run on all files).
        """ # noqa: E501
        return self.__file_size_exclusion_in_bytes

    @file_size_exclusion_in_bytes.setter
    def file_size_exclusion_in_bytes(self, file_size_exclusion_in_bytes):
        if file_size_exclusion_in_bytes is not None and file_size_exclusion_in_bytes < 0:  # noqa: E501
            raise ValueError("Invalid value for `file_size_exclusion_in_bytes`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__file_size_exclusion_in_bytes = file_size_exclusion_in_bytes

    @property
    def block_access_file(self):
        """`{ bool }`
            \nIndicates if the file access needs to be blocked for current policy.
        """ # noqa: E501
        return self.__block_access_file

    @block_access_file.setter
    def block_access_file(self, block_access_file):

        self.__block_access_file = block_access_file

    @property
    def enable_anti_virus(self):
        """`{ bool }`
            \nIndicates if the antivirus server is enabled for current policy.
        """ # noqa: E501
        return self.__enable_anti_virus

    @enable_anti_virus.setter
    def enable_anti_virus(self, enable_anti_virus):

        self.__enable_anti_virus = enable_anti_virus

    @property
    def file_type_exclusions(self):
        """`{ list[str] }`
            \nFile type exclusion list.
        """ # noqa: E501
        return self.__file_type_exclusions

    @file_type_exclusions.setter
    def file_type_exclusions(self, file_type_exclusions):

        self.__file_type_exclusions = file_type_exclusions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VirusScanPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirusScanPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

