# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.files.v4.config.VMNetwork import VMNetwork  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VM(object):
    """VM - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'ext_id': 'str',
        'fsvm_uuid': 'str',
        'name': 'str',
        'memory_gib': 'int',
        'vcpus': 'int',
        'internal_networks': 'list[files.v4.config.VMNetwork]',
        'external_networks': 'list[files.v4.config.VMNetwork]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'ext_id': 'extId',
        'fsvm_uuid': 'fsvmUuid',
        'name': 'name',
        'memory_gib': 'memoryGib',
        'vcpus': 'vcpus',
        'internal_networks': 'internalNetworks',
        'external_networks': 'externalNetworks',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, ext_id=None, fsvm_uuid=None, name=None, memory_gib=12, vcpus=4, internal_networks=None, external_networks=None, *args, **kwargs):  # noqa: E501
        """VM - a model defined in Swagger
            \nFile server VM object.
        """
        self.__ext_id = None
        self.__fsvm_uuid = None
        self.__name = None
        self.__memory_gib = None
        self.__vcpus = None
        self.__internal_networks = None
        self.__external_networks = None
        self.discriminator = None
        if ext_id is not None:
            self.__ext_id = ext_id
        if fsvm_uuid is not None:
            self.__fsvm_uuid = fsvm_uuid
        if name is not None:
            self.__name = name
        if memory_gib is not None:
            self.__memory_gib = memory_gib
        if vcpus is not None:
            self.__vcpus = vcpus
        if internal_networks is not None:
            self.__internal_networks = internal_networks
        if external_networks is not None:
            self.__external_networks = external_networks
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'files.v4.config.VM'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.VM'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def ext_id(self):
        """`{ str }`
            \nAcropolis UUID of the file server VM. This is a read-only field.
        """ # noqa: E501
        return self.__ext_id

    @ext_id.setter
    def ext_id(self, ext_id):
        if ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__ext_id = ext_id

    @property
    def fsvm_uuid(self):
        """`{ str }`
            \nFSVM UUID of the file server VM.
        """ # noqa: E501
        return self.__fsvm_uuid

    @fsvm_uuid.setter
    def fsvm_uuid(self, fsvm_uuid):
        if fsvm_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', fsvm_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `fsvm_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__fsvm_uuid = fsvm_uuid

    @property
    def name(self):
        """`{ str }`
            \nName of the file server VM.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is not None and len(name) > 30:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `30`")  # noqa: E501

        self.__name = name

    @property
    def memory_gib(self):
        """`{ int }`
            \nMemory associated with the file server VM.
        """ # noqa: E501
        return self.__memory_gib

    @memory_gib.setter
    def memory_gib(self, memory_gib):

        self.__memory_gib = memory_gib

    @property
    def vcpus(self):
        """`{ int }`
            \nCPU associated with the file server VM.
        """ # noqa: E501
        return self.__vcpus

    @vcpus.setter
    def vcpus(self, vcpus):

        self.__vcpus = vcpus

    @property
    def internal_networks(self):
        """`{ list[files.v4.config.VMNetwork] }`
            \nList of internal networks associated with the file server VM.
        """ # noqa: E501
        return self.__internal_networks

    @internal_networks.setter
    def internal_networks(self, internal_networks):

        self.__internal_networks = internal_networks

    @property
    def external_networks(self):
        """`{ list[files.v4.config.VMNetwork] }`
            \nList of external networks associated with the file server VM.
        """ # noqa: E501
        return self.__external_networks

    @external_networks.setter
    def external_networks(self, external_networks):

        self.__external_networks = external_networks

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VM, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VM):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

