# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class TieringPolicy(ExternalizableAbstractModel):
    """TieringPolicy - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'cooloff_period_in_seconds': 'int',
        'minimum_file_size_in_bytes': 'int',
        'is_include_future_shares': 'bool',
        'mount_target_ext_ids': 'list[str]',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'cooloff_period_in_seconds': 'cooloffPeriodInSeconds',
        'minimum_file_size_in_bytes': 'minimumFileSizeInBytes',
        'is_include_future_shares': 'isIncludeFutureShares',
        'mount_target_ext_ids': 'mountTargetExtIds',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, cooloff_period_in_seconds=None, minimum_file_size_in_bytes=65536, is_include_future_shares=None, mount_target_ext_ids=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """TieringPolicy - a model defined in Swagger
            \nTiering policy model
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__cooloff_period_in_seconds = None
        self.__minimum_file_size_in_bytes = None
        self.__is_include_future_shares = None
        self.__mount_target_ext_ids = None
        self.discriminator = None
        if cooloff_period_in_seconds is not None:
            self.__cooloff_period_in_seconds = cooloff_period_in_seconds
        if minimum_file_size_in_bytes is not None:
            self.__minimum_file_size_in_bytes = minimum_file_size_in_bytes
        if is_include_future_shares is not None:
            self.__is_include_future_shares = is_include_future_shares
        if mount_target_ext_ids is not None:
            self.__mount_target_ext_ids = mount_target_ext_ids

    def _initialize_object_type(self):
        return 'files.v4.config.TieringPolicy'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.TieringPolicy'


    @property
    def cooloff_period_in_seconds(self):
        """`{ int }`
            \nCool off period in seconds for tiering. Files older than a this time will be considered for tiering.
        """ # noqa: E501
        return self.__cooloff_period_in_seconds

    @cooloff_period_in_seconds.setter
    def cooloff_period_in_seconds(self, cooloff_period_in_seconds):
        if cooloff_period_in_seconds is not None and cooloff_period_in_seconds < 86400:  # noqa: E501
            raise ValueError("Invalid value for `cooloff_period_in_seconds`, must be a value greater than or equal to `86400`")  # noqa: E501

        self.__cooloff_period_in_seconds = cooloff_period_in_seconds

    @property
    def minimum_file_size_in_bytes(self):
        """`{ int }`
            \nMinimum file size for tiering. Files size greater than this will be considered for tiering.
        """ # noqa: E501
        return self.__minimum_file_size_in_bytes

    @minimum_file_size_in_bytes.setter
    def minimum_file_size_in_bytes(self, minimum_file_size_in_bytes):
        if minimum_file_size_in_bytes is not None and minimum_file_size_in_bytes < 65536:  # noqa: E501
            raise ValueError("Invalid value for `minimum_file_size_in_bytes`, must be a value greater than or equal to `65536`")  # noqa: E501

        self.__minimum_file_size_in_bytes = minimum_file_size_in_bytes

    @property
    def is_include_future_shares(self):
        """`{ bool }`
            \nIndicates whether to include future shares to the tiering policy.
        """ # noqa: E501
        return self.__is_include_future_shares

    @is_include_future_shares.setter
    def is_include_future_shares(self, is_include_future_shares):

        self.__is_include_future_shares = is_include_future_shares

    @property
    def mount_target_ext_ids(self):
        """`{ list[str] }`
            \nThe {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        """ # noqa: E501
        return self.__mount_target_ext_ids

    @mount_target_ext_ids.setter
    def mount_target_ext_ids(self, mount_target_ext_ids):

        self.__mount_target_ext_ids = mount_target_ext_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TieringPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TieringPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

