# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.EnableMountTargets import EnableMountTargets  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.TieringObjectStoreType import TieringObjectStoreType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class TieringObjectStoreProfile(ExternalizableAbstractModel):
    """TieringObjectStoreProfile - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'file_server_ext_id': 'str',
        'mount_target_ext_ids': 'list[str]',
        'tiering_object_store_type': 'files.v4.config.TieringObjectStoreType',
        'profile_name': 'str',
        'access_key': 'str',
        'secret_key': 'str',
        'base_url': 'str',
        'bucket_name': 'str',
        'ca_cert_content': 'str',
        'enable_ssl_verify_peer': 'bool',
        'enable_mount_targets': 'files.v4.config.EnableMountTargets',
        'retention_period': 'int',
        'proxy_server': 'str',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'file_server_ext_id': 'fileServerExtId',
        'mount_target_ext_ids': 'mountTargetExtIds',
        'tiering_object_store_type': 'tieringObjectStoreType',
        'profile_name': 'profileName',
        'access_key': 'accessKey',
        'secret_key': 'secretKey',
        'base_url': 'baseUrl',
        'bucket_name': 'bucketName',
        'ca_cert_content': 'caCertContent',
        'enable_ssl_verify_peer': 'enableSslVerifyPeer',
        'enable_mount_targets': 'enableMountTargets',
        'retention_period': 'retentionPeriod',
        'proxy_server': 'proxyServer',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, file_server_ext_id=None, mount_target_ext_ids=None, tiering_object_store_type=None, profile_name=None, access_key=None, secret_key=None, base_url=None, bucket_name=None, ca_cert_content=None, enable_ssl_verify_peer=None, enable_mount_targets=None, retention_period=1825, proxy_server=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """TieringObjectStoreProfile - a model defined in Swagger
            \nObject store profile specification.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__file_server_ext_id = None
        self.__mount_target_ext_ids = None
        self.__tiering_object_store_type = None
        self.__profile_name = None
        self.__access_key = None
        self.__secret_key = None
        self.__base_url = None
        self.__bucket_name = None
        self.__ca_cert_content = None
        self.__enable_ssl_verify_peer = None
        self.__enable_mount_targets = None
        self.__retention_period = None
        self.__proxy_server = None
        self.discriminator = None
        if file_server_ext_id is not None:
            self.__file_server_ext_id = file_server_ext_id
        if mount_target_ext_ids is not None:
            self.__mount_target_ext_ids = mount_target_ext_ids
        if tiering_object_store_type is not None:
            self.__tiering_object_store_type = tiering_object_store_type
        if profile_name is not None:
            self.__profile_name = profile_name
        if access_key is not None:
            self.__access_key = access_key
        if secret_key is not None:
            self.__secret_key = secret_key
        if base_url is not None:
            self.__base_url = base_url
        if bucket_name is not None:
            self.__bucket_name = bucket_name
        if ca_cert_content is not None:
            self.__ca_cert_content = ca_cert_content
        if enable_ssl_verify_peer is not None:
            self.__enable_ssl_verify_peer = enable_ssl_verify_peer
        if enable_mount_targets is not None:
            self.__enable_mount_targets = enable_mount_targets
        if retention_period is not None:
            self.__retention_period = retention_period
        if proxy_server is not None:
            self.__proxy_server = proxy_server

    def _initialize_object_type(self):
        return 'files.v4.config.TieringObjectStoreProfile'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.TieringObjectStoreProfile'


    @property
    def file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the file server. This is a read-only field.
        """ # noqa: E501
        return self.__file_server_ext_id

    @file_server_ext_id.setter
    def file_server_ext_id(self, file_server_ext_id):
        if file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__file_server_ext_id = file_server_ext_id

    @property
    def mount_target_ext_ids(self):
        """`{ list[str] }`
            \nThe {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        """ # noqa: E501
        return self.__mount_target_ext_ids

    @mount_target_ext_ids.setter
    def mount_target_ext_ids(self, mount_target_ext_ids):

        self.__mount_target_ext_ids = mount_target_ext_ids

    @property
    def tiering_object_store_type(self):
        """`{ files.v4.config.TieringObjectStoreType }`
            
        """ # noqa: E501
        return self.__tiering_object_store_type

    @tiering_object_store_type.setter
    def tiering_object_store_type(self, tiering_object_store_type):

        self.__tiering_object_store_type = tiering_object_store_type

    @property
    def profile_name(self):
        """`{ str }`
            \nObject store cloud profile name
        """ # noqa: E501
        return self.__profile_name

    @profile_name.setter
    def profile_name(self, profile_name):
        if profile_name is not None and len(profile_name) > 63:
            raise ValueError("Invalid value for `profile_name`, length must be less than or equal to `63`")  # noqa: E501

        self.__profile_name = profile_name

    @property
    def access_key(self):
        """`{ str }`
            \nAccess key
        """ # noqa: E501
        return self.__access_key

    @access_key.setter
    def access_key(self, access_key):

        self.__access_key = access_key

    @property
    def secret_key(self):
        """`{ str }`
            \nSecret key
        """ # noqa: E501
        return self.__secret_key

    @secret_key.setter
    def secret_key(self, secret_key):

        self.__secret_key = secret_key

    @property
    def base_url(self):
        """`{ str }`
            \nBase URL
        """ # noqa: E501
        return self.__base_url

    @base_url.setter
    def base_url(self, base_url):

        self.__base_url = base_url

    @property
    def bucket_name(self):
        """`{ str }`
            \nBucket name
        """ # noqa: E501
        return self.__bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        if bucket_name is not None and len(bucket_name) > 63:
            raise ValueError("Invalid value for `bucket_name`, length must be less than or equal to `63`")  # noqa: E501
        if bucket_name is not None and len(bucket_name) < 3:
            raise ValueError("Invalid value for `bucket_name`, length must be greater than or equal to `3`")  # noqa: E501

        self.__bucket_name = bucket_name

    @property
    def ca_cert_content(self):
        """`{ str }`
            \nCA certificate
        """ # noqa: E501
        return self.__ca_cert_content

    @ca_cert_content.setter
    def ca_cert_content(self, ca_cert_content):

        self.__ca_cert_content = ca_cert_content

    @property
    def enable_ssl_verify_peer(self):
        """`{ bool }`
            \nEnable SSL verify peer certificate
        """ # noqa: E501
        return self.__enable_ssl_verify_peer

    @enable_ssl_verify_peer.setter
    def enable_ssl_verify_peer(self, enable_ssl_verify_peer):

        self.__enable_ssl_verify_peer = enable_ssl_verify_peer

    @property
    def enable_mount_targets(self):
        """`{ files.v4.config.EnableMountTargets }`
            
        """ # noqa: E501
        return self.__enable_mount_targets

    @enable_mount_targets.setter
    def enable_mount_targets(self, enable_mount_targets):

        self.__enable_mount_targets = enable_mount_targets

    @property
    def retention_period(self):
        """`{ int }`
            \nTime in days for which the data will be maintained in the cloud after it is deleted from local storage on the file server.
        """ # noqa: E501
        return self.__retention_period

    @retention_period.setter
    def retention_period(self, retention_period):
        if retention_period is not None and retention_period < 0:  # noqa: E501
            raise ValueError("Invalid value for `retention_period`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__retention_period = retention_period

    @property
    def proxy_server(self):
        """`{ str }`
            \nHTTP proxy server address
        """ # noqa: E501
        return self.__proxy_server

    @proxy_server.setter
    def proxy_server(self, proxy_server):

        self.__proxy_server = proxy_server

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TieringObjectStoreProfile, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TieringObjectStoreProfile):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

