# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class TierFileInfo(object):
    """TierFileInfo - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'is_single_dir_tree': 'bool',
        'single_dir_tree': 'bool',
        'mount_target_ext_id': 'str',
        'file_path': 'list[str]',
        'i_node_number': 'list[str]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'is_single_dir_tree': 'isSingleDirTree',
        'single_dir_tree': 'singleDirTree',
        'mount_target_ext_id': 'mountTargetExtId',
        'file_path': 'filePath',
        'i_node_number': 'iNodeNumber',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, is_single_dir_tree=None, single_dir_tree=None, mount_target_ext_id=None, file_path=None, i_node_number=None, *args, **kwargs):  # noqa: E501
        """TierFileInfo - a model defined in Swagger
            \nRequest body specification for tier, recall and tier status APIs.
        """
        self.__is_single_dir_tree = None
        self.__single_dir_tree = None
        self.__mount_target_ext_id = None
        self.__file_path = None
        self.__i_node_number = None
        self.discriminator = None
        if is_single_dir_tree is not None:
            self.__is_single_dir_tree = is_single_dir_tree
        if single_dir_tree is not None:
            self.__single_dir_tree = single_dir_tree
        self.__mount_target_ext_id = mount_target_ext_id
        if file_path is not None:
            self.__file_path = file_path
        if i_node_number is not None:
            self.__i_node_number = i_node_number
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'files.v4.config.TierFileInfo'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.TierFileInfo'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def is_single_dir_tree(self):
        """`{ bool }`
            \nBoolean to indicate if all files belong to the same VG.
        """ # noqa: E501
        return self.__is_single_dir_tree

    @is_single_dir_tree.setter
    def is_single_dir_tree(self, is_single_dir_tree):

        self.__is_single_dir_tree = is_single_dir_tree

    @property
    def single_dir_tree(self):
        """`{ bool }`
            \nBoolean to indicate if all files belong to the same VG. This field will be deferred in future.
        """ # noqa: E501
        return self.__single_dir_tree

    @single_dir_tree.setter
    def single_dir_tree(self, single_dir_tree):

        self.__single_dir_tree = single_dir_tree

    @property
    def mount_target_ext_id(self):
        """`{ str }`
            \nThe {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        """ # noqa: E501
        return self.__mount_target_ext_id

    @mount_target_ext_id.setter
    def mount_target_ext_id(self, mount_target_ext_id):
        if mount_target_ext_id is None:
            raise ValueError("Invalid value for `mount_target_ext_id`, must not be `None`")  # noqa: E501
        if mount_target_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', mount_target_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `mount_target_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__mount_target_ext_id = mount_target_ext_id

    @property
    def file_path(self):
        """`{ list[str] }`
            \nPath of the file to be tiered relative to root Mount target.
        """ # noqa: E501
        return self.__file_path

    @file_path.setter
    def file_path(self, file_path):

        self.__file_path = file_path

    @property
    def i_node_number(self):
        """`{ list[str] }`
            \nList of inode numbers strings. Inode number should be in the format Inode/Inode:GenId.
        """ # noqa: E501
        return self.__i_node_number

    @i_node_number.setter
    def i_node_number(self, i_node_number):

        self.__i_node_number = i_node_number

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TierFileInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TierFileInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

