# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.files.v4.config.PolicyStatus import PolicyStatus  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.ProtectedEntity import ProtectedEntity  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.ReplicationSummary import ReplicationSummary  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.Schedule import Schedule  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class SubPolicy(object):
    """SubPolicy - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'ext_id': 'str',
        'source_file_server_ext_id': 'str',
        'target_file_server_ext_id': 'str',
        'protected_entities': 'list[files.v4.config.ProtectedEntity]',
        'schedules': 'list[files.v4.config.Schedule]',
        'include_new_mount_targets': 'bool',
        'is_reverse_policy': 'bool',
        'policy_status': 'files.v4.config.PolicyStatus',
        'replication_summary': 'files.v4.config.ReplicationSummary',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'ext_id': 'extId',
        'source_file_server_ext_id': 'sourceFileServerExtId',
        'target_file_server_ext_id': 'targetFileServerExtId',
        'protected_entities': 'protectedEntities',
        'schedules': 'schedules',
        'include_new_mount_targets': 'includeNewMountTargets',
        'is_reverse_policy': 'isReversePolicy',
        'policy_status': 'policyStatus',
        'replication_summary': 'replicationSummary',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, ext_id=None, source_file_server_ext_id=None, target_file_server_ext_id=None, protected_entities=None, schedules=None, include_new_mount_targets=True, is_reverse_policy=False, policy_status=None, replication_summary=None, *args, **kwargs):  # noqa: E501
        """SubPolicy - a model defined in Swagger
            \nThis contains list of sub policies. Sub policy is combination of sourceEntity, targetEntity and sourceTargetMap.
        """
        self.__ext_id = None
        self.__source_file_server_ext_id = None
        self.__target_file_server_ext_id = None
        self.__protected_entities = None
        self.__schedules = None
        self.__include_new_mount_targets = None
        self.__is_reverse_policy = None
        self.__policy_status = None
        self.__replication_summary = None
        self.discriminator = None
        if ext_id is not None:
            self.__ext_id = ext_id
        self.__source_file_server_ext_id = source_file_server_ext_id
        self.__target_file_server_ext_id = target_file_server_ext_id
        if protected_entities is not None:
            self.__protected_entities = protected_entities
        if schedules is not None:
            self.__schedules = schedules
        if include_new_mount_targets is not None:
            self.__include_new_mount_targets = include_new_mount_targets
        if is_reverse_policy is not None:
            self.__is_reverse_policy = is_reverse_policy
        if policy_status is not None:
            self.__policy_status = policy_status
        if replication_summary is not None:
            self.__replication_summary = replication_summary
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'files.v4.config.SubPolicy'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.SubPolicy'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def ext_id(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__ext_id

    @ext_id.setter
    def ext_id(self, ext_id):
        if ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__ext_id = ext_id

    @property
    def source_file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the file server. This is a read-only field.
        """ # noqa: E501
        return self.__source_file_server_ext_id

    @source_file_server_ext_id.setter
    def source_file_server_ext_id(self, source_file_server_ext_id):
        if source_file_server_ext_id is None:
            raise ValueError("Invalid value for `source_file_server_ext_id`, must not be `None`")  # noqa: E501
        if source_file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', source_file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `source_file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__source_file_server_ext_id = source_file_server_ext_id

    @property
    def target_file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the target file server. This is a read-only field.
        """ # noqa: E501
        return self.__target_file_server_ext_id

    @target_file_server_ext_id.setter
    def target_file_server_ext_id(self, target_file_server_ext_id):
        if target_file_server_ext_id is None:
            raise ValueError("Invalid value for `target_file_server_ext_id`, must not be `None`")  # noqa: E501
        if target_file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', target_file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `target_file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__target_file_server_ext_id = target_file_server_ext_id

    @property
    def protected_entities(self):
        """`{ list[files.v4.config.ProtectedEntity] }`
            \nThis contains list of source target entity belongs to a sub policy.
        """ # noqa: E501
        return self.__protected_entities

    @protected_entities.setter
    def protected_entities(self, protected_entities):

        self.__protected_entities = protected_entities

    @property
    def schedules(self):
        """`{ list[files.v4.config.Schedule] }`
            \nThis contains details of snapshot schedules. It contains the start time of the replication and frequency of the replication.
        """ # noqa: E501
        return self.__schedules

    @schedules.setter
    def schedules(self, schedules):

        self.__schedules = schedules

    @property
    def include_new_mount_targets(self):
        """`{ bool }`
            \nThis field talks about if all the mount targets in file server are included in the policy. By default it is always true.If specific mount targets are selected then we should mark this field as false.
        """ # noqa: E501
        return self.__include_new_mount_targets

    @include_new_mount_targets.setter
    def include_new_mount_targets(self, include_new_mount_targets):

        self.__include_new_mount_targets = include_new_mount_targets

    @property
    def is_reverse_policy(self):
        """`{ bool }`
            \nThis flag indicates if this policy has been used for reverse replication.
        """ # noqa: E501
        return self.__is_reverse_policy

    @is_reverse_policy.setter
    def is_reverse_policy(self, is_reverse_policy):

        self.__is_reverse_policy = is_reverse_policy

    @property
    def policy_status(self):
        """`{ files.v4.config.PolicyStatus }`
            
        """ # noqa: E501
        return self.__policy_status

    @policy_status.setter
    def policy_status(self, policy_status):

        self.__policy_status = policy_status

    @property
    def replication_summary(self):
        """`{ files.v4.config.ReplicationSummary }`
            
        """ # noqa: E501
        return self.__replication_summary

    @replication_summary.setter
    def replication_summary(self, replication_summary):

        self.__replication_summary = replication_summary

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SubPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

