# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.SnapshotCreator import SnapshotCreator  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Snapshot(ExternalizableAbstractModel):
    """Snapshot - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'mount_target_ext_id': 'str',
        'file_server_ext_id': 'str',
        'name': 'str',
        'create_time': 'int',
        'total_space_bytes': 'int',
        'reclaimable_space_bytes': 'int',
        'creator': 'files.v4.config.SnapshotCreator',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'mount_target_ext_id': 'mountTargetExtId',
        'file_server_ext_id': 'fileServerExtId',
        'name': 'name',
        'create_time': 'createTime',
        'total_space_bytes': 'totalSpaceBytes',
        'reclaimable_space_bytes': 'reclaimableSpaceBytes',
        'creator': 'creator',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, mount_target_ext_id=None, file_server_ext_id=None, name=None, create_time=None, total_space_bytes=0, reclaimable_space_bytes=0, creator=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """Snapshot - a model defined in Swagger
            \nMount target snapshot model.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__mount_target_ext_id = None
        self.__file_server_ext_id = None
        self.__name = None
        self.__create_time = None
        self.__total_space_bytes = None
        self.__reclaimable_space_bytes = None
        self.__creator = None
        self.discriminator = None
        if mount_target_ext_id is not None:
            self.__mount_target_ext_id = mount_target_ext_id
        if file_server_ext_id is not None:
            self.__file_server_ext_id = file_server_ext_id
        if name is not None:
            self.__name = name
        if create_time is not None:
            self.__create_time = create_time
        if total_space_bytes is not None:
            self.__total_space_bytes = total_space_bytes
        if reclaimable_space_bytes is not None:
            self.__reclaimable_space_bytes = reclaimable_space_bytes
        if creator is not None:
            self.__creator = creator

    def _initialize_object_type(self):
        return 'files.v4.config.Snapshot'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.Snapshot'


    @property
    def mount_target_ext_id(self):
        """`{ str }`
            \nThe {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        """ # noqa: E501
        return self.__mount_target_ext_id

    @mount_target_ext_id.setter
    def mount_target_ext_id(self, mount_target_ext_id):
        if mount_target_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', mount_target_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `mount_target_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__mount_target_ext_id = mount_target_ext_id

    @property
    def file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the file server. This is a read-only field.
        """ # noqa: E501
        return self.__file_server_ext_id

    @file_server_ext_id.setter
    def file_server_ext_id(self, file_server_ext_id):
        if file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__file_server_ext_id = file_server_ext_id

    @property
    def name(self):
        """`{ str }`
            \nMount target snapshot name.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is not None and len(name) > 30:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `30`")  # noqa: E501

        self.__name = name

    @property
    def create_time(self):
        """`{ int }`
            \nMount target snapshot created time.
        """ # noqa: E501
        return self.__create_time

    @create_time.setter
    def create_time(self, create_time):

        self.__create_time = create_time

    @property
    def total_space_bytes(self):
        """`{ int }`
            \nMount target snapshot total space in bytes.
        """ # noqa: E501
        return self.__total_space_bytes

    @total_space_bytes.setter
    def total_space_bytes(self, total_space_bytes):
        if total_space_bytes is not None and total_space_bytes < 0:  # noqa: E501
            raise ValueError("Invalid value for `total_space_bytes`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__total_space_bytes = total_space_bytes

    @property
    def reclaimable_space_bytes(self):
        """`{ int }`
            \nMount target snapshot reclaimable space in bytes.
        """ # noqa: E501
        return self.__reclaimable_space_bytes

    @reclaimable_space_bytes.setter
    def reclaimable_space_bytes(self, reclaimable_space_bytes):
        if reclaimable_space_bytes is not None and reclaimable_space_bytes < 0:  # noqa: E501
            raise ValueError("Invalid value for `reclaimable_space_bytes`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__reclaimable_space_bytes = reclaimable_space_bytes

    @property
    def creator(self):
        """`{ files.v4.config.SnapshotCreator }`
            
        """ # noqa: E501
        return self.__creator

    @creator.setter
    def creator(self, creator):

        self.__creator = creator

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Snapshot, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Snapshot):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

