# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.EnforcementType import EnforcementType  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.PrincipalType import PrincipalType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class QuotaPolicy(ExternalizableAbstractModel):
    """QuotaPolicy - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'mount_target_ext_id': 'str',
        'principal_type': 'files.v4.config.PrincipalType',
        'principal_value': 'str',
        'size_in_bytes': 'int',
        'enforcement_type': 'files.v4.config.EnforcementType',
        'notification_recipients': 'list[str]',
        'enable_notifications': 'bool',
        'is_enable_notifications': 'bool',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'mount_target_ext_id': 'mountTargetExtId',
        'principal_type': 'principalType',
        'principal_value': 'principalValue',
        'size_in_bytes': 'sizeInBytes',
        'enforcement_type': 'enforcementType',
        'notification_recipients': 'notificationRecipients',
        'enable_notifications': 'enableNotifications',
        'is_enable_notifications': 'isEnableNotifications',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, mount_target_ext_id=None, principal_type=None, principal_value=None, size_in_bytes=1, enforcement_type=None, notification_recipients=None, enable_notifications=True, is_enable_notifications=True, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """QuotaPolicy - a model defined in Swagger
            \nQuota policy model.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__mount_target_ext_id = None
        self.__principal_type = None
        self.__principal_value = None
        self.__size_in_bytes = None
        self.__enforcement_type = None
        self.__notification_recipients = None
        self.__enable_notifications = None
        self.__is_enable_notifications = None
        self.discriminator = None
        if mount_target_ext_id is not None:
            self.__mount_target_ext_id = mount_target_ext_id
        self.__principal_type = principal_type
        self.__principal_value = principal_value
        self.__size_in_bytes = size_in_bytes
        self.__enforcement_type = enforcement_type
        if notification_recipients is not None:
            self.__notification_recipients = notification_recipients
        if enable_notifications is not None:
            self.__enable_notifications = enable_notifications
        if is_enable_notifications is not None:
            self.__is_enable_notifications = is_enable_notifications

    def _initialize_object_type(self):
        return 'files.v4.config.QuotaPolicy'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.QuotaPolicy'


    @property
    def mount_target_ext_id(self):
        """`{ str }`
            \nThe {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        """ # noqa: E501
        return self.__mount_target_ext_id

    @mount_target_ext_id.setter
    def mount_target_ext_id(self, mount_target_ext_id):
        if mount_target_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', mount_target_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `mount_target_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__mount_target_ext_id = mount_target_ext_id

    @property
    def principal_type(self):
        """`{ files.v4.config.PrincipalType }`
            
        """ # noqa: E501
        return self.__principal_type

    @principal_type.setter
    def principal_type(self, principal_type):
        if principal_type is None:
            raise ValueError("Invalid value for `principal_type`, must not be `None`")  # noqa: E501

        self.__principal_type = principal_type

    @property
    def principal_value(self):
        """`{ str }`
            \nPrincipal value is the name of the user or group, assigned to the principal type.
        """ # noqa: E501
        return self.__principal_value

    @principal_value.setter
    def principal_value(self, principal_value):
        if principal_value is None:
            raise ValueError("Invalid value for `principal_value`, must not be `None`")  # noqa: E501

        self.__principal_value = principal_value

    @property
    def size_in_bytes(self):
        """`{ int }`
            \nQuota size in bytes.
        """ # noqa: E501
        return self.__size_in_bytes

    @size_in_bytes.setter
    def size_in_bytes(self, size_in_bytes):
        if size_in_bytes is None:
            raise ValueError("Invalid value for `size_in_bytes`, must not be `None`")  # noqa: E501
        if size_in_bytes is not None and size_in_bytes < 0:  # noqa: E501
            raise ValueError("Invalid value for `size_in_bytes`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__size_in_bytes = size_in_bytes

    @property
    def enforcement_type(self):
        """`{ files.v4.config.EnforcementType }`
            
        """ # noqa: E501
        return self.__enforcement_type

    @enforcement_type.setter
    def enforcement_type(self, enforcement_type):
        if enforcement_type is None:
            raise ValueError("Invalid value for `enforcement_type`, must not be `None`")  # noqa: E501

        self.__enforcement_type = enforcement_type

    @property
    def notification_recipients(self):
        """`{ list[str] }`
            \nList of recipients emails.
        """ # noqa: E501
        return self.__notification_recipients

    @notification_recipients.setter
    def notification_recipients(self, notification_recipients):

        self.__notification_recipients = notification_recipients

    @property
    def enable_notifications(self):
        """`{ bool }`
            \nEnable email notifications for the user or group defined in the principal type. Notification will be sent, only if the user or groups are close to the quota provided. This field will be deprecated.
        """ # noqa: E501
        return self.__enable_notifications

    @enable_notifications.setter
    def enable_notifications(self, enable_notifications):

        self.__enable_notifications = enable_notifications

    @property
    def is_enable_notifications(self):
        """`{ bool }`
            \nEnable email notifications for the user or group defined in the principal type. Notification will be sent, only if the user or groups are close to the quota provided.
        """ # noqa: E501
        return self.__is_enable_notifications

    @is_enable_notifications.setter
    def is_enable_notifications(self, is_enable_notifications):

        self.__is_enable_notifications = is_enable_notifications

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QuotaPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuotaPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

