# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Network(ExternalizableAbstractModel):
    """Network - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'network_ext_id': 'str',
        'vlan_id': 'int',
        'virtual_ip_address': 'common.v1.config.IPAddress',
        'virtual_network_name': 'str',
        'subnet_mask': 'common.v1.config.IPAddress',
        'default_gateway': 'common.v1.config.IPAddress',
        'ipv6_prefix_length': 'int',
        'ip_addresses': 'list[common.v1.config.IPAddress]',
        'is_managed': 'bool',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'network_ext_id': 'networkExtId',
        'vlan_id': 'vlanId',
        'virtual_ip_address': 'virtualIpAddress',
        'virtual_network_name': 'virtualNetworkName',
        'subnet_mask': 'subnetMask',
        'default_gateway': 'defaultGateway',
        'ipv6_prefix_length': 'ipv6PrefixLength',
        'ip_addresses': 'ipAddresses',
        'is_managed': 'isManaged',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, network_ext_id=None, vlan_id=None, virtual_ip_address=None, virtual_network_name=None, subnet_mask=None, default_gateway=None, ipv6_prefix_length=None, ip_addresses=None, is_managed=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """Network - a model defined in Swagger
            \nFile server network object.
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__network_ext_id = None
        self.__vlan_id = None
        self.__virtual_ip_address = None
        self.__virtual_network_name = None
        self.__subnet_mask = None
        self.__default_gateway = None
        self.__ipv6_prefix_length = None
        self.__ip_addresses = None
        self.__is_managed = None
        self.discriminator = None
        if network_ext_id is not None:
            self.__network_ext_id = network_ext_id
        if vlan_id is not None:
            self.__vlan_id = vlan_id
        if virtual_ip_address is not None:
            self.__virtual_ip_address = virtual_ip_address
        if virtual_network_name is not None:
            self.__virtual_network_name = virtual_network_name
        if subnet_mask is not None:
            self.__subnet_mask = subnet_mask
        if default_gateway is not None:
            self.__default_gateway = default_gateway
        if ipv6_prefix_length is not None:
            self.__ipv6_prefix_length = ipv6_prefix_length
        if ip_addresses is not None:
            self.__ip_addresses = ip_addresses
        if is_managed is not None:
            self.__is_managed = is_managed

    def _initialize_object_type(self):
        return 'files.v4.config.Network'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.Network'


    @property
    def network_ext_id(self):
        """`{ str }`
            \nUUID of the the file server network.
        """ # noqa: E501
        return self.__network_ext_id

    @network_ext_id.setter
    def network_ext_id(self, network_ext_id):
        if network_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', network_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `network_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__network_ext_id = network_ext_id

    @property
    def vlan_id(self):
        """`{ int }`
            \nFile server network VLAN Id.
        """ # noqa: E501
        return self.__vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        if vlan_id is not None and vlan_id > 4095:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must be a value less than or equal to `4095`")  # noqa: E501
        if vlan_id is not None and vlan_id < 0:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__vlan_id = vlan_id

    @property
    def virtual_ip_address(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__virtual_ip_address

    @virtual_ip_address.setter
    def virtual_ip_address(self, virtual_ip_address):

        self.__virtual_ip_address = virtual_ip_address

    @property
    def virtual_network_name(self):
        """`{ str }`
            \nFile server network name. This is a read-only field.
        """ # noqa: E501
        return self.__virtual_network_name

    @virtual_network_name.setter
    def virtual_network_name(self, virtual_network_name):

        self.__virtual_network_name = virtual_network_name

    @property
    def subnet_mask(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__subnet_mask

    @subnet_mask.setter
    def subnet_mask(self, subnet_mask):

        self.__subnet_mask = subnet_mask

    @property
    def default_gateway(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__default_gateway

    @default_gateway.setter
    def default_gateway(self, default_gateway):

        self.__default_gateway = default_gateway

    @property
    def ipv6_prefix_length(self):
        """`{ int }`
            \nPrefix length for IPV6 address
        """ # noqa: E501
        return self.__ipv6_prefix_length

    @ipv6_prefix_length.setter
    def ipv6_prefix_length(self, ipv6_prefix_length):
        if ipv6_prefix_length is not None and ipv6_prefix_length < 0:  # noqa: E501
            raise ValueError("Invalid value for `ipv6_prefix_length`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__ipv6_prefix_length = ipv6_prefix_length

    @property
    def ip_addresses(self):
        """`{ list[common.v1.config.IPAddress] }`
            \nIPV4 address range to be used in this network.
        """ # noqa: E501
        return self.__ip_addresses

    @ip_addresses.setter
    def ip_addresses(self, ip_addresses):

        self.__ip_addresses = ip_addresses

    @property
    def is_managed(self):
        """`{ bool }`
            \nIndicates whether the current file server network is managed or unmanaged. This is a read-only field.
        """ # noqa: E501
        return self.__is_managed

    @is_managed.setter
    def is_managed(self, is_managed):

        self.__is_managed = is_managed

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Network, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Network):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

