# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.StatusInfo import StatusInfo  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class MigrationStats(ExternalizableAbstractModel):
    """MigrationStats - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'start_time': 'str',
        'end_time': 'str',
        'bytes_transferred': 'int',
        'files_transferred': 'int',
        'directories_transferred': 'int',
        'failed_files_count': 'int',
        'failed_directories_count': 'int',
        'average_data_throughput': 'float',
        'average_entities_throughput': 'int',
        'average_files_scanned_rate': 'int',
        'files_scanned': 'int',
        'files_skipped': 'int',
        'streams_transferred': 'int',
        'failed_streams_count': 'int',
        'bytes_metadata_transferred': 'int',
        'status_info': 'files.v4.config.StatusInfo',
        'iteration_number': 'int',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'start_time': 'startTime',
        'end_time': 'endTime',
        'bytes_transferred': 'bytesTransferred',
        'files_transferred': 'filesTransferred',
        'directories_transferred': 'directoriesTransferred',
        'failed_files_count': 'failedFilesCount',
        'failed_directories_count': 'failedDirectoriesCount',
        'average_data_throughput': 'averageDataThroughput',
        'average_entities_throughput': 'averageEntitiesThroughput',
        'average_files_scanned_rate': 'averageFilesScannedRate',
        'files_scanned': 'filesScanned',
        'files_skipped': 'filesSkipped',
        'streams_transferred': 'streamsTransferred',
        'failed_streams_count': 'failedStreamsCount',
        'bytes_metadata_transferred': 'bytesMetadataTransferred',
        'status_info': 'statusInfo',
        'iteration_number': 'iterationNumber',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, start_time=None, end_time=None, bytes_transferred=0, files_transferred=0, directories_transferred=0, failed_files_count=0, failed_directories_count=0, average_data_throughput=0, average_entities_throughput=None, average_files_scanned_rate=0, files_scanned=0, files_skipped=0, streams_transferred=0, failed_streams_count=0, bytes_metadata_transferred=0, status_info=None, iteration_number=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """MigrationStats - a model defined in Swagger
            \nMigration plan stats details
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__start_time = None
        self.__end_time = None
        self.__bytes_transferred = None
        self.__files_transferred = None
        self.__directories_transferred = None
        self.__failed_files_count = None
        self.__failed_directories_count = None
        self.__average_data_throughput = None
        self.__average_entities_throughput = None
        self.__average_files_scanned_rate = None
        self.__files_scanned = None
        self.__files_skipped = None
        self.__streams_transferred = None
        self.__failed_streams_count = None
        self.__bytes_metadata_transferred = None
        self.__status_info = None
        self.__iteration_number = None
        self.discriminator = None
        if start_time is not None:
            self.__start_time = start_time
        if end_time is not None:
            self.__end_time = end_time
        if bytes_transferred is not None:
            self.__bytes_transferred = bytes_transferred
        if files_transferred is not None:
            self.__files_transferred = files_transferred
        if directories_transferred is not None:
            self.__directories_transferred = directories_transferred
        if failed_files_count is not None:
            self.__failed_files_count = failed_files_count
        if failed_directories_count is not None:
            self.__failed_directories_count = failed_directories_count
        if average_data_throughput is not None:
            self.__average_data_throughput = average_data_throughput
        if average_entities_throughput is not None:
            self.__average_entities_throughput = average_entities_throughput
        if average_files_scanned_rate is not None:
            self.__average_files_scanned_rate = average_files_scanned_rate
        if files_scanned is not None:
            self.__files_scanned = files_scanned
        if files_skipped is not None:
            self.__files_skipped = files_skipped
        if streams_transferred is not None:
            self.__streams_transferred = streams_transferred
        if failed_streams_count is not None:
            self.__failed_streams_count = failed_streams_count
        if bytes_metadata_transferred is not None:
            self.__bytes_metadata_transferred = bytes_metadata_transferred
        if status_info is not None:
            self.__status_info = status_info
        if iteration_number is not None:
            self.__iteration_number = iteration_number

    def _initialize_object_type(self):
        return 'files.v4.config.MigrationStats'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.MigrationStats'


    @property
    def start_time(self):
        """`{ str }`
            \nStart time for the migration sub-plan.
        """ # noqa: E501
        return self.__start_time

    @start_time.setter
    def start_time(self, start_time):
        if start_time is not None and not re.search('^\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(([+-]\\d\\d:\\d\\d)|Z)?$', start_time):  # noqa: E501
            raise ValueError(r"Invalid value for `start_time`, must be a follow pattern or equal to `/^\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(([+-]\\d\\d:\\d\\d)|Z)?$/`")  # noqa: E501

        self.__start_time = start_time

    @property
    def end_time(self):
        """`{ str }`
            \nEnd time for the migration sub-plan.
        """ # noqa: E501
        return self.__end_time

    @end_time.setter
    def end_time(self, end_time):
        if end_time is not None and not re.search('^\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(([+-]\\d\\d:\\d\\d)|Z)?$', end_time):  # noqa: E501
            raise ValueError(r"Invalid value for `end_time`, must be a follow pattern or equal to `/^\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(([+-]\\d\\d:\\d\\d)|Z)?$/`")  # noqa: E501

        self.__end_time = end_time

    @property
    def bytes_transferred(self):
        """`{ int }`
            \nThe transferred bytes for the migration sub-plan.
        """ # noqa: E501
        return self.__bytes_transferred

    @bytes_transferred.setter
    def bytes_transferred(self, bytes_transferred):

        self.__bytes_transferred = bytes_transferred

    @property
    def files_transferred(self):
        """`{ int }`
            \nThe number of the transferred files for the migration sub-plan.
        """ # noqa: E501
        return self.__files_transferred

    @files_transferred.setter
    def files_transferred(self, files_transferred):

        self.__files_transferred = files_transferred

    @property
    def directories_transferred(self):
        """`{ int }`
            \nThe number of the transferred directories for the migration sub-plan.
        """ # noqa: E501
        return self.__directories_transferred

    @directories_transferred.setter
    def directories_transferred(self, directories_transferred):

        self.__directories_transferred = directories_transferred

    @property
    def failed_files_count(self):
        """`{ int }`
            \nThe number of the transferred failed files for the migration sub-plan.
        """ # noqa: E501
        return self.__failed_files_count

    @failed_files_count.setter
    def failed_files_count(self, failed_files_count):

        self.__failed_files_count = failed_files_count

    @property
    def failed_directories_count(self):
        """`{ int }`
            \nThe number of the transferred failed directories for the migration sub-plan.
        """ # noqa: E501
        return self.__failed_directories_count

    @failed_directories_count.setter
    def failed_directories_count(self, failed_directories_count):

        self.__failed_directories_count = failed_directories_count

    @property
    def average_data_throughput(self):
        """`{ float }`
            \nThe average data throughput for migration sub-plan in bytes/sec.
        """ # noqa: E501
        return self.__average_data_throughput

    @average_data_throughput.setter
    def average_data_throughput(self, average_data_throughput):

        self.__average_data_throughput = average_data_throughput

    @property
    def average_entities_throughput(self):
        """`{ int }`
            \nThe average entities throughput for migration sub-plan in entities/sec.
        """ # noqa: E501
        return self.__average_entities_throughput

    @average_entities_throughput.setter
    def average_entities_throughput(self, average_entities_throughput):

        self.__average_entities_throughput = average_entities_throughput

    @property
    def average_files_scanned_rate(self):
        """`{ int }`
            \nThe average average file scan rate for migration sub-plan in files/sec.
        """ # noqa: E501
        return self.__average_files_scanned_rate

    @average_files_scanned_rate.setter
    def average_files_scanned_rate(self, average_files_scanned_rate):

        self.__average_files_scanned_rate = average_files_scanned_rate

    @property
    def files_scanned(self):
        """`{ int }`
            \nThe number of migration sub-plan files scanned.
        """ # noqa: E501
        return self.__files_scanned

    @files_scanned.setter
    def files_scanned(self, files_scanned):

        self.__files_scanned = files_scanned

    @property
    def files_skipped(self):
        """`{ int }`
            \nThe number of migration sub-plan files skipped.
        """ # noqa: E501
        return self.__files_skipped

    @files_skipped.setter
    def files_skipped(self, files_skipped):

        self.__files_skipped = files_skipped

    @property
    def streams_transferred(self):
        """`{ int }`
            \nThe number of migration sub-plan streams transferred.
        """ # noqa: E501
        return self.__streams_transferred

    @streams_transferred.setter
    def streams_transferred(self, streams_transferred):

        self.__streams_transferred = streams_transferred

    @property
    def failed_streams_count(self):
        """`{ int }`
            \nThe number of migration sub-plan failed streams.
        """ # noqa: E501
        return self.__failed_streams_count

    @failed_streams_count.setter
    def failed_streams_count(self, failed_streams_count):

        self.__failed_streams_count = failed_streams_count

    @property
    def bytes_metadata_transferred(self):
        """`{ int }`
            \nThe number of migration sub-plan bytes metadata transferred.
        """ # noqa: E501
        return self.__bytes_metadata_transferred

    @bytes_metadata_transferred.setter
    def bytes_metadata_transferred(self, bytes_metadata_transferred):

        self.__bytes_metadata_transferred = bytes_metadata_transferred

    @property
    def status_info(self):
        """`{ files.v4.config.StatusInfo }`
            
        """ # noqa: E501
        return self.__status_info

    @status_info.setter
    def status_info(self, status_info):

        self.__status_info = status_info

    @property
    def iteration_number(self):
        """`{ int }`
            \nThe iteration number for Migration sub-plan.
        """ # noqa: E501
        return self.__iteration_number

    @iteration_number.setter
    def iteration_number(self, iteration_number):

        self.__iteration_number = iteration_number

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MigrationStats, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MigrationStats):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

