# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class InfectedFile(ExternalizableAbstractModel):
    """InfectedFile - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'file_server_ext_id': 'str',
        'mount_target_ext_id': 'str',
        'share_name': 'str',
        'file_path': 'str',
        'threat_description': 'str',
        'scan_timestamp_usecs': 'str',
        'quarantined': 'bool',
        'icap_server': 'str',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'file_server_ext_id': 'fileServerExtId',
        'mount_target_ext_id': 'mountTargetExtId',
        'share_name': 'shareName',
        'file_path': 'filePath',
        'threat_description': 'threatDescription',
        'scan_timestamp_usecs': 'scanTimestampUsecs',
        'quarantined': 'quarantined',
        'icap_server': 'icapServer',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, file_server_ext_id=None, mount_target_ext_id=None, share_name=None, file_path=None, threat_description=None, scan_timestamp_usecs=None, quarantined=None, icap_server=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """InfectedFile - a model defined in Swagger
            \nInfected files model
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__file_server_ext_id = None
        self.__mount_target_ext_id = None
        self.__share_name = None
        self.__file_path = None
        self.__threat_description = None
        self.__scan_timestamp_usecs = None
        self.__quarantined = None
        self.__icap_server = None
        self.discriminator = None
        if file_server_ext_id is not None:
            self.__file_server_ext_id = file_server_ext_id
        if mount_target_ext_id is not None:
            self.__mount_target_ext_id = mount_target_ext_id
        if share_name is not None:
            self.__share_name = share_name
        if file_path is not None:
            self.__file_path = file_path
        if threat_description is not None:
            self.__threat_description = threat_description
        if scan_timestamp_usecs is not None:
            self.__scan_timestamp_usecs = scan_timestamp_usecs
        if quarantined is not None:
            self.__quarantined = quarantined
        if icap_server is not None:
            self.__icap_server = icap_server

    def _initialize_object_type(self):
        return 'files.v4.config.InfectedFile'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.InfectedFile'


    @property
    def file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the file server. This is a read-only field.
        """ # noqa: E501
        return self.__file_server_ext_id

    @file_server_ext_id.setter
    def file_server_ext_id(self, file_server_ext_id):
        if file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__file_server_ext_id = file_server_ext_id

    @property
    def mount_target_ext_id(self):
        """`{ str }`
            \nThe {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        """ # noqa: E501
        return self.__mount_target_ext_id

    @mount_target_ext_id.setter
    def mount_target_ext_id(self, mount_target_ext_id):
        if mount_target_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', mount_target_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `mount_target_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__mount_target_ext_id = mount_target_ext_id

    @property
    def share_name(self):
        """`{ str }`
            \nShare name
        """ # noqa: E501
        return self.__share_name

    @share_name.setter
    def share_name(self, share_name):

        self.__share_name = share_name

    @property
    def file_path(self):
        """`{ str }`
            \nFile path
        """ # noqa: E501
        return self.__file_path

    @file_path.setter
    def file_path(self, file_path):

        self.__file_path = file_path

    @property
    def threat_description(self):
        """`{ str }`
            \nThreat description
        """ # noqa: E501
        return self.__threat_description

    @threat_description.setter
    def threat_description(self, threat_description):

        self.__threat_description = threat_description

    @property
    def scan_timestamp_usecs(self):
        """`{ str }`
            \nScan timestamp in sec.s
        """ # noqa: E501
        return self.__scan_timestamp_usecs

    @scan_timestamp_usecs.setter
    def scan_timestamp_usecs(self, scan_timestamp_usecs):
        if scan_timestamp_usecs is not None and not re.search('^\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(([+-]\\d\\d:\\d\\d)|Z)?$', scan_timestamp_usecs):  # noqa: E501
            raise ValueError(r"Invalid value for `scan_timestamp_usecs`, must be a follow pattern or equal to `/^\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(([+-]\\d\\d:\\d\\d)|Z)?$/`")  # noqa: E501

        self.__scan_timestamp_usecs = scan_timestamp_usecs

    @property
    def quarantined(self):
        """`{ bool }`
            \nQuarantine infected files.
        """ # noqa: E501
        return self.__quarantined

    @quarantined.setter
    def quarantined(self, quarantined):

        self.__quarantined = quarantined

    @property
    def icap_server(self):
        """`{ str }`
            \nICAP server details
        """ # noqa: E501
        return self.__icap_server

    @icap_server.setter
    def icap_server(self, icap_server):

        self.__icap_server = icap_server

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InfectedFile, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InfectedFile):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

