# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.config.IPAddressOrFQDN import IPAddressOrFQDN  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.config.IPv4Address import IPv4Address  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.Network import Network  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.VM import VM  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class FileServer(ExternalizableAbstractModel):
    """FileServer - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'memory_gib': 'int',
        'vcpus': 'int',
        'cvm_ip_addresses': 'list[common.v1.config.IPv4Address]',
        'container_ext_id': 'str',
        'cluster_ext_id': 'str',
        'size_in_gib': 'float',
        'version': 'str',
        'rebalance_needed': 'bool',
        'dns_domain_name': 'str',
        'compression_enabled': 'bool',
        'file_blocking_extensions': 'list[str]',
        'vms': 'list[files.v4.config.VM]',
        'dns_servers': 'list[common.v1.config.IPv4Address]',
        'ntp_servers': 'list[common.v1.config.IPAddressOrFQDN]',
        'internal_networks': 'list[files.v4.config.Network]',
        'external_networks': 'list[files.v4.config.Network]',
        'nvms_count': 'int',
        'external_primary_network_ext_id': 'str',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'memory_gib': 'memoryGib',
        'vcpus': 'vcpus',
        'cvm_ip_addresses': 'cvmIpAddresses',
        'container_ext_id': 'containerExtId',
        'cluster_ext_id': 'clusterExtId',
        'size_in_gib': 'sizeInGib',
        'version': 'version',
        'rebalance_needed': 'rebalanceNeeded',
        'dns_domain_name': 'dnsDomainName',
        'compression_enabled': 'compressionEnabled',
        'file_blocking_extensions': 'fileBlockingExtensions',
        'vms': 'vms',
        'dns_servers': 'dnsServers',
        'ntp_servers': 'ntpServers',
        'internal_networks': 'internalNetworks',
        'external_networks': 'externalNetworks',
        'nvms_count': 'nvmsCount',
        'external_primary_network_ext_id': 'externalPrimaryNetworkExtId',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, memory_gib=12, vcpus=4, cvm_ip_addresses=None, container_ext_id=None, cluster_ext_id=None, size_in_gib=None, version=None, rebalance_needed=None, dns_domain_name=None, compression_enabled=None, file_blocking_extensions=None, vms=None, dns_servers=None, ntp_servers=None, internal_networks=None, external_networks=None, nvms_count=None, external_primary_network_ext_id=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """FileServer - a model defined in Swagger
            \nFile server object
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__memory_gib = None
        self.__vcpus = None
        self.__cvm_ip_addresses = None
        self.__container_ext_id = None
        self.__cluster_ext_id = None
        self.__size_in_gib = None
        self.__version = None
        self.__rebalance_needed = None
        self.__dns_domain_name = None
        self.__compression_enabled = None
        self.__file_blocking_extensions = None
        self.__vms = None
        self.__dns_servers = None
        self.__ntp_servers = None
        self.__internal_networks = None
        self.__external_networks = None
        self.__nvms_count = None
        self.__external_primary_network_ext_id = None
        self.discriminator = None
        self.__name = name
        if memory_gib is not None:
            self.__memory_gib = memory_gib
        if vcpus is not None:
            self.__vcpus = vcpus
        if cvm_ip_addresses is not None:
            self.__cvm_ip_addresses = cvm_ip_addresses
        if container_ext_id is not None:
            self.__container_ext_id = container_ext_id
        if cluster_ext_id is not None:
            self.__cluster_ext_id = cluster_ext_id
        if size_in_gib is not None:
            self.__size_in_gib = size_in_gib
        if version is not None:
            self.__version = version
        if rebalance_needed is not None:
            self.__rebalance_needed = rebalance_needed
        if dns_domain_name is not None:
            self.__dns_domain_name = dns_domain_name
        if compression_enabled is not None:
            self.__compression_enabled = compression_enabled
        if file_blocking_extensions is not None:
            self.__file_blocking_extensions = file_blocking_extensions
        if vms is not None:
            self.__vms = vms
        if dns_servers is not None:
            self.__dns_servers = dns_servers
        if ntp_servers is not None:
            self.__ntp_servers = ntp_servers
        if internal_networks is not None:
            self.__internal_networks = internal_networks
        if external_networks is not None:
            self.__external_networks = external_networks
        if nvms_count is not None:
            self.__nvms_count = nvms_count
        if external_primary_network_ext_id is not None:
            self.__external_primary_network_ext_id = external_primary_network_ext_id

    def _initialize_object_type(self):
        return 'files.v4.config.FileServer'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.FileServer'


    @property
    def name(self):
        """`{ str }`
            \nFile server name.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 15:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `15`")  # noqa: E501

        self.__name = name

    @property
    def memory_gib(self):
        """`{ int }`
            \nMemory associated with the file server VM.
        """ # noqa: E501
        return self.__memory_gib

    @memory_gib.setter
    def memory_gib(self, memory_gib):

        self.__memory_gib = memory_gib

    @property
    def vcpus(self):
        """`{ int }`
            \nCPU associated with the file server VM.
        """ # noqa: E501
        return self.__vcpus

    @vcpus.setter
    def vcpus(self, vcpus):

        self.__vcpus = vcpus

    @property
    def cvm_ip_addresses(self):
        """`{ list[common.v1.config.IPv4Address] }`
            \nList of CVM IP addresses associated with the file server. This is a read-only field.
        """ # noqa: E501
        return self.__cvm_ip_addresses

    @cvm_ip_addresses.setter
    def cvm_ip_addresses(self, cvm_ip_addresses):

        self.__cvm_ip_addresses = cvm_ip_addresses

    @property
    def container_ext_id(self):
        """`{ str }`
            \nThe container associated with the file server. This is a read-only field.
        """ # noqa: E501
        return self.__container_ext_id

    @container_ext_id.setter
    def container_ext_id(self, container_ext_id):
        if container_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', container_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `container_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__container_ext_id = container_ext_id

    @property
    def cluster_ext_id(self):
        """`{ str }`
            \nThe cluster associated with the file server. This contains AOS cluster UUID. This is a read-only field.
        """ # noqa: E501
        return self.__cluster_ext_id

    @cluster_ext_id.setter
    def cluster_ext_id(self, cluster_ext_id):
        if cluster_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', cluster_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `cluster_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__cluster_ext_id = cluster_ext_id

    @property
    def size_in_gib(self):
        """`{ float }`
            \nFile server size.
        """ # noqa: E501
        return self.__size_in_gib

    @size_in_gib.setter
    def size_in_gib(self, size_in_gib):

        self.__size_in_gib = size_in_gib

    @property
    def version(self):
        """`{ str }`
            \nFile server version. This is a read-only field.
        """ # noqa: E501
        return self.__version

    @version.setter
    def version(self, version):

        self.__version = version

    @property
    def rebalance_needed(self):
        """`{ bool }`
            \nThis flag indicates if file server recommendations are available and the user has to perform actions. This is a read-only field.
        """ # noqa: E501
        return self.__rebalance_needed

    @rebalance_needed.setter
    def rebalance_needed(self, rebalance_needed):

        self.__rebalance_needed = rebalance_needed

    @property
    def dns_domain_name(self):
        """`{ str }`
            \nFully qualified domain name (file server namespace). This, along with the file server name, constitutes the namespace of the file server. Example: fileserver_name.corp.companyname.com. This is also used to create file server DNS entries on the nameservers so that clients can access the file server using its name.
        """ # noqa: E501
        return self.__dns_domain_name

    @dns_domain_name.setter
    def dns_domain_name(self, dns_domain_name):

        self.__dns_domain_name = dns_domain_name

    @property
    def compression_enabled(self):
        """`{ bool }`
            \nFilesystem compression value. For file servers greater than 3.6 version, the filesystem compression is enabled by default. This is a read-only field.
        """ # noqa: E501
        return self.__compression_enabled

    @compression_enabled.setter
    def compression_enabled(self, compression_enabled):

        self.__compression_enabled = compression_enabled

    @property
    def file_blocking_extensions(self):
        """`{ list[str] }`
            \nList of file blocking extensions or patterns in a comma separated list of strings. For Ex: [\".db\",\".txt\",\".mp3\"].
        """ # noqa: E501
        return self.__file_blocking_extensions

    @file_blocking_extensions.setter
    def file_blocking_extensions(self, file_blocking_extensions):

        self.__file_blocking_extensions = file_blocking_extensions

    @property
    def vms(self):
        """`{ list[files.v4.config.VM] }`
            \nList of file server VMs associated with the file server. This is a read-only field.
        """ # noqa: E501
        return self.__vms

    @vms.setter
    def vms(self, vms):

        self.__vms = vms

    @property
    def dns_servers(self):
        """`{ list[common.v1.config.IPv4Address] }`
            \nList of DNS servers associated with the file server.
        """ # noqa: E501
        return self.__dns_servers

    @dns_servers.setter
    def dns_servers(self, dns_servers):

        self.__dns_servers = dns_servers

    @property
    def ntp_servers(self):
        """`{ list[common.v1.config.IPAddressOrFQDN] }`
            \nThe list of IP or Expand FQDN of the NTP servers associated with the file server.
        """ # noqa: E501
        return self.__ntp_servers

    @ntp_servers.setter
    def ntp_servers(self, ntp_servers):

        self.__ntp_servers = ntp_servers

    @property
    def internal_networks(self):
        """`{ list[files.v4.config.Network] }`
            \nList of internal networks associated with the file server.
        """ # noqa: E501
        return self.__internal_networks

    @internal_networks.setter
    def internal_networks(self, internal_networks):

        self.__internal_networks = internal_networks

    @property
    def external_networks(self):
        """`{ list[files.v4.config.Network] }`
            \nList of external networks associated with the file server.
        """ # noqa: E501
        return self.__external_networks

    @external_networks.setter
    def external_networks(self, external_networks):

        self.__external_networks = external_networks

    @property
    def nvms_count(self):
        """`{ int }`
            \nTotal number of file server VMs
        """ # noqa: E501
        return self.__nvms_count

    @nvms_count.setter
    def nvms_count(self, nvms_count):
        if nvms_count is not None and nvms_count > 32:  # noqa: E501
            raise ValueError("Invalid value for `nvms_count`, must be a value less than or equal to `32`")  # noqa: E501
        if nvms_count is not None and nvms_count < 1:  # noqa: E501
            raise ValueError("Invalid value for `nvms_count`, must be a value greater than or equal to `1`")  # noqa: E501

        self.__nvms_count = nvms_count

    @property
    def external_primary_network_ext_id(self):
        """`{ str }`
            \nNetwork Id of external primary network.
        """ # noqa: E501
        return self.__external_primary_network_ext_id

    @external_primary_network_ext_id.setter
    def external_primary_network_ext_id(self, external_primary_network_ext_id):
        if external_primary_network_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', external_primary_network_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `external_primary_network_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__external_primary_network_ext_id = external_primary_network_ext_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FileServer, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileServer):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

