# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.files.v4.config.Credential import Credential  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.DnsOperationType import DnsOperationType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Dns(Credential):
    """Dns - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'ext_id': 'str',
        'preferred_name_server': 'str',
        'ip_address': 'str',
        'host_name': 'str',
        'operation_type': 'files.v4.config.DnsOperationType',
        'is_verified': 'bool',
        'username': 'str',
        'password': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'ext_id': 'extId',
        'preferred_name_server': 'preferredNameServer',
        'ip_address': 'ipAddress',
        'host_name': 'hostName',
        'operation_type': 'operationType',
        'is_verified': 'isVerified',
        'username': 'username',
        'password': 'password',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, ext_id=None, preferred_name_server=None, ip_address=None, host_name=None, operation_type=None, is_verified=None, username=None, password=None, *args, **kwargs):  # noqa: E501
        """Dns - a model defined in Swagger
            \nDNS detail for the file server.
        """
        Credential.__init__(self, username, password, *args, **kwargs)
        self.__ext_id = None
        self.__preferred_name_server = None
        self.__ip_address = None
        self.__host_name = None
        self.__operation_type = None
        self.__is_verified = None
        self.discriminator = None
        if ext_id is not None:
            self.__ext_id = ext_id
        if preferred_name_server is not None:
            self.__preferred_name_server = preferred_name_server
        if ip_address is not None:
            self.__ip_address = ip_address
        if host_name is not None:
            self.__host_name = host_name
        if operation_type is not None:
            self.__operation_type = operation_type
        if is_verified is not None:
            self.__is_verified = is_verified

    def _initialize_object_type(self):
        return 'files.v4.config.Dns'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.Dns'


    @property
    def ext_id(self):
        """`{ str }`
            \nDNS server UUID. This is a read-only field. Example:28f78959-14a6-4c47-b5db-920460c4b668.
        """ # noqa: E501
        return self.__ext_id

    @ext_id.setter
    def ext_id(self, ext_id):
        if ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__ext_id = ext_id

    @property
    def preferred_name_server(self):
        """`{ str }`
            \nPreferred name server for a file server.
        """ # noqa: E501
        return self.__preferred_name_server

    @preferred_name_server.setter
    def preferred_name_server(self, preferred_name_server):

        self.__preferred_name_server = preferred_name_server

    @property
    def ip_address(self):
        """`{ str }`
            \nIPV4 address of the DNS server. This is a read-only field.
        """ # noqa: E501
        return self.__ip_address

    @ip_address.setter
    def ip_address(self, ip_address):

        self.__ip_address = ip_address

    @property
    def host_name(self):
        """`{ str }`
            \nHost name for the DNS server. This is a read-only field.
        """ # noqa: E501
        return self.__host_name

    @host_name.setter
    def host_name(self, host_name):

        self.__host_name = host_name

    @property
    def operation_type(self):
        """`{ files.v4.config.DnsOperationType }`
            
        """ # noqa: E501
        return self.__operation_type

    @operation_type.setter
    def operation_type(self, operation_type):

        self.__operation_type = operation_type

    @property
    def is_verified(self):
        """`{ bool }`
            \nThis field indicates if the DNS server is verified. This is a read-only field.
        """ # noqa: E501
        return self.__is_verified

    @is_verified.setter
    def is_verified(self, is_verified):

        self.__is_verified = is_verified

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Dns, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Dns):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

