# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.ConsolidationSubPolicy import ConsolidationSubPolicy  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.PolicyStatus import PolicyStatus  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class DataConsolidationPolicy(ExternalizableAbstractModel):
    """DataConsolidationPolicy - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'target_file_server_ext_id': 'str',
        'target_path': 'str',
        'sub_policies': 'list[files.v4.config.ConsolidationSubPolicy]',
        'policy_status': 'files.v4.config.PolicyStatus',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'target_file_server_ext_id': 'targetFileServerExtId',
        'target_path': 'targetPath',
        'sub_policies': 'subPolicies',
        'policy_status': 'policyStatus',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, target_file_server_ext_id=None, target_path=None, sub_policies=None, policy_status=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """DataConsolidationPolicy - a model defined in Swagger
            \nData consolidation policy
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__target_file_server_ext_id = None
        self.__target_path = None
        self.__sub_policies = None
        self.__policy_status = None
        self.discriminator = None
        self.__name = name
        if description is not None:
            self.__description = description
        self.__target_file_server_ext_id = target_file_server_ext_id
        self.__target_path = target_path
        self.__sub_policies = sub_policies
        if policy_status is not None:
            self.__policy_status = policy_status

    def _initialize_object_type(self):
        return 'files.v4.config.DataConsolidationPolicy'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.DataConsolidationPolicy'


    @property
    def name(self):
        """`{ str }`
            \nConsolidation policy name
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 30:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `30`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nPolicy description
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 180:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `180`")  # noqa: E501

        self.__description = description

    @property
    def target_file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the target file server. This is a read-only field.
        """ # noqa: E501
        return self.__target_file_server_ext_id

    @target_file_server_ext_id.setter
    def target_file_server_ext_id(self, target_file_server_ext_id):
        if target_file_server_ext_id is None:
            raise ValueError("Invalid value for `target_file_server_ext_id`, must not be `None`")  # noqa: E501
        if target_file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', target_file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `target_file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__target_file_server_ext_id = target_file_server_ext_id

    @property
    def target_path(self):
        """`{ str }`
            \nAbsolute path for the target. For example: '/share1/dir1'. Path should always start with a root folder.
        """ # noqa: E501
        return self.__target_path

    @target_path.setter
    def target_path(self, target_path):
        if target_path is None:
            raise ValueError("Invalid value for `target_path`, must not be `None`")  # noqa: E501

        self.__target_path = target_path

    @property
    def sub_policies(self):
        """`{ list[files.v4.config.ConsolidationSubPolicy] }`
            \nConsolidation sub policy represents source, source paths and schedules.
        """ # noqa: E501
        return self.__sub_policies

    @sub_policies.setter
    def sub_policies(self, sub_policies):
        if sub_policies is None:
            raise ValueError("Invalid value for `sub_policies`, must not be `None`")  # noqa: E501

        self.__sub_policies = sub_policies

    @property
    def policy_status(self):
        """`{ files.v4.config.PolicyStatus }`
            
        """ # noqa: E501
        return self.__policy_status

    @policy_status.setter
    def policy_status(self, policy_status):

        self.__policy_status = policy_status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DataConsolidationPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DataConsolidationPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

