# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_files_py_client.Ntnx.files.v4.config.ConsolidationEntity import ConsolidationEntity  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.PolicyStatus import PolicyStatus  # noqa: F401,E501
from ntnx_files_py_client.Ntnx.files.v4.config.Schedule import Schedule  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class ConsolidationSubPolicy(object):
    """ConsolidationSubPolicy - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'ext_id': 'str',
        'source_file_server_ext_id': 'str',
        'sync_entities': 'list[files.v4.config.ConsolidationEntity]',
        'schedules': 'list[files.v4.config.Schedule]',
        'policy_status': 'files.v4.config.PolicyStatus',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'ext_id': 'extId',
        'source_file_server_ext_id': 'sourceFileServerExtId',
        'sync_entities': 'syncEntities',
        'schedules': 'schedules',
        'policy_status': 'policyStatus',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, ext_id=None, source_file_server_ext_id=None, sync_entities=None, schedules=None, policy_status=None, *args, **kwargs):  # noqa: E501
        """ConsolidationSubPolicy - a model defined in Swagger
            \nConsolidation sub policy represents source, source paths and schedules.
        """
        self.__ext_id = None
        self.__source_file_server_ext_id = None
        self.__sync_entities = None
        self.__schedules = None
        self.__policy_status = None
        self.discriminator = None
        if ext_id is not None:
            self.__ext_id = ext_id
        self.__source_file_server_ext_id = source_file_server_ext_id
        if sync_entities is not None:
            self.__sync_entities = sync_entities
        self.__schedules = schedules
        if policy_status is not None:
            self.__policy_status = policy_status
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'files.v4.config.ConsolidationSubPolicy'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.ConsolidationSubPolicy'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def ext_id(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__ext_id

    @ext_id.setter
    def ext_id(self, ext_id):
        if ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__ext_id = ext_id

    @property
    def source_file_server_ext_id(self):
        """`{ str }`
            \nThe {extId} of the file server. This is a read-only field.
        """ # noqa: E501
        return self.__source_file_server_ext_id

    @source_file_server_ext_id.setter
    def source_file_server_ext_id(self, source_file_server_ext_id):
        if source_file_server_ext_id is None:
            raise ValueError("Invalid value for `source_file_server_ext_id`, must not be `None`")  # noqa: E501
        if source_file_server_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', source_file_server_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `source_file_server_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__source_file_server_ext_id = source_file_server_ext_id

    @property
    def sync_entities(self):
        """`{ list[files.v4.config.ConsolidationEntity] }`
            \nThis contains list of source paths which belong to the source file server.
        """ # noqa: E501
        return self.__sync_entities

    @sync_entities.setter
    def sync_entities(self, sync_entities):

        self.__sync_entities = sync_entities

    @property
    def schedules(self):
        """`{ list[files.v4.config.Schedule] }`
            \nThis contains details of snapshot schedules. It contains the start time of the replication and frequency of the replication.
        """ # noqa: E501
        return self.__schedules

    @schedules.setter
    def schedules(self, schedules):
        if schedules is None:
            raise ValueError("Invalid value for `schedules`, must not be `None`")  # noqa: E501

        self.__schedules = schedules

    @property
    def policy_status(self):
        """`{ files.v4.config.PolicyStatus }`
            
        """ # noqa: E501
        return self.__policy_status

    @policy_status.setter
    def policy_status(self, policy_status):

        self.__policy_status = policy_status

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ConsolidationSubPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConsolidationSubPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

