# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Alert(object):
    """Alert - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'id': 'str',
        'alert_type_uuid': 'str',
        'check_id': 'str',
        'resolved': 'bool',
        'auto_resolved': 'bool',
        'acknowledged': 'bool',
        'service_v_m_id': 'str',
        'node_uuid': 'str',
        'created_time_stamp_in_usecs': 'int',
        'last_occurrence_time_stamp_in_usecs': 'int',
        'cluster_uuid': 'str',
        'originating_cluster_uuid': 'str',
        'severity': 'str',
        'categories': 'list[str]',
        'impact': 'str',
        'impact_types': 'list[str]',
        'classifications': 'list[str]',
        'acknowledged_by_username': 'str',
        'message': 'str',
        'detailed_message': 'str',
        'alert_title': 'str',
        'operation_type': 'str',
        'acknowledged_time_stamp_in_usecs': 'int',
        'resolved_time_stamp_in_usecs': 'int',
        'resolved_by_username': 'str',
        'entity_types': 'list[str]',
        'user_defined': 'bool',
        'entity_ids': 'list[str]',
        'entity_uuids': 'list[str]',
        'affected_entities': 'list[object]',
        'context_types': 'list[str]',
        'context_values': 'list[str]',
        'possible_causes': 'list[object]',
        'alert_details': 'object',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'id': 'id',
        'alert_type_uuid': 'alertTypeUuid',
        'check_id': 'checkId',
        'resolved': 'resolved',
        'auto_resolved': 'autoResolved',
        'acknowledged': 'acknowledged',
        'service_v_m_id': 'serviceVMId',
        'node_uuid': 'nodeUuid',
        'created_time_stamp_in_usecs': 'createdTimeStampInUsecs',
        'last_occurrence_time_stamp_in_usecs': 'lastOccurrenceTimeStampInUsecs',
        'cluster_uuid': 'clusterUuid',
        'originating_cluster_uuid': 'originatingClusterUuid',
        'severity': 'severity',
        'categories': 'categories',
        'impact': 'impact',
        'impact_types': 'impactTypes',
        'classifications': 'classifications',
        'acknowledged_by_username': 'acknowledgedByUsername',
        'message': 'message',
        'detailed_message': 'detailedMessage',
        'alert_title': 'alertTitle',
        'operation_type': 'operationType',
        'acknowledged_time_stamp_in_usecs': 'acknowledgedTimeStampInUsecs',
        'resolved_time_stamp_in_usecs': 'resolvedTimeStampInUsecs',
        'resolved_by_username': 'resolvedByUsername',
        'entity_types': 'entityTypes',
        'user_defined': 'userDefined',
        'entity_ids': 'entityIds',
        'entity_uuids': 'entityUuids',
        'affected_entities': 'affectedEntities',
        'context_types': 'contextTypes',
        'context_values': 'contextValues',
        'possible_causes': 'possibleCauses',
        'alert_details': 'alertDetails',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, id=None, alert_type_uuid=None, check_id=None, resolved=False, auto_resolved=False, acknowledged=False, service_v_m_id=None, node_uuid=None, created_time_stamp_in_usecs=None, last_occurrence_time_stamp_in_usecs=None, cluster_uuid=None, originating_cluster_uuid=None, severity=None, categories=None, impact=None, impact_types=None, classifications=None, acknowledged_by_username=None, message=None, detailed_message=None, alert_title=None, operation_type=None, acknowledged_time_stamp_in_usecs=None, resolved_time_stamp_in_usecs=None, resolved_by_username=None, entity_types=None, user_defined=False, entity_ids=None, entity_uuids=None, affected_entities=None, context_types=None, context_values=None, possible_causes=None, alert_details=None, *args, **kwargs):  # noqa: E501
        """Alert - a model defined in Swagger
            \nAlert object details
        """
        self.__id = None
        self.__alert_type_uuid = None
        self.__check_id = None
        self.__resolved = None
        self.__auto_resolved = None
        self.__acknowledged = None
        self.__service_v_m_id = None
        self.__node_uuid = None
        self.__created_time_stamp_in_usecs = None
        self.__last_occurrence_time_stamp_in_usecs = None
        self.__cluster_uuid = None
        self.__originating_cluster_uuid = None
        self.__severity = None
        self.__categories = None
        self.__impact = None
        self.__impact_types = None
        self.__classifications = None
        self.__acknowledged_by_username = None
        self.__message = None
        self.__detailed_message = None
        self.__alert_title = None
        self.__operation_type = None
        self.__acknowledged_time_stamp_in_usecs = None
        self.__resolved_time_stamp_in_usecs = None
        self.__resolved_by_username = None
        self.__entity_types = None
        self.__user_defined = None
        self.__entity_ids = None
        self.__entity_uuids = None
        self.__affected_entities = None
        self.__context_types = None
        self.__context_values = None
        self.__possible_causes = None
        self.__alert_details = None
        self.discriminator = None
        if id is not None:
            self.__id = id
        if alert_type_uuid is not None:
            self.__alert_type_uuid = alert_type_uuid
        if check_id is not None:
            self.__check_id = check_id
        if resolved is not None:
            self.__resolved = resolved
        if auto_resolved is not None:
            self.__auto_resolved = auto_resolved
        if acknowledged is not None:
            self.__acknowledged = acknowledged
        if service_v_m_id is not None:
            self.__service_v_m_id = service_v_m_id
        if node_uuid is not None:
            self.__node_uuid = node_uuid
        if created_time_stamp_in_usecs is not None:
            self.__created_time_stamp_in_usecs = created_time_stamp_in_usecs
        if last_occurrence_time_stamp_in_usecs is not None:
            self.__last_occurrence_time_stamp_in_usecs = last_occurrence_time_stamp_in_usecs
        if cluster_uuid is not None:
            self.__cluster_uuid = cluster_uuid
        if originating_cluster_uuid is not None:
            self.__originating_cluster_uuid = originating_cluster_uuid
        if severity is not None:
            self.__severity = severity
        if categories is not None:
            self.__categories = categories
        if impact is not None:
            self.__impact = impact
        if impact_types is not None:
            self.__impact_types = impact_types
        if classifications is not None:
            self.__classifications = classifications
        if acknowledged_by_username is not None:
            self.__acknowledged_by_username = acknowledged_by_username
        if message is not None:
            self.__message = message
        if detailed_message is not None:
            self.__detailed_message = detailed_message
        if alert_title is not None:
            self.__alert_title = alert_title
        if operation_type is not None:
            self.__operation_type = operation_type
        if acknowledged_time_stamp_in_usecs is not None:
            self.__acknowledged_time_stamp_in_usecs = acknowledged_time_stamp_in_usecs
        if resolved_time_stamp_in_usecs is not None:
            self.__resolved_time_stamp_in_usecs = resolved_time_stamp_in_usecs
        if resolved_by_username is not None:
            self.__resolved_by_username = resolved_by_username
        if entity_types is not None:
            self.__entity_types = entity_types
        if user_defined is not None:
            self.__user_defined = user_defined
        if entity_ids is not None:
            self.__entity_ids = entity_ids
        if entity_uuids is not None:
            self.__entity_uuids = entity_uuids
        if affected_entities is not None:
            self.__affected_entities = affected_entities
        if context_types is not None:
            self.__context_types = context_types
        if context_values is not None:
            self.__context_values = context_values
        if possible_causes is not None:
            self.__possible_causes = possible_causes
        if alert_details is not None:
            self.__alert_details = alert_details
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'files.v4.config.Alert'

    def _initialize_fq_object_type(self):
        return 'files.v4.r0.a2.config.Alert'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def id(self):
        """`{ str }`
            \nAlert UUID
        """ # noqa: E501
        return self.__id

    @id.setter
    def id(self, id):

        self.__id = id

    @property
    def alert_type_uuid(self):
        """`{ str }`
            \nAlert type UUID
        """ # noqa: E501
        return self.__alert_type_uuid

    @alert_type_uuid.setter
    def alert_type_uuid(self, alert_type_uuid):

        self.__alert_type_uuid = alert_type_uuid

    @property
    def check_id(self):
        """`{ str }`
            \nAlert check UUID
        """ # noqa: E501
        return self.__check_id

    @check_id.setter
    def check_id(self, check_id):

        self.__check_id = check_id

    @property
    def resolved(self):
        """`{ bool }`
            \nUsed as a filter to fetch only the resolved alerts.
        """ # noqa: E501
        return self.__resolved

    @resolved.setter
    def resolved(self, resolved):

        self.__resolved = resolved

    @property
    def auto_resolved(self):
        """`{ bool }`
            \nAlerts which have auto-resolve status.
        """ # noqa: E501
        return self.__auto_resolved

    @auto_resolved.setter
    def auto_resolved(self, auto_resolved):

        self.__auto_resolved = auto_resolved

    @property
    def acknowledged(self):
        """`{ bool }`
            \nAlerts which have acknowledged status.
        """ # noqa: E501
        return self.__acknowledged

    @acknowledged.setter
    def acknowledged(self, acknowledged):

        self.__acknowledged = acknowledged

    @property
    def service_v_m_id(self):
        """`{ str }`
            \nService VM Id
        """ # noqa: E501
        return self.__service_v_m_id

    @service_v_m_id.setter
    def service_v_m_id(self, service_v_m_id):

        self.__service_v_m_id = service_v_m_id

    @property
    def node_uuid(self):
        """`{ str }`
            \nNode UUID
        """ # noqa: E501
        return self.__node_uuid

    @node_uuid.setter
    def node_uuid(self, node_uuid):

        self.__node_uuid = node_uuid

    @property
    def created_time_stamp_in_usecs(self):
        """`{ int }`
            \nCreated timestamp in microseconds.
        """ # noqa: E501
        return self.__created_time_stamp_in_usecs

    @created_time_stamp_in_usecs.setter
    def created_time_stamp_in_usecs(self, created_time_stamp_in_usecs):

        self.__created_time_stamp_in_usecs = created_time_stamp_in_usecs

    @property
    def last_occurrence_time_stamp_in_usecs(self):
        """`{ int }`
            \nLast occurred timestamp in microseconds.
        """ # noqa: E501
        return self.__last_occurrence_time_stamp_in_usecs

    @last_occurrence_time_stamp_in_usecs.setter
    def last_occurrence_time_stamp_in_usecs(self, last_occurrence_time_stamp_in_usecs):

        self.__last_occurrence_time_stamp_in_usecs = last_occurrence_time_stamp_in_usecs

    @property
    def cluster_uuid(self):
        """`{ str }`
            \nThe cluster associated with the file server. This contains AOS cluster UUID. This is a read-only field.
        """ # noqa: E501
        return self.__cluster_uuid

    @cluster_uuid.setter
    def cluster_uuid(self, cluster_uuid):
        if cluster_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', cluster_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `cluster_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__cluster_uuid = cluster_uuid

    @property
    def originating_cluster_uuid(self):
        """`{ str }`
            \nOriginating cluster UUID
        """ # noqa: E501
        return self.__originating_cluster_uuid

    @originating_cluster_uuid.setter
    def originating_cluster_uuid(self, originating_cluster_uuid):
        if originating_cluster_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', originating_cluster_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `originating_cluster_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__originating_cluster_uuid = originating_cluster_uuid

    @property
    def severity(self):
        """`{ str }`
            \nSeverity level of the alert. The values can be INFO, WARNING or CRITICAL.
        """ # noqa: E501
        return self.__severity

    @severity.setter
    def severity(self, severity):

        self.__severity = severity

    @property
    def categories(self):
        """`{ list[str] }`
            \nAlerts associated with the categories. Categories can be SystemIndicator, Cluster.
        """ # noqa: E501
        return self.__categories

    @categories.setter
    def categories(self, categories):

        self.__categories = categories

    @property
    def impact(self):
        """`{ str }`
            \nAlert impact
        """ # noqa: E501
        return self.__impact

    @impact.setter
    def impact(self, impact):

        self.__impact = impact

    @property
    def impact_types(self):
        """`{ list[str] }`
            \nAlerts associated with the impact types. Impact types can be Availability, Capacity, Configuration, Performance, System Indicator, Controller VM.
        """ # noqa: E501
        return self.__impact_types

    @impact_types.setter
    def impact_types(self, impact_types):

        self.__impact_types = impact_types

    @property
    def classifications(self):
        """`{ list[str] }`
            \nAlerts associated with the listed classification.
        """ # noqa: E501
        return self.__classifications

    @classifications.setter
    def classifications(self, classifications):

        self.__classifications = classifications

    @property
    def acknowledged_by_username(self):
        """`{ str }`
            \nUsername who acknowledged the alerts.
        """ # noqa: E501
        return self.__acknowledged_by_username

    @acknowledged_by_username.setter
    def acknowledged_by_username(self, acknowledged_by_username):

        self.__acknowledged_by_username = acknowledged_by_username

    @property
    def message(self):
        """`{ str }`
            \nAlerts message
        """ # noqa: E501
        return self.__message

    @message.setter
    def message(self, message):

        self.__message = message

    @property
    def detailed_message(self):
        """`{ str }`
            \nDetailed alerts message.
        """ # noqa: E501
        return self.__detailed_message

    @detailed_message.setter
    def detailed_message(self, detailed_message):

        self.__detailed_message = detailed_message

    @property
    def alert_title(self):
        """`{ str }`
            \nTitle of the alert.
        """ # noqa: E501
        return self.__alert_title

    @alert_title.setter
    def alert_title(self, alert_title):

        self.__alert_title = alert_title

    @property
    def operation_type(self):
        """`{ str }`
            \nOperation type of alerts.
        """ # noqa: E501
        return self.__operation_type

    @operation_type.setter
    def operation_type(self, operation_type):

        self.__operation_type = operation_type

    @property
    def acknowledged_time_stamp_in_usecs(self):
        """`{ int }`
            \nAcknowledged timestamp in microseconds.
        """ # noqa: E501
        return self.__acknowledged_time_stamp_in_usecs

    @acknowledged_time_stamp_in_usecs.setter
    def acknowledged_time_stamp_in_usecs(self, acknowledged_time_stamp_in_usecs):

        self.__acknowledged_time_stamp_in_usecs = acknowledged_time_stamp_in_usecs

    @property
    def resolved_time_stamp_in_usecs(self):
        """`{ int }`
            \nResolved timestamp in microseconds.
        """ # noqa: E501
        return self.__resolved_time_stamp_in_usecs

    @resolved_time_stamp_in_usecs.setter
    def resolved_time_stamp_in_usecs(self, resolved_time_stamp_in_usecs):

        self.__resolved_time_stamp_in_usecs = resolved_time_stamp_in_usecs

    @property
    def resolved_by_username(self):
        """`{ str }`
            \nUsername who resolved the alerts.
        """ # noqa: E501
        return self.__resolved_by_username

    @resolved_by_username.setter
    def resolved_by_username(self, resolved_by_username):

        self.__resolved_by_username = resolved_by_username

    @property
    def entity_types(self):
        """`{ list[str] }`
            \nEntity type to get the alerts.
        """ # noqa: E501
        return self.__entity_types

    @entity_types.setter
    def entity_types(self, entity_types):

        self.__entity_types = entity_types

    @property
    def user_defined(self):
        """`{ bool }`
            \nIndicates whether the alert is user-defined.
        """ # noqa: E501
        return self.__user_defined

    @user_defined.setter
    def user_defined(self, user_defined):

        self.__user_defined = user_defined

    @property
    def entity_ids(self):
        """`{ list[str] }`
            \nList of entity extIds.
        """ # noqa: E501
        return self.__entity_ids

    @entity_ids.setter
    def entity_ids(self, entity_ids):

        self.__entity_ids = entity_ids

    @property
    def entity_uuids(self):
        """`{ list[str] }`
            \nList of UUID for entities.
        """ # noqa: E501
        return self.__entity_uuids

    @entity_uuids.setter
    def entity_uuids(self, entity_uuids):

        self.__entity_uuids = entity_uuids

    @property
    def affected_entities(self):
        """`{ list[object] }`
            \nList of affected entities.
        """ # noqa: E501
        return self.__affected_entities

    @affected_entities.setter
    def affected_entities(self, affected_entities):

        self.__affected_entities = affected_entities

    @property
    def context_types(self):
        """`{ list[str] }`
            \nList of alert context types.
        """ # noqa: E501
        return self.__context_types

    @context_types.setter
    def context_types(self, context_types):

        self.__context_types = context_types

    @property
    def context_values(self):
        """`{ list[str] }`
            \nList of alert context values.
        """ # noqa: E501
        return self.__context_values

    @context_values.setter
    def context_values(self, context_values):

        self.__context_values = context_values

    @property
    def possible_causes(self):
        """`{ list[object] }`
            \nThe possible causes for this alert.
        """ # noqa: E501
        return self.__possible_causes

    @possible_causes.setter
    def possible_causes(self, possible_causes):

        self.__possible_causes = possible_causes

    @property
    def alert_details(self):
        """`{ object }`
            \nAlert description
        """ # noqa: E501
        return self.__alert_details

    @alert_details.setter
    def alert_details(self, alert_details):

        self.__alert_details = alert_details

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Alert, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Alert):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

