# Generated by Django 3.0.14 on 2022-04-11 10:23

import core.fields
import dirtyfields.dirtyfields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import invoice.mixins
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
        ('invoice', '0005_invoice_bill_roles_for_accountant'),
    ]

    operations = [
        migrations.CreateModel(
            name='PaymentInvoice',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', models.JSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('code_receipt', models.CharField(db_column='CodeReceipt', max_length=255, null=True)),
                ('label', models.CharField(db_column='Label', max_length=255, null=True)),
                ('reconciliation_status', models.SmallIntegerField(choices=[(0, 'rejected'), (1, 'accepted'), (2, 'refunded'), (3, 'cancelled')], db_column='ReconciliationStatus')),
                ('fees', models.DecimalField(db_column='Fees', decimal_places=2, max_digits=18, null=True)),
                ('amount_received', models.DecimalField(db_column='AmountReceived', decimal_places=2, max_digits=18, null=True)),
                ('date_payment', core.fields.DateField(db_column='DatePayment', null=True)),
                ('payment_origin', models.CharField(db_column='PaymentOrigin', max_length=255, null=True)),
                ('payer_ref', models.CharField(db_column='PayerRef', max_length=255)),
                ('payer_name', models.CharField(db_column='PayerName', max_length=255, null=True)),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='paymentinvoice_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='paymentinvoice_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblPaymentInvoice',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPaymentInvoice',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', models.JSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('code_receipt', models.CharField(db_column='CodeReceipt', max_length=255, null=True)),
                ('label', models.CharField(db_column='Label', max_length=255, null=True)),
                ('reconciliation_status', models.SmallIntegerField(choices=[(0, 'rejected'), (1, 'accepted'), (2, 'refunded'), (3, 'cancelled')], db_column='ReconciliationStatus')),
                ('fees', models.DecimalField(db_column='Fees', decimal_places=2, max_digits=18, null=True)),
                ('amount_received', models.DecimalField(db_column='AmountReceived', decimal_places=2, max_digits=18, null=True)),
                ('date_payment', core.fields.DateField(db_column='DatePayment', null=True)),
                ('payment_origin', models.CharField(db_column='PaymentOrigin', max_length=255, null=True)),
                ('payer_ref', models.CharField(db_column='PayerRef', max_length=255)),
                ('payer_name', models.CharField(db_column='PayerName', max_length=255, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical payment invoice',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalDetailPaymentInvoice',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', models.JSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('subject_id', models.CharField(db_column='SubjectId', max_length=255, null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'rejected'), (1, 'accepted'), (2, 'refunded'), (3, 'cancelled')], db_column='Status')),
                ('fees', models.DecimalField(db_column='Fees', decimal_places=2, max_digits=18, null=True)),
                ('amount', models.DecimalField(db_column='Amount', decimal_places=2, max_digits=18, null=True)),
                ('reconcilation_id', models.CharField(db_column='ReconcilationId', max_length=255, null=True)),
                ('reconcilation_date', models.DateField(db_column='ReconcilationDate', null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('payment', models.ForeignKey(blank=True, db_column='PaymentUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='invoice.PaymentInvoice')),
                ('subject_type', models.ForeignKey(blank=True, db_column='SubjectType', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical detail payment invoice',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='DetailPaymentInvoice',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', models.JSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('subject_id', models.CharField(db_column='SubjectId', max_length=255, null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'rejected'), (1, 'accepted'), (2, 'refunded'), (3, 'cancelled')], db_column='Status')),
                ('fees', models.DecimalField(db_column='Fees', decimal_places=2, max_digits=18, null=True)),
                ('amount', models.DecimalField(db_column='Amount', decimal_places=2, max_digits=18, null=True)),
                ('reconcilation_id', models.CharField(db_column='ReconcilationId', max_length=255, null=True)),
                ('reconcilation_date', models.DateField(db_column='ReconcilationDate', null=True)),
                ('payment', models.ForeignKey(db_column='PaymentUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='payment_invoice', to='invoice.PaymentInvoice')),
                ('subject_type', models.ForeignKey(db_column='SubjectType', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='detailpaymentinvoice_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='detailpaymentinvoice_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblDetailPaymentInvoice',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
    ]
