# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetSyntheticMonitoringProbeResult',
    'AwaitableGetSyntheticMonitoringProbeResult',
    'get_synthetic_monitoring_probe',
    'get_synthetic_monitoring_probe_output',
]

@pulumi.output_type
class GetSyntheticMonitoringProbeResult:
    """
    A collection of values returned by getSyntheticMonitoringProbe.
    """
    def __init__(__self__, id=None, labels=None, latitude=None, longitude=None, name=None, public=None, region=None, tenant_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if latitude and not isinstance(latitude, float):
            raise TypeError("Expected argument 'latitude' to be a float")
        pulumi.set(__self__, "latitude", latitude)
        if longitude and not isinstance(longitude, float):
            raise TypeError("Expected argument 'longitude' to be a float")
        pulumi.set(__self__, "longitude", longitude)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public and not isinstance(public, bool):
            raise TypeError("Expected argument 'public' to be a bool")
        pulumi.set(__self__, "public", public)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tenant_id and not isinstance(tenant_id, int):
            raise TypeError("Expected argument 'tenant_id' to be a int")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the probe.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Custom labels to be included with collected metrics and logs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def latitude(self) -> float:
        """
        Latitude coordinates.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> float:
        """
        Longitude coordinates.
        """
        return pulumi.get(self, "longitude")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the probe.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def public(self) -> bool:
        """
        Public probes are run by Grafana Labs and can be used by all users. Only Grafana Labs managed public probes will be set to `true`.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region of the probe.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> int:
        """
        The tenant ID of the probe.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetSyntheticMonitoringProbeResult(GetSyntheticMonitoringProbeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSyntheticMonitoringProbeResult(
            id=self.id,
            labels=self.labels,
            latitude=self.latitude,
            longitude=self.longitude,
            name=self.name,
            public=self.public,
            region=self.region,
            tenant_id=self.tenant_id)


def get_synthetic_monitoring_probe(name: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSyntheticMonitoringProbeResult:
    """
    Data source for retrieving a single probe by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    atlanta = grafana.get_synthetic_monitoring_probe(name="Atlanta")
    ```


    :param str name: Name of the probe.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:index/getSyntheticMonitoringProbe:getSyntheticMonitoringProbe', __args__, opts=opts, typ=GetSyntheticMonitoringProbeResult).value

    return AwaitableGetSyntheticMonitoringProbeResult(
        id=__ret__.id,
        labels=__ret__.labels,
        latitude=__ret__.latitude,
        longitude=__ret__.longitude,
        name=__ret__.name,
        public=__ret__.public,
        region=__ret__.region,
        tenant_id=__ret__.tenant_id)


@_utilities.lift_output_func(get_synthetic_monitoring_probe)
def get_synthetic_monitoring_probe_output(name: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSyntheticMonitoringProbeResult]:
    """
    Data source for retrieving a single probe by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    atlanta = grafana.get_synthetic_monitoring_probe(name="Atlanta")
    ```


    :param str name: Name of the probe.
    """
    ...
