"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License").
You may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cross_account_dns_delegator_1 = require("../lib/dns/cross-account-dns-delegator");
const aws_cdk_lib_1 = require("aws-cdk-lib");
test("subdomain created", () => {
    const stack = new aws_cdk_lib_1.Stack();
    new cross_account_dns_delegator_1.CrossAccountDNSDelegator(stack, "myAccount", {
        zoneName: "appsubdomain.stagesubdomain.mydomain.com",
    });
    expect(stack).toHaveResource("AWS::Route53::HostedZone", {
        Name: "appsubdomain.stagesubdomain.mydomain.com."
    });
    expect(stack).toHaveResource("Custom::CrossAccountZoneDelegationRecord", {
        recordName: "appsubdomain.stagesubdomain.mydomain.com"
    });
});
//# sourceMappingURL=data:application/json;base64,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