"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDNSUpdateRoleNameFromServiceRecordName = exports.getSubdomainPrefix = exports.getDNSUpdateRoleNameFromSubZoneName = void 0;
const DNS_UPDATE_ROLE_SUFFIX = '-dns-update';
exports.getDNSUpdateRoleNameFromSubZoneName = (subZoneName) => {
    return `${subZoneName}${DNS_UPDATE_ROLE_SUFFIX}`.toLocaleLowerCase();
};
exports.getSubdomainPrefix = (accountName, accountStageName) => {
    if (!accountName) {
        throw new Error(`accountName needs to be provided. aborting.`);
    }
    let prefix = accountStageName ? accountStageName : accountName;
    prefix = prefix.toLowerCase();
    prefix = prefix.replace(' ', '-');
    return prefix;
};
exports.getDNSUpdateRoleNameFromServiceRecordName = (serviceRecordName) => {
    // Keep only the root domain as it is used for the role name "landingpage.dev.ilovemylocalfarmer.dev".split('.').splice(1).join('.') => 'dev.ilovemylocalfarmer.dev'
    return exports.getDNSUpdateRoleNameFromSubZoneName(serviceRecordName
        .split(".")
        .splice(1)
        .join("."));
};
//# sourceMappingURL=data:application/json;base64,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