"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CrossAccountZoneDelegationRecord = void 0;
const constructs_1 = require("constructs");
const core = require("aws-cdk-lib");
const cross_account_zone_delegation_record_provider_1 = require("./cross-account-zone-delegation-record-provider");
/**
 * Create a NS zone delegation record in the target account
 */
class CrossAccountZoneDelegationRecord extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { targetAccount, targetRoleToAssume } = props;
        const roleArnToAssume = targetAccount && targetRoleToAssume ?
            `arn:aws:iam::${targetAccount}:role/${targetRoleToAssume}`
            : undefined;
        const stack = core.Stack.of(this);
        const crossAccountZoneDelegationRecordProvider = new cross_account_zone_delegation_record_provider_1.CrossAccountZoneDelegationRecordProvider(stack, 'CrossAccountZoneDelegationRecordProvider', roleArnToAssume);
        new core.CustomResource(this, `CrossAccountZoneDelegationRecord-${props.recordName}`, {
            serviceToken: crossAccountZoneDelegationRecordProvider.provider.serviceToken,
            resourceType: "Custom::CrossAccountZoneDelegationRecord",
            properties: {
                ...props
            },
        });
    }
}
exports.CrossAccountZoneDelegationRecord = CrossAccountZoneDelegationRecord;
//# sourceMappingURL=data:application/json;base64,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