"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RootDNSStack = void 0;
const cdk = require("aws-cdk-lib");
const dns_1 = require("./dns");
/**
 * A Stack creating a root DNS Zone with subzone delegation capabilities
 */
class RootDNSStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.rootDns = new dns_1.RootDns(this, 'RootDNSZone', props.rootDnsProps);
    }
}
exports.RootDNSStack = RootDNSStack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZG5zLXN0YWNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZG5zLXN0YWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLG1DQUFtQztBQUNuQywrQkFBNEM7QUFZNUM7O0dBRUc7QUFDSCxNQUFhLFlBQWEsU0FBUSxHQUFHLENBQUMsS0FBSztJQUd6QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxhQUFPLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDdEUsQ0FBQztDQUNGO0FBUkQsb0NBUUMiLCJzb3VyY2VzQ29udGVudCI6WyJcbmltcG9ydCB7Q29uc3RydWN0fSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQge1Jvb3REbnMsIFJvb3REbnNQcm9wc30gZnJvbSAnLi9kbnMnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgb2YgdGhlIFJvb3QgRE5TIFN0YWNrXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUm9vdEROU1N0YWNrUHJvcHMgZXh0ZW5kcyBjZGsuU3RhY2tQcm9wcyB7XG4gIC8qKlxuICAgKiBQcm9wZXJ0aWVzIG9mIHRoZSBSb290IEROUyBDb25zdHJ1Y3RcbiAgICovXG4gIHJlYWRvbmx5IHJvb3REbnNQcm9wczogUm9vdERuc1Byb3BzO1xufVxuXG4vKipcbiAqIEEgU3RhY2sgY3JlYXRpbmcgYSByb290IEROUyBab25lIHdpdGggc3Viem9uZSBkZWxlZ2F0aW9uIGNhcGFiaWxpdGllc1xuICovXG5leHBvcnQgY2xhc3MgUm9vdEROU1N0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgcHVibGljIHJvb3REbnM6IFJvb3REbnM7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJvb3RETlNTdGFja1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICB0aGlzLnJvb3REbnMgPSBuZXcgUm9vdERucyh0aGlzLCAnUm9vdEROU1pvbmUnLCBwcm9wcy5yb290RG5zUHJvcHMpO1xuICB9XG59Il19