

from ..utils import Object


class RemoteFile(Object):
    """
    Represents a remote file

    Attributes:
        ID (:obj:`str`): ``RemoteFile``

    Args:
        id (:obj:`str`):
            Remote file identifier; may be emptyCan be used across application restarts or even from other devices for the current userUniquely identifies a file, but a file can have a lot of different valid identifiersIf the ID starts with "http://" or "https://", it represents the HTTP URL of the fileTDLib is currently unable to download files if only their URL is knownIf downloadFile is called on such a file or if it is sent to a secret chat, TDLib starts a file generation process by sending updateFileGenerationStart to the client with the HTTP URL in the original_path and "#url#" as the conversion stringClients should generate the file by downloading it to the specified location
        unique_id (:obj:`str`):
            Unique file identifier; may be empty if unknownThe unique file identifier which is the same for the same file even for different users and is persistent over time
        is_uploading_active (:obj:`bool`):
            True, if the file is currently being uploaded (or a remote copy is being generated by some other means)
        is_uploading_completed (:obj:`bool`):
            True, if a remote copy is fully available
        uploaded_size (:obj:`int`):
            Size of the remote available part of the file; 0 if unknown

    Returns:
        RemoteFile

    Raises:
        :class:`telegram.Error`
    """
    ID = "remoteFile"

    def __init__(self, id, unique_id, is_uploading_active, is_uploading_completed, uploaded_size, **kwargs):
        
        self.id = id  # str
        self.unique_id = unique_id  # str
        self.is_uploading_active = is_uploading_active  # bool
        self.is_uploading_completed = is_uploading_completed  # bool
        self.uploaded_size = uploaded_size  # int

    @staticmethod
    def read(q: dict, *args) -> "RemoteFile":
        id = q.get('id')
        unique_id = q.get('unique_id')
        is_uploading_active = q.get('is_uploading_active')
        is_uploading_completed = q.get('is_uploading_completed')
        uploaded_size = q.get('uploaded_size')
        return RemoteFile(id, unique_id, is_uploading_active, is_uploading_completed, uploaded_size)
