

from ..utils import Object


class LocalFile(Object):
    """
    Represents a local file

    Attributes:
        ID (:obj:`str`): ``LocalFile``

    Args:
        path (:obj:`str`):
            Local path to the locally available file part; may be empty
        can_be_downloaded (:obj:`bool`):
            True, if it is possible to try to download or generate the file
        can_be_deleted (:obj:`bool`):
            True, if the file can be deleted
        is_downloading_active (:obj:`bool`):
            True, if the file is currently being downloaded (or a local copy is being generated by some other means)
        is_downloading_completed (:obj:`bool`):
            True, if the local copy is fully available
        download_offset (:obj:`int`):
            Download will be started from this offsetdownloaded_prefix_size is calculated from this offset
        downloaded_prefix_size (:obj:`int`):
            If is_downloading_completed is false, then only some prefix of the file starting from download_offset is ready to be readdownloaded_prefix_size is the size of that prefix
        downloaded_size (:obj:`int`):
            Total downloaded file bytesShould be used only for calculating download progressThe actual file size may be bigger, and some parts of it may contain garbage

    Returns:
        LocalFile

    Raises:
        :class:`telegram.Error`
    """
    ID = "localFile"

    def __init__(self, path, can_be_downloaded, can_be_deleted, is_downloading_active, is_downloading_completed, download_offset, downloaded_prefix_size, downloaded_size, **kwargs):
        
        self.path = path  # str
        self.can_be_downloaded = can_be_downloaded  # bool
        self.can_be_deleted = can_be_deleted  # bool
        self.is_downloading_active = is_downloading_active  # bool
        self.is_downloading_completed = is_downloading_completed  # bool
        self.download_offset = download_offset  # int
        self.downloaded_prefix_size = downloaded_prefix_size  # int
        self.downloaded_size = downloaded_size  # int

    @staticmethod
    def read(q: dict, *args) -> "LocalFile":
        path = q.get('path')
        can_be_downloaded = q.get('can_be_downloaded')
        can_be_deleted = q.get('can_be_deleted')
        is_downloading_active = q.get('is_downloading_active')
        is_downloading_completed = q.get('is_downloading_completed')
        download_offset = q.get('download_offset')
        downloaded_prefix_size = q.get('downloaded_prefix_size')
        downloaded_size = q.get('downloaded_size')
        return LocalFile(path, can_be_downloaded, can_be_deleted, is_downloading_active, is_downloading_completed, download_offset, downloaded_prefix_size, downloaded_size)
