import sys

from orangewidget import gui
from PyQt5.QtWidgets import QApplication

from orangecontrib.shadow.widgets.gui import ow_hyperboloid_element, ow_optical_element
from orangecontrib.shadow.util import ShadowOpticalElement


class HyperboloidMirror(ow_hyperboloid_element.HyperboloidElement):

    name = "Hyperboloid Mirror"
    description = "Shadow OE: Hyperboloid Mirror"
    icon = "icons/hyperboloid_mirror.png"
    maintainer = "Luca Rebuffi"
    maintainer_email = "lrebuffi(@at@)anl.gov"
    priority = 7
    category = "Optical Elements"
    keywords = ["data", "file", "load", "read"]

    def __init__(self):
        graphical_Options=ow_optical_element.GraphicalOptions(is_mirror=True)

        super().__init__(graphical_Options)

        gui.rubber(self.controlArea)

        gui.rubber(self.mainArea)

    ################################################################
    #
    #  SHADOW MANAGEMENT
    #
    ################################################################

    def instantiateShadowOE(self):
        return ShadowOpticalElement.create_hyperboloid_mirror()

if __name__ == "__main__":
    a = QApplication(sys.argv)
    ow = HyperboloidMirror()
    ow.show()
    a.exec_()
    ow.saveSettings()
