# -*- coding: utf-8 -*-
# Generated by Django 1.11.9 on 2020-06-25 14:11
from __future__ import unicode_literals

from django.db import migrations, models
import tinymce.models


def add_default_values(apps, _schema_editor):
    Notification = apps.get_model('notifications', 'Notification')
    for notif in Notification.objects.all():
        notif.name_is = notif.__dict__['name']
        notif.name_en = notif.__dict__['name']
        notif.message_en = notif.__dict__['message']
        notif.message_is = notif.__dict__['message']
        notif.save()


class Migration(migrations.Migration):

    dependencies = [
        ('notifications', '0002_add_image_field'),
    ]

    operations = [
        migrations.AddField(
            model_name='notification',
            name='display_only_if_url_path_matches_regex',
            field=models.CharField(default='.*', help_text='Only display this notification if the provided regex matches the url-path', max_length=64),
        ),
        migrations.AddField(
            model_name='notification',
            name='external_id',
            field=models.IntegerField(null=True),
        ),
        migrations.AddField(
            model_name='notification',
            name='message_en',
            field=tinymce.models.HTMLField(help_text='Full message as shown to user', null=True),
        ),
        migrations.AddField(
            model_name='notification',
            name='message_is',
            field=tinymce.models.HTMLField(help_text='Full message as shown to user', null=True),
        ),
        migrations.AddField(
            model_name='notification',
            name='name_en',
            field=models.CharField(help_text='Used to reference notification, shown in title for some looks', max_length=250, null=True),
        ),
        migrations.AddField(
            model_name='notification',
            name='name_is',
            field=models.CharField(help_text='Used to reference notification, shown in title for some looks', max_length=250, null=True),
        ),
        migrations.RunPython(
            add_default_values,
            reverse_code=migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='notification',
            name='name_en',
            field=models.CharField(help_text='Used to reference notification, shown in title for some looks', max_length=250, unique=True, null=False),
        ),
        migrations.AlterField(
            model_name='notification',
            name='name_is',
            field=models.CharField(help_text='Used to reference notification, shown in title for some looks', max_length=250, unique=True, null=False),
        ),
    ]
