/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.fakes.MinecraftServerInterface;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2088;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_27;
import net.minecraft.class_2780;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2861;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3754;
import net.minecraft.class_3949;
import net.minecraft.class_4543;
import net.minecraft.class_5268;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.server.MinecraftServer;

public class WorldTools {
    private static final class_3949 NOOP_LISTENER = new NoopWorldGenerationProgressListener();

    public static boolean canHasChunk(class_3218 world, class_1923 chpos, Map<String, class_2861> regionCache, boolean deepcheck) {
        if (world.method_8402(chpos.field_9181, chpos.field_9180, class_2806.field_16423, false) != null) {
            return true;
        }
        String currentRegionName = "r." + chpos.method_17885() + "." + chpos.method_17886() + ".mca";
        if (regionCache != null && regionCache.containsKey(currentRegionName)) {
            class_2861 region = regionCache.get(currentRegionName);
            if (region == null) {
                return false;
            }
            return region.method_12423(chpos);
        }
        Path regionPath = new File(((MinecraftServerInterface)world.method_8503()).getCMSession().method_27424(world.method_27983()), "region").toPath();
        Path regionFilePath = regionPath.resolve(currentRegionName);
        File regionFile = regionFilePath.toFile();
        if (!regionFile.exists()) {
            if (regionCache != null) {
                regionCache.put(currentRegionName, null);
            }
            return false;
        }
        if (!deepcheck) {
            return true;
        }
        try {
            class_2861 region = new class_2861(regionFile, regionPath.toFile(), true);
            if (regionCache != null) {
                regionCache.put(currentRegionName, region);
            }
            return region.method_12423(chpos);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static boolean createWorld(MinecraftServer server, String worldKey, Long seed) {
        class_2794 chunkGenerator2;
        class_2874 dimensionType2;
        class_2960 worldId = new class_2960(worldKey);
        class_3218 overWorld = server.method_30002();
        Set worldKeys = server.method_29435();
        for (class_5321 worldRegistryKey : worldKeys) {
            if (!worldRegistryKey.method_29177().equals((Object)worldId)) continue;
            return false;
        }
        class_5268 serverWorldProperties = server.method_27728().method_27859();
        class_5285 generatorOptions = server.method_27728().method_28057();
        boolean bl = generatorOptions.method_28033();
        long l = generatorOptions.method_28028();
        long m = class_4543.method_27984((long)l);
        ImmutableList list = ImmutableList.of();
        class_2370 simpleRegistry = generatorOptions.method_28609();
        class_5363 dimensionOptions = (class_5363)simpleRegistry.method_29107(class_5363.field_25412);
        if (dimensionOptions == null) {
            dimensionType2 = (class_2874)server.method_30611().method_30518().method_31140(class_2874.field_24753);
            chunkGenerator2 = class_5285.method_28604((class_2378)server.method_30611().method_30530(class_2378.field_25114), (class_2378)server.method_30611().method_30530(class_2378.field_26374), (long)new Random().nextLong());
        } else {
            dimensionType2 = dimensionOptions.method_29570();
            chunkGenerator2 = dimensionOptions.method_29571();
        }
        class_5321 customWorld = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)worldId);
        chunkGenerator2 = new class_3754((class_1966)new class_2088(seed == null ? l : seed, false, false, (class_2378)server.method_30611().method_30530(class_2378.field_25114)), seed == null ? l : seed, () -> (class_5284)server.method_30611().method_30530(class_2378.field_26374).method_31140(class_5284.field_26355));
        class_3218 serverWorld = new class_3218(server, class_156.method_18349(), ((MinecraftServerInterface)server).getCMSession(), (class_5268)new class_27(server.method_27728(), serverWorldProperties), customWorld, dimensionType2, NOOP_LISTENER, chunkGenerator2, bl, seed == null ? l : seed, (List)list, false);
        overWorld.method_8621().method_11983((class_2780)new class_2780.class_3976(serverWorld.method_8621()));
        ((MinecraftServerInterface)server).getCMWorlds().put((class_5321<class_1937>)customWorld, serverWorld);
        return true;
    }

    public static void forceChunkUpdate(class_2338 pos, class_3218 world) {
        int vd;
        int vvd;
        List nearbyPlayers;
        class_2818 worldChunk = world.method_14178().method_12126(pos.method_10263() >> 4, pos.method_10260() >> 4, false);
        if (worldChunk != null && !(nearbyPlayers = world.method_18766(arg_0 -> WorldTools.lambda$forceChunkUpdate$1(pos, vvd = (vd = world.method_8503().method_3760().method_14568() * 16) * vd, arg_0))).isEmpty()) {
            class_2672 packet = new class_2672(worldChunk, 65535);
            class_1923 chpos = new class_1923(pos);
            nearbyPlayers.forEach(p -> p.field_13987.method_14364((class_2596)packet));
        }
    }

    private static /* synthetic */ boolean lambda$forceChunkUpdate$1(class_2338 pos, int vvd, class_3222 p) {
        return pos.method_10268(p.method_23317(), (double)pos.method_10264(), p.method_23321(), true) < (double)vvd;
    }

    private static class NoopWorldGenerationProgressListener
    implements class_3949 {
        private NoopWorldGenerationProgressListener() {
        }

        public void method_17669(class_1923 spawnPos) {
        }

        public void method_17670(class_1923 pos, class_2806 status) {
        }

        public void method_17671() {
        }
    }
}

