/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.AbstractListValue;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.LContainerValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Operators {
    public static final Map<String, Integer> precedence = new HashMap<String, Integer>(){
        {
            this.put("attribute~:", 80);
            this.put("unary+-!", 60);
            this.put("exponent^", 40);
            this.put("multiplication*/%", 30);
            this.put("addition+-", 20);
            this.put("compare>=><=<", 10);
            this.put("equal==!=", 7);
            this.put("and&&", 5);
            this.put("or||", 4);
            this.put("assign=<>", 3);
            this.put("def->...", 2);
            this.put("nextop;", 1);
        }
    };

    public static void apply(Expression expression) {
        expression.addBinaryOperator("+", precedence.get("addition+-"), true, Value::add);
        expression.addBinaryOperator("-", precedence.get("addition+-"), true, Value::subtract);
        expression.addBinaryOperator("*", precedence.get("multiplication*/%"), true, Value::multiply);
        expression.addBinaryOperator("/", precedence.get("multiplication*/%"), true, Value::divide);
        expression.addBinaryOperator("%", precedence.get("multiplication*/%"), true, (v1, v2) -> new NumericValue(NumericValue.asNumber(v1).getDouble() % NumericValue.asNumber(v2).getDouble()));
        expression.addBinaryOperator("^", precedence.get("exponent^"), false, (v1, v2) -> new NumericValue(Math.pow(NumericValue.asNumber(v1).getDouble(), NumericValue.asNumber(v2).getDouble())));
        expression.addLazyBinaryOperator("&&", precedence.get("and&&"), false, (c, t, lv1, lv2) -> {
            Value v1 = lv1.evalValue((Context)c, 2);
            if (!v1.getBoolean()) {
                return (cc, tt) -> v1;
            }
            return lv2;
        });
        expression.addLazyBinaryOperator("||", precedence.get("or||"), false, (c, t, lv1, lv2) -> {
            Value v1 = lv1.evalValue((Context)c, 2);
            if (v1.getBoolean()) {
                return (cc, tt) -> v1;
            }
            return lv2;
        });
        expression.addBinaryOperator("~", precedence.get("attribute~:"), true, Value::in);
        expression.addBinaryOperator(">", precedence.get("compare>=><=<"), false, (v1, v2) -> v1.compareTo((Value)v2) > 0 ? Value.TRUE : Value.FALSE);
        expression.addBinaryOperator(">=", precedence.get("compare>=><=<"), false, (v1, v2) -> v1.compareTo((Value)v2) >= 0 ? Value.TRUE : Value.FALSE);
        expression.addBinaryOperator("<", precedence.get("compare>=><=<"), false, (v1, v2) -> v1.compareTo((Value)v2) < 0 ? Value.TRUE : Value.FALSE);
        expression.addBinaryOperator("<=", precedence.get("compare>=><=<"), false, (v1, v2) -> v1.compareTo((Value)v2) <= 0 ? Value.TRUE : Value.FALSE);
        expression.addBinaryOperator("==", precedence.get("equal==!="), false, (v1, v2) -> v1.equals(v2) ? Value.TRUE : Value.FALSE);
        expression.addBinaryOperator("!=", precedence.get("equal==!="), false, (v1, v2) -> v1.equals(v2) ? Value.FALSE : Value.TRUE);
        expression.addLazyBinaryOperator("=", precedence.get("assign=<>"), false, (c, t, lv1, lv2) -> {
            Value v1 = lv1.evalValue((Context)c, 9);
            Value v2 = lv2.evalValue((Context)c);
            if (v1 instanceof ListValue.ListConstructorValue && v2 instanceof ListValue) {
                List<Value> ll = ((ListValue)v1).getItems();
                List<Value> rl = ((ListValue)v2).getItems();
                if (ll.size() < rl.size()) {
                    throw new InternalExpressionException("Too many values to unpack");
                }
                if (ll.size() > rl.size()) {
                    throw new InternalExpressionException("Too few values to unpack");
                }
                for (Value v : ll) {
                    v.assertAssignable();
                }
                Iterator<Value> li = ll.iterator();
                Iterator<Value> ri = rl.iterator();
                while (li.hasNext()) {
                    String lname = li.next().getVariable();
                    Value vval = ri.next().reboundedTo(lname);
                    expression.setAnyVariable((Context)c, lname, (cc, tt) -> vval);
                }
                return (cc, tt) -> Value.TRUE;
            }
            if (v1 instanceof LContainerValue) {
                ContainerValueInterface container = ((LContainerValue)v1).getContainer();
                if (container == null) {
                    return (cc, tt) -> Value.NULL;
                }
                Value address = ((LContainerValue)v1).getAddress();
                if (!container.put(address, v2)) {
                    return (cc, tt) -> Value.NULL;
                }
                return (cc, tt) -> v2;
            }
            v1.assertAssignable();
            String varname = v1.getVariable();
            Value copy = v2.reboundedTo(varname);
            LazyValue boundedLHS = (cc, tt) -> copy;
            expression.setAnyVariable((Context)c, varname, boundedLHS);
            return boundedLHS;
        });
        expression.addLazyBinaryOperator("+=", precedence.get("assign=<>"), false, (c, t, lv1, lv2) -> {
            LazyValue boundedLHS;
            Value v1 = lv1.evalValue((Context)c, 9);
            Value v2 = lv2.evalValue((Context)c);
            if (v1 instanceof ListValue.ListConstructorValue && v2 instanceof ListValue) {
                List<Value> ll = ((ListValue)v1).getItems();
                List<Value> rl = ((ListValue)v2).getItems();
                if (ll.size() < rl.size()) {
                    throw new InternalExpressionException("Too many values to unpack");
                }
                if (ll.size() > rl.size()) {
                    throw new InternalExpressionException("Too few values to unpack");
                }
                for (Value v : ll) {
                    v.assertAssignable();
                }
                Iterator<Value> li = ll.iterator();
                Iterator<Value> ri = rl.iterator();
                while (li.hasNext()) {
                    Value lval = li.next();
                    String lname = lval.getVariable();
                    Value result = lval.add(ri.next()).bindTo(lname);
                    expression.setAnyVariable((Context)c, lname, (cc, tt) -> result);
                }
                return (cc, tt) -> Value.TRUE;
            }
            if (v1 instanceof LContainerValue) {
                ContainerValueInterface cvi = ((LContainerValue)v1).getContainer();
                if (cvi == null) {
                    throw new InternalExpressionException("Failed to resolve left hand side of the += operation");
                }
                Value key = ((LContainerValue)v1).getAddress();
                Value value = cvi.get(key);
                if (value instanceof ListValue || value instanceof MapValue) {
                    ((AbstractListValue)value).append(v2);
                    return (cc, tt) -> value;
                }
                Value res = value.add(v2);
                cvi.put(key, res);
                return (cc, tt) -> res;
            }
            v1.assertAssignable();
            String varname = v1.getVariable();
            if (v1 instanceof ListValue || v1 instanceof MapValue) {
                ((AbstractListValue)v1).append(v2);
                boundedLHS = (cc, tt) -> v1;
            } else {
                Value result = v1.add(v2).bindTo(varname);
                boundedLHS = (cc, tt) -> result;
            }
            expression.setAnyVariable((Context)c, varname, boundedLHS);
            return boundedLHS;
        });
        expression.addLazyBinaryOperator("<>", precedence.get("assign=<>"), false, (c, t, lv1, lv2) -> {
            Value v1 = lv1.evalValue((Context)c);
            Value v2 = lv2.evalValue((Context)c);
            if (v1 instanceof ListValue.ListConstructorValue && v2 instanceof ListValue.ListConstructorValue) {
                List<Value> ll = ((ListValue)v1).getItems();
                List<Value> rl = ((ListValue)v2).getItems();
                if (ll.size() < rl.size()) {
                    throw new InternalExpressionException("Too many values to unpack");
                }
                if (ll.size() > rl.size()) {
                    throw new InternalExpressionException("Too few values to unpack");
                }
                for (Value v : ll) {
                    v.assertAssignable();
                }
                for (Value v : rl) {
                    v.assertAssignable();
                }
                Iterator<Value> li = ll.iterator();
                Iterator<Value> ri = rl.iterator();
                while (li.hasNext()) {
                    Value lval = li.next();
                    Value rval = ri.next();
                    String lname = lval.getVariable();
                    String rname = rval.getVariable();
                    lval.reboundedTo(rname);
                    rval.reboundedTo(lname);
                    expression.setAnyVariable((Context)c, lname, (cc, tt) -> rval);
                    expression.setAnyVariable((Context)c, rname, (cc, tt) -> lval);
                }
                return (cc, tt) -> Value.TRUE;
            }
            v1.assertAssignable();
            v2.assertAssignable();
            String lvalvar = v1.getVariable();
            String rvalvar = v2.getVariable();
            Value lval = v2.reboundedTo(lvalvar);
            Value rval = v1.reboundedTo(rvalvar);
            expression.setAnyVariable((Context)c, lvalvar, (cc, tt) -> lval);
            expression.setAnyVariable((Context)c, rvalvar, (cc, tt) -> rval);
            return (cc, tt) -> lval;
        });
        expression.addUnaryOperator("-", false, v -> NumericValue.asNumber(v).opposite());
        expression.addUnaryOperator("+", false, NumericValue::asNumber);
        expression.addLazyUnaryOperator("!", precedence.get("unary+-!"), false, (c, t, lv) -> lv.evalValue((Context)c, 2).getBoolean() ? (cc, tt) -> Value.FALSE : (cc, tt) -> Value.TRUE);
    }
}

