/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.command;

import carpet.fakes.BlockStateArgumentInterface;
import carpet.script.CarpetScriptHost;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BlockValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2177;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2245;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2264;
import net.minecraft.class_2270;
import net.minecraft.class_2273;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2585;
import net.minecraft.class_5473;

public abstract class CommandArgument {
    private static final List<? extends CommandArgument> baseTypes = Lists.newArrayList((Object[])new CommandArgument[]{new StringArgument(), new VanillaUnconfigurableArgument("bool", BoolArgumentType::bool, (c, p) -> new NumericValue(BoolArgumentType.getBool((CommandContext)c, (String)p)), false), new FloatArgument(), new IntArgument(), new WordArgument(), new GreedyStringArgument(), new VanillaUnconfigurableArgument("yaw", class_5473::method_30658, (c, p) -> new NumericValue(class_5473.method_30660((CommandContext)c, (String)p)), true), new BlockPosArgument(), new VanillaUnconfigurableArgument("block", class_2257::method_9653, (c, p) -> {
        class_2247 result = class_2257.method_9655((CommandContext)c, (String)p);
        return new BlockValue(result.method_9494(), null, null, ((BlockStateArgumentInterface)result).getCMTag());
    }, false), new VanillaUnconfigurableArgument("color", class_2177::method_9276, (c, p) -> {
        class_124 format = class_2177.method_9277((CommandContext)c, (String)p);
        return ListValue.of(StringValue.of(format.method_537()), new NumericValue(format.method_532() * 256 + 255));
    }, false), new VanillaUnconfigurableArgument("columnpos", class_2264::method_9701, (c, p) -> ValueConversions.of(class_2264.method_9702((CommandContext)c, (String)p)), false), new VanillaUnconfigurableArgument("dimension", class_2181::method_9288, (c, p) -> ValueConversions.of(class_2181.method_9289((CommandContext)c, (String)p)), false), new EntityArgument(), new VanillaUnconfigurableArgument("rotation", class_2270::method_9717, (c, p) -> {
        class_241 rot = class_2270.method_9716((CommandContext)c, (String)p).method_9709((class_2168)c.getSource());
        return ListValue.of(new NumericValue(rot.field_1343), new NumericValue(rot.field_1342));
    }, true), new VanillaUnconfigurableArgument("swizzle", class_2273::method_9721, (c, p) -> StringValue.of(class_2273.method_9720((CommandContext)c, (String)p).stream().map(class_2350.class_2351::method_15434).collect(Collectors.joining())), true), new VanillaUnconfigurableArgument("time", class_2245::method_9489, (c, p) -> new NumericValue(IntegerArgumentType.getInteger((CommandContext)c, (String)p)), false), new LocationArgument()});
    public static final Map<String, CommandArgument> builtIns = baseTypes.stream().collect(Collectors.toMap(CommandArgument::getTypeSuffix, a -> a));
    public static final CommandArgument DEFAULT = baseTypes.get(0);
    protected String suffix;
    protected Collection<String> examples;
    protected boolean needsMatching = false;

    private static CommandArgument getTypeForArgument(String argument, CarpetScriptHost host) {
        String[] components = argument.split("_");
        String suffix = components[components.length - 1].toLowerCase(Locale.ROOT);
        CommandArgument arg = host.appArgTypes.get(suffix);
        if (arg != null) {
            return arg;
        }
        return builtIns.getOrDefault(suffix, DEFAULT);
    }

    public static RequiredArgumentBuilder<class_2168, ?> argumentNode(String param, CarpetScriptHost host) {
        CommandArgument arg = CommandArgument.getTypeForArgument(param, host);
        return arg.needsMatching ? class_2170.method_9244((String)param, arg.getArgumentType()).suggests(arg::suggest) : class_2170.method_9244((String)param, arg.getArgumentType());
    }

    protected CommandArgument(String suffix, Collection<String> examples, boolean needsMatching) {
        this.suffix = suffix;
        this.examples = examples;
        this.needsMatching = needsMatching;
    }

    public static ArgumentType<?> getArgument(String param, CarpetScriptHost host) {
        return CommandArgument.getTypeForArgument(param, host).getArgumentType();
    }

    protected abstract ArgumentType<?> getArgumentType();

    public static Value getValue(CommandContext<class_2168> context, String param, CarpetScriptHost host) throws CommandSyntaxException {
        return CommandArgument.getTypeForArgument(param, host).getValueFromContext(context, param);
    }

    protected abstract Value getValueFromContext(CommandContext<class_2168> var1, String var2) throws CommandSyntaxException;

    public String getTypeSuffix() {
        return this.suffix;
    }

    public static CommandArgument buildFromConfig(String suffix, Map<String, Value> config) {
        if (!config.containsKey("type")) {
            throw new InternalExpressionException("Custom types should at least specify the base type");
        }
        String baseType = config.get("type").getString();
        if (!builtIns.containsKey(baseType)) {
            throw new InternalExpressionException("Unknown base type: " + baseType);
        }
        CommandArgument variant = builtIns.get(baseType).builder().get();
        variant.configure(config);
        variant.suffix = suffix;
        return variant;
    }

    protected void configure(Map<String, Value> config) {
        if (config.containsKey("suggest")) {
            Value suggestionValue = config.get("suggest");
            if (!(suggestionValue instanceof ListValue)) {
                throw new InternalExpressionException("Argument suggestions needs to be a list");
            }
            this.examples = ((ListValue)suggestionValue).getItems().stream().map(Value::getString).collect(Collectors.toSet());
            if (!this.examples.isEmpty()) {
                this.needsMatching = true;
            }
        }
    }

    public CompletableFuture<Suggestions> suggest(CommandContext<class_2168> context, SuggestionsBuilder suggestionsBuilder) {
        String prefix = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        this.suggestFor(prefix).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
        return suggestionsBuilder.buildFuture();
    }

    protected List<String> suggestFor(String prefix) {
        return this.getOptions().stream().filter(s -> this.optionMatchesPrefix(prefix, (String)s)).collect(Collectors.toList());
    }

    protected Collection<String> getOptions() {
        if (this.needsMatching) {
            return this.examples;
        }
        return Collections.singletonList("... " + this.getTypeSuffix());
    }

    protected boolean optionMatchesPrefix(String prefix, String option) {
        int i = 0;
        while (!option.startsWith(prefix, i)) {
            if ((i = option.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract Supplier<CommandArgument> builder();

    public static class VanillaUnconfigurableArgument
    extends CommandArgument {
        private Supplier<ArgumentType<?>> argumentTypeSupplier;
        private ValueExtractor valueExtractor;
        private boolean providesExamples;

        public VanillaUnconfigurableArgument(String suffix, Supplier<ArgumentType<?>> argumentTypeSupplier, ValueExtractor valueExtractor, boolean providesExamples) {
            super(suffix, argumentTypeSupplier.get().getExamples(), providesExamples);
            this.providesExamples = providesExamples;
            this.argumentTypeSupplier = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
        }

        @Override
        protected ArgumentType<?> getArgumentType() {
            return this.argumentTypeSupplier.get();
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            return this.valueExtractor.apply(context, param);
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return () -> new VanillaUnconfigurableArgument(this.getTypeSuffix(), this.argumentTypeSupplier, this.valueExtractor, this.providesExamples);
        }
    }

    @FunctionalInterface
    private static interface ValueExtractor {
        public Value apply(CommandContext<class_2168> var1, String var2) throws CommandSyntaxException;
    }

    private static class IntArgument
    extends CommandArgument {
        private Long min = null;
        private Long max = null;

        private IntArgument() {
            super("int", LongArgumentType.longArg().getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            if (this.min != null) {
                if (this.max != null) {
                    return LongArgumentType.longArg((long)this.min, (long)this.max);
                }
                return LongArgumentType.longArg((long)this.min);
            }
            return LongArgumentType.longArg();
        }

        @Override
        public Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            return new NumericValue(LongArgumentType.getLong(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config) {
            super.configure(config);
            if (config.containsKey("min")) {
                this.min = NumericValue.asNumber(config.get("min"), "min").getLong();
            }
            if (config.containsKey("max")) {
                this.max = NumericValue.asNumber(config.get("max"), "max").getLong();
            }
            if (this.max != null && this.min == null) {
                throw new InternalExpressionException("Double types cannot be only upper-bounded");
            }
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return () -> new FloatArgument();
        }
    }

    private static class FloatArgument
    extends CommandArgument {
        private Double min = null;
        private Double max = null;

        private FloatArgument() {
            super("float", DoubleArgumentType.doubleArg().getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            if (this.min != null) {
                if (this.max != null) {
                    return DoubleArgumentType.doubleArg((double)this.min, (double)this.max);
                }
                return DoubleArgumentType.doubleArg((double)this.min);
            }
            return DoubleArgumentType.doubleArg();
        }

        @Override
        public Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            return new NumericValue(DoubleArgumentType.getDouble(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config) {
            super.configure(config);
            if (config.containsKey("min")) {
                this.min = NumericValue.asNumber(config.get("min"), "min").getDouble();
            }
            if (config.containsKey("max")) {
                this.max = NumericValue.asNumber(config.get("max"), "max").getDouble();
            }
            if (this.max != null && this.min == null) {
                throw new InternalExpressionException("Double types cannot be only upper-bounded");
            }
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return FloatArgument::new;
        }
    }

    private static class EntityArgument
    extends CommandArgument {
        boolean onlyFans = false;
        boolean single = false;

        private EntityArgument() {
            super("entity", class_2186.method_9306().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType() {
            if (this.onlyFans) {
                return this.single ? class_2186.method_9305() : class_2186.method_9308();
            }
            return this.single ? class_2186.method_9309() : class_2186.method_9306();
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            List founds = (List)class_2186.method_9307(context, (String)param);
            if (this.single) {
                return founds.isEmpty() ? Value.NULL : new EntityValue((class_1297)founds.get(0));
            }
            return ListValue.wrap(founds.stream().map(EntityValue::new).collect(Collectors.toList()));
        }

        @Override
        protected void configure(Map<String, Value> config) {
            super.configure(config);
            this.onlyFans = config.getOrDefault("players", Value.FALSE).getBoolean();
            this.single = config.getOrDefault("single", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return EntityArgument::new;
        }
    }

    private static class LocationArgument
    extends CommandArgument {
        boolean blockCentered = true;

        private LocationArgument() {
            super("location", class_2277.method_9737().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType() {
            return class_2277.method_9735((boolean)this.blockCentered);
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            return ValueConversions.of(class_2277.method_9736(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config) {
            super.configure(config);
            this.blockCentered = config.getOrDefault("block_centered", Value.TRUE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return LocationArgument::new;
        }
    }

    private static class BlockPosArgument
    extends CommandArgument {
        private boolean mustBeLoaded = false;

        private BlockPosArgument() {
            super("pos", class_2262.method_9698().getExamples(), false);
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return class_2262.method_9698();
        }

        @Override
        public Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            class_2338 pos = this.mustBeLoaded ? class_2262.method_9696(context, (String)param) : class_2262.method_9697(context, (String)param);
            return ValueConversions.of(pos);
        }

        @Override
        protected void configure(Map<String, Value> config) {
            super.configure(config);
            this.mustBeLoaded = config.getOrDefault("loaded", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return BlockPosArgument::new;
        }
    }

    private static class GreedyStringArgument
    extends StringArgument {
        private GreedyStringArgument() {
            this.suffix = "text";
            this.examples = StringArgumentType.StringType.GREEDY_PHRASE.getExamples();
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return StringArgumentType.greedyString();
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return GreedyStringArgument::new;
        }
    }

    private static class WordArgument
    extends StringArgument {
        private WordArgument() {
            this.suffix = "term";
            this.examples = StringArgumentType.StringType.SINGLE_WORD.getExamples();
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return StringArgumentType.word();
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return WordArgument::new;
        }
    }

    private static class StringArgument
    extends CommandArgument {
        Set<String> validOptions = Collections.emptySet();
        boolean caseSensitive = false;

        private StringArgument() {
            super("string", StringArgumentType.StringType.QUOTABLE_PHRASE.getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return StringArgumentType.string();
        }

        @Override
        public Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            String choseValue = StringArgumentType.getString(context, (String)param);
            if (!this.caseSensitive) {
                choseValue = choseValue.toLowerCase(Locale.ROOT);
            }
            if (!this.validOptions.isEmpty() && !this.validOptions.contains(choseValue)) {
                throw new SimpleCommandExceptionType((Message)new class_2585("Incorrect value for " + param + ": " + choseValue)).create();
            }
            return StringValue.of(choseValue);
        }

        @Override
        protected void configure(Map<String, Value> config) {
            super.configure(config);
            this.caseSensitive = config.getOrDefault("case_sensitive", Value.FALSE).getBoolean();
            if (config.containsKey("options")) {
                Value optionsValue = config.get("options");
                if (!(optionsValue instanceof ListValue)) {
                    throw new InternalExpressionException("Custom sting type requires options passed as a list");
                }
                this.validOptions = ((ListValue)optionsValue).getItems().stream().map(v -> this.caseSensitive ? v.getString() : v.getString().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            }
        }

        @Override
        protected Collection<String> getOptions() {
            return this.validOptions.isEmpty() ? super.getOptions() : this.validOptions;
        }

        @Override
        protected Supplier<CommandArgument> builder() {
            return () -> new WordArgument();
        }
    }
}

