/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.fakes.SpawnHelperInnerInterface;
import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.InternalExpressionException;
import carpet.script.utils.SystemInfo;
import carpet.script.value.AbstractListValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.utils.SpawnReporter;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.class_1311;
import net.minecraft.class_1948;
import net.minecraft.class_3218;

public class Monitoring {
    public static void apply(Expression expression) {
        expression.addLazyFunction("system_info", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                Value ret = SystemInfo.getAll((CarpetContext)c);
                return (cc, tt) -> ret;
            }
            if (lv.size() == 1) {
                String what = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
                Value res = SystemInfo.get(what, (CarpetContext)c);
                if (res == null) {
                    throw new InternalExpressionException("Unknown option for 'system_info': " + what);
                }
                return (cc, tt) -> res;
            }
            throw new InternalExpressionException("'system_info' requires one or no parameters");
        });
        expression.addLazyFunction("get_mob_counts", -1, (c, t, lv) -> {
            AbstractListValue retVal;
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            class_1948.class_5262 info = world.method_14178().method_27908();
            if (info == null) {
                return LazyValue.NULL;
            }
            Object2IntMap mobcounts = info.method_27830();
            int chunks = ((SpawnHelperInnerInterface)info).cmGetChunkCount();
            if (lv.size() == 0) {
                HashMap<Value, Value> retDict = new HashMap<Value, Value>();
                for (class_1311 category : mobcounts.keySet()) {
                    int currentCap = (int)((double)(category.method_6134() * chunks) / SpawnReporter.currentMagicNumber());
                    retDict.put(new StringValue(category.method_15434().toLowerCase(Locale.ROOT)), ListValue.of(new NumericValue(mobcounts.getInt((Object)category)), new NumericValue(currentCap)));
                }
                retVal = MapValue.wrap(retDict);
            } else {
                String catString = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
                class_1311 cat = class_1311.method_28307((String)catString.toLowerCase(Locale.ROOT));
                if (cat == null) {
                    throw new InternalExpressionException("Unreconized mob category: " + catString);
                }
                retVal = ListValue.of(new NumericValue(mobcounts.getInt((Object)cat)), new NumericValue((int)((double)(cat.method_6134() * chunks) / SpawnReporter.currentMagicNumber())));
            }
            return (_c, _t) -> retVal;
        });
    }
}

