/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.fakes.IngredientInterface;
import carpet.fakes.RecipeManagerInterface;
import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.common.collect.Sets;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2290;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_3972;

public class Inventories {
    public static void apply(Expression expression) {
        expression.addLazyFunction("stack_limit", 1, (c, t, lv) -> {
            class_2290 item = NBTSerializableValue.parseItem(((LazyValue)lv.get(0)).evalValue((Context)c).getString());
            NumericValue res = new NumericValue(item.method_9785().method_7882());
            return (_c, _t) -> res;
        });
        expression.addLazyFunction("item_category", 1, (c, t, lv) -> {
            class_2290 item = NBTSerializableValue.parseItem(((LazyValue)lv.get(0)).evalValue((Context)c).getString());
            class_1761 ig = item.method_9785().method_7859();
            Value res = ig == null ? Value.NULL : new StringValue(ig.method_7751());
            return (_c, _t) -> res;
        });
        expression.addLazyFunction("recipe_data", -1, (c, t, lv) -> {
            List<class_1860<?>> recipes;
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() < 1) {
                throw new InternalExpressionException("'recipe_data' requires at least one argument");
            }
            String recipeName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            class_3956 type = class_3956.field_17545;
            if (lv.size() > 1) {
                String recipeType = ((LazyValue)lv.get(1)).evalValue((Context)c).getString();
                try {
                    type = (class_3956)class_2378.field_17597.method_10223(new class_2960(recipeType));
                }
                catch (class_151 ignored) {
                    throw new InternalExpressionException("Unknown crafting category: " + recipeType);
                }
            }
            try {
                recipes = ((RecipeManagerInterface)cc.s.method_9211().method_3772()).getAllMatching(type, new class_2960(recipeName));
            }
            catch (class_151 ignored) {
                return LazyValue.NULL;
            }
            if (recipes.isEmpty()) {
                return LazyValue.NULL;
            }
            ArrayList<Value> recipesOutput = new ArrayList<Value>();
            for (class_1860<?> recipe : recipes) {
                class_1799 result = recipe.method_8110();
                ArrayList<Value> ingredientValue = new ArrayList<Value>();
                recipe.method_8117().forEach(ingredient -> {
                    List<Collection<class_1799>> stacks = ((IngredientInterface)ingredient).getRecipeStacks();
                    if (stacks.isEmpty()) {
                        ingredientValue.add(Value.NULL);
                    } else {
                        ArrayList<Value> alternatives = new ArrayList<Value>();
                        stacks.forEach(col -> col.stream().map(ListValue::fromItemStack).forEach(alternatives::add));
                        ingredientValue.add(ListValue.wrap(alternatives));
                    }
                });
                ListValue recipeSpec = recipe instanceof class_1869 ? ListValue.of(new StringValue("shaped"), new NumericValue(((class_1869)recipe).method_8150()), new NumericValue(((class_1869)recipe).method_8158())) : (recipe instanceof class_1867 ? ListValue.of(new StringValue("shapeless")) : (recipe instanceof class_1874 ? ListValue.of(new StringValue("smelting"), new NumericValue(((class_1874)recipe).method_8167()), new NumericValue(((class_1874)recipe).method_8171())) : (recipe instanceof class_3972 ? ListValue.of(new StringValue("cutting")) : (recipe instanceof class_1852 ? ListValue.of(new StringValue("special")) : ListValue.of(new StringValue("custom"))))));
                recipesOutput.add(ListValue.of(ListValue.fromItemStack(result), ListValue.wrap(ingredientValue), recipeSpec));
            }
            ListValue ret = ListValue.wrap(recipesOutput);
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("crafting_remaining_item", 1, (c, t, lv) -> {
            class_1792 item;
            String itemStr = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            try {
                class_2960 id = new class_2960(itemStr);
                item = (class_1792)class_2378.field_11142.method_10223(id);
                if (item == class_1802.field_8162 && !id.method_12832().equalsIgnoreCase("air")) {
                    throw new class_151("boo");
                }
            }
            catch (class_151 ignored) {
                throw new InternalExpressionException("Incorrect item: " + itemStr);
            }
            if (!item.method_7857()) {
                return LazyValue.NULL;
            }
            StringValue ret = new StringValue(NBTSerializableValue.nameFromRegistryId(class_2378.field_11142.method_10221((Object)item.method_7858())));
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("inventory_size", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return (_c, _t) -> Value.NULL;
            }
            NumericValue res = new NumericValue(inventoryLocator.inventory.method_5439());
            return (_c, _t) -> res;
        });
        expression.addLazyFunction("inventory_has_items", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return (_c, _t) -> Value.NULL;
            }
            NumericValue res = new NumericValue(!inventoryLocator.inventory.method_5442());
            return (_c, _t) -> res;
        });
        expression.addLazyFunction("inventory_get", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return (_c, _t) -> Value.NULL;
            }
            if (lv.size() == inventoryLocator.offset) {
                ArrayList<Value> fullInventory = new ArrayList<Value>();
                int maxi = inventoryLocator.inventory.method_5439();
                for (int i = 0; i < maxi; ++i) {
                    fullInventory.add(ListValue.fromItemStack(inventoryLocator.inventory.method_5438(i)));
                }
                ListValue res = ListValue.wrap(fullInventory);
                return (_c, _t) -> res;
            }
            int slot = (int)NumericValue.asNumber(((LazyValue)lv.get(inventoryLocator.offset)).evalValue((Context)c)).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory)) == inventoryLocator.inventory.method_5439()) {
                return (_c, _t) -> Value.NULL;
            }
            Value res = ListValue.fromItemStack(inventoryLocator.inventory.method_5438(slot));
            return (_c, _t) -> res;
        });
        expression.addLazyFunction("inventory_set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return (_c, _t) -> Value.NULL;
            }
            if (lv.size() < inventoryLocator.offset + 2) {
                throw new InternalExpressionException("'inventory_set' requires at least slot number and new stack size, and optional new item");
            }
            int slot = (int)NumericValue.asNumber(((LazyValue)lv.get(inventoryLocator.offset + 0)).evalValue((Context)c)).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory)) == inventoryLocator.inventory.method_5439()) {
                return (_c, _t) -> Value.NULL;
            }
            int count = (int)NumericValue.asNumber(((LazyValue)lv.get(inventoryLocator.offset + 1)).evalValue((Context)c)).getLong();
            if (count == 0) {
                class_1799 removedStack = inventoryLocator.inventory.method_5441(slot);
                Inventories.syncPlayerInventory(inventoryLocator, slot);
                return (_c, _t) -> ListValue.fromItemStack(removedStack);
            }
            if (lv.size() < inventoryLocator.offset + 3) {
                class_1799 previousStack = inventoryLocator.inventory.method_5438(slot);
                class_1799 newStack = previousStack.method_7972();
                newStack.method_7939(count);
                inventoryLocator.inventory.method_5447(slot, newStack);
                Inventories.syncPlayerInventory(inventoryLocator, slot);
                return (_c, _t) -> ListValue.fromItemStack(previousStack);
            }
            Object nbt = null;
            if (lv.size() > inventoryLocator.offset + 3) {
                Value nbtValue = ((LazyValue)lv.get(inventoryLocator.offset + 3)).evalValue((Context)c);
                nbt = nbtValue instanceof NBTSerializableValue ? ((NBTSerializableValue)nbtValue).getCompoundTag() : (nbtValue instanceof NullValue ? null : new NBTSerializableValue(nbtValue.getString()).getCompoundTag());
            }
            class_2290 newitem = NBTSerializableValue.parseItem(((LazyValue)lv.get(inventoryLocator.offset + 2)).evalValue((Context)c).getString(), nbt);
            class_1799 previousStack = inventoryLocator.inventory.method_5438(slot);
            try {
                inventoryLocator.inventory.method_5447(slot, newitem.method_9781(count, false));
                Inventories.syncPlayerInventory(inventoryLocator, slot);
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException(e.getMessage());
            }
            return (_c, _t) -> ListValue.fromItemStack(previousStack);
        });
        expression.addLazyFunction("inventory_find", -1, (c, t, lv) -> {
            Value secondArg;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return (_c, _t) -> Value.NULL;
            }
            class_2290 itemArg = null;
            if (lv.size() > inventoryLocator.offset && !((secondArg = ((LazyValue)lv.get(inventoryLocator.offset + 0)).evalValue((Context)c)) instanceof NullValue)) {
                itemArg = NBTSerializableValue.parseItem(secondArg.getString());
            }
            int startIndex = 0;
            if (lv.size() > inventoryLocator.offset + 1) {
                startIndex = (int)NumericValue.asNumber(((LazyValue)lv.get(inventoryLocator.offset + 1)).evalValue((Context)c)).getLong();
            }
            int maxi = inventoryLocator.inventory.method_5439();
            for (int i = startIndex = NBTSerializableValue.validateSlot(startIndex, inventoryLocator.inventory); i < maxi; ++i) {
                class_1799 stack = inventoryLocator.inventory.method_5438(i);
                if ((itemArg != null || !stack.method_7960()) && (itemArg == null || !itemArg.method_9785().equals(stack.method_7909()))) continue;
                NumericValue res = new NumericValue(i);
                return (_c, _t) -> res;
            }
            return (_c, _t) -> Value.NULL;
        });
        expression.addLazyFunction("inventory_remove", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return (_c, _t) -> Value.NULL;
            }
            if (lv.size() <= inventoryLocator.offset) {
                throw new InternalExpressionException("'inventory_remove' requires at least an item to be removed");
            }
            class_2290 searchItem = NBTSerializableValue.parseItem(((LazyValue)lv.get(inventoryLocator.offset)).evalValue((Context)c).getString());
            int amount = 1;
            if (lv.size() > inventoryLocator.offset + 1) {
                amount = (int)NumericValue.asNumber(((LazyValue)lv.get(inventoryLocator.offset + 1)).evalValue((Context)c)).getLong();
            }
            if (amount == 1 && !inventoryLocator.inventory.method_18862((Set)Sets.newHashSet((Object[])new class_1792[]{searchItem.method_9785()})) || inventoryLocator.inventory.method_18861(searchItem.method_9785()) < amount) {
                return (_c, _t) -> Value.FALSE;
            }
            int maxi = inventoryLocator.inventory.method_5439();
            for (int i = 0; i < maxi; ++i) {
                class_1799 stack = inventoryLocator.inventory.method_5438(i);
                if (stack.method_7960() || !stack.method_7909().equals(searchItem.method_9785())) continue;
                int left = stack.method_7947() - amount;
                if (left > 0) {
                    stack.method_7939(left);
                    inventoryLocator.inventory.method_5447(i, stack);
                    Inventories.syncPlayerInventory(inventoryLocator, i);
                    return (_c, _t) -> Value.TRUE;
                }
                inventoryLocator.inventory.method_5441(i);
                Inventories.syncPlayerInventory(inventoryLocator, i);
                amount -= stack.method_7947();
            }
            if (amount > 0) {
                throw new InternalExpressionException("Something bad happened - cannot pull all items from inventory");
            }
            return (_c, _t) -> Value.TRUE;
        });
        expression.addLazyFunction("drop_item", -1, (c, t, lv) -> {
            class_1542 item;
            class_1799 droppedStack;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return (_c, _t) -> Value.NULL;
            }
            if (lv.size() == inventoryLocator.offset) {
                throw new InternalExpressionException("Slot number is required for inventory_drop");
            }
            int slot = (int)NumericValue.asNumber(((LazyValue)lv.get(inventoryLocator.offset)).evalValue((Context)c)).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory)) == inventoryLocator.inventory.method_5439()) {
                return (_c, _t) -> Value.NULL;
            }
            int amount = 0;
            if (lv.size() > inventoryLocator.offset + 1) {
                amount = (int)NumericValue.asNumber(((LazyValue)lv.get(inventoryLocator.offset + 1)).evalValue((Context)c)).getLong();
            }
            if (amount < 0) {
                throw new InternalExpressionException("Cannot throw negative number of items");
            }
            class_1799 stack = inventoryLocator.inventory.method_5438(slot);
            if (stack == null || stack.method_7960()) {
                return (_c, _t) -> Value.ZERO;
            }
            if (amount == 0) {
                amount = stack.method_7947();
            }
            if ((droppedStack = inventoryLocator.inventory.method_5434(slot, amount)).method_7960()) {
                return (_c, _t) -> Value.ZERO;
            }
            Object owner = inventoryLocator.owner;
            if (owner instanceof class_1657) {
                item = ((class_1657)owner).method_7329(droppedStack, false, true);
            } else if (owner instanceof class_1309) {
                class_1309 villager = (class_1309)owner;
                double double_1 = villager.method_23318() - (double)0.3f + (double)villager.method_5751();
                item = new class_1542(villager.field_6002, villager.method_23317(), double_1, villager.method_23321(), droppedStack);
                class_243 vec3d_1 = villager.method_5828(1.0f).method_1029().method_1021(0.3);
                item.method_18799(vec3d_1);
                item.method_6988();
                cc.s.method_9225().method_8649((class_1297)item);
            } else {
                class_243 point = class_243.method_24953((class_2382)inventoryLocator.position);
                item = new class_1542((class_1937)cc.s.method_9225(), point.field_1352, point.field_1351, point.field_1350, droppedStack);
                item.method_6988();
                cc.s.method_9225().method_8649((class_1297)item);
            }
            NumericValue res = new NumericValue(item.method_6983().method_7947());
            return (_c, _t) -> res;
        });
    }

    private static void syncPlayerInventory(NBTSerializableValue.InventoryLocator inventory, int int_1) {
        if (inventory.owner instanceof class_3222 && !inventory.isEnder) {
            class_3222 player = (class_3222)inventory.owner;
            player.field_13987.method_14364((class_2596)new class_2653(-2, int_1, inventory.inventory.method_5438(int_1)));
        }
    }
}

