/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptHost;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.argument.FunctionArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.EntityValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;

public class Entities {
    public static void apply(Expression expression) {
        expression.addLazyFunction("player", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                class_1297 callingEntity = ((CarpetContext)c).s.method_9228();
                if (callingEntity instanceof class_1657) {
                    EntityValue retval = new EntityValue(callingEntity);
                    return (_c, _t) -> retval;
                }
                class_243 pos = ((CarpetContext)c).s.method_9222();
                class_1657 closestPlayer = ((CarpetContext)c).s.method_9225().method_8604(pos.field_1352, pos.field_1351, pos.field_1350, -1.0, class_1301.field_6154);
                if (closestPlayer != null) {
                    EntityValue retval = new EntityValue((class_1297)closestPlayer);
                    return (_c, _t) -> retval;
                }
                return (_c, _t) -> Value.NULL;
            }
            String playerName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            Value retval = Value.NULL;
            if ("all".equalsIgnoreCase(playerName)) {
                retval = ListValue.wrap(((CarpetContext)c).s.method_9211().method_3760().method_14571().stream().map(EntityValue::new).collect(Collectors.toList()));
            } else if ("*".equalsIgnoreCase(playerName)) {
                retval = ListValue.wrap(((CarpetContext)c).s.method_9225().method_18456().stream().map(EntityValue::new).collect(Collectors.toList()));
            } else if ("survival".equalsIgnoreCase(playerName)) {
                retval = ListValue.wrap(((CarpetContext)c).s.method_9225().method_18766(p -> p.field_13974.method_14267()).stream().map(EntityValue::new).collect(Collectors.toList()));
            } else if ("creative".equalsIgnoreCase(playerName)) {
                retval = ListValue.wrap(((CarpetContext)c).s.method_9225().method_18766(class_1657::method_7337).stream().map(EntityValue::new).collect(Collectors.toList()));
            } else if ("spectating".equalsIgnoreCase(playerName)) {
                retval = ListValue.wrap(((CarpetContext)c).s.method_9225().method_18766(class_1657::method_7325).stream().map(EntityValue::new).collect(Collectors.toList()));
            } else if ("!spectating".equalsIgnoreCase(playerName)) {
                retval = ListValue.wrap(((CarpetContext)c).s.method_9225().method_18766(p -> !p.method_7325()).stream().map(EntityValue::new).collect(Collectors.toList()));
            } else {
                class_3222 player = ((CarpetContext)c).s.method_9211().method_3760().method_14566(playerName);
                if (player != null) {
                    retval = new EntityValue((class_1297)player);
                }
            }
            Value finalVar = retval;
            return (cc, tt) -> finalVar;
        });
        expression.addLazyFunction("spawn", -1, (c, t, lv) -> {
            class_2960 entityId;
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'spawn' function takes mob name, and position to spawn");
            }
            String entityString = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            try {
                entityId = class_2960.method_12835((StringReader)new StringReader(entityString));
                class_1299 type = class_2378.field_11145.method_17966(entityId).orElse(null);
                if (type == null || !type.method_5896()) {
                    return LazyValue.NULL;
                }
            }
            catch (CommandSyntaxException exception) {
                return LazyValue.NULL;
            }
            Vector3Argument position = Vector3Argument.findIn(cc, lv, 1);
            if (position.fromBlock) {
                position.vec = position.vec.method_1023(0.0, 0.5, 0.0);
            }
            class_2487 tag = new class_2487();
            boolean hasTag = false;
            if (lv.size() > position.offset) {
                Value nbt = ((LazyValue)lv.get(position.offset)).evalValue((Context)c);
                NBTSerializableValue v = nbt instanceof NBTSerializableValue ? (NBTSerializableValue)nbt : NBTSerializableValue.parseString(nbt.getString());
                hasTag = true;
                tag = v.getCompoundTag();
            }
            tag.method_10582("id", entityId.toString());
            class_243 vec3d = position.vec;
            class_3218 serverWorld = cc.s.method_9225();
            class_1297 entity_1 = class_1299.method_17842((class_2487)tag, (class_1937)serverWorld, entity_1x -> {
                entity_1x.method_5808(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, entity_1x.field_6031, entity_1x.field_5965);
                return !serverWorld.method_18768(entity_1x) ? null : entity_1x;
            });
            if (entity_1 == null) {
                return LazyValue.NULL;
            }
            if (!hasTag && entity_1 instanceof class_1308) {
                ((class_1308)entity_1).method_5943((class_5425)serverWorld, serverWorld.method_8404(entity_1.method_24515()), class_3730.field_16462, null, null);
            }
            EntityValue res = new EntityValue(entity_1);
            return (_c, _t) -> res;
        });
        expression.addLazyFunction("entity_id", 1, (c, t, lv) -> {
            Value who = ((LazyValue)lv.get(0)).evalValue((Context)c);
            class_1297 e = who instanceof NumericValue ? ((CarpetContext)c).s.method_9225().method_8469((int)((NumericValue)who).getLong()) : ((CarpetContext)c).s.method_9225().method_14190(UUID.fromString(who.getString()));
            if (e == null) {
                return LazyValue.NULL;
            }
            return (cc, tt) -> new EntityValue(e);
        });
        expression.addLazyFunction("entity_list", 1, (c, t, lv) -> {
            String who = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            EntityValue.EntityClassDescriptor eDesc = EntityValue.getEntityDescriptor(who);
            List entityList = ((CarpetContext)c).s.method_9225().method_18198(eDesc.directType, eDesc.filteringPredicate);
            ListValue retval = ListValue.wrap(entityList.stream().map(EntityValue::new).collect(Collectors.toList()));
            return (_c, _t) -> retval;
        });
        expression.addLazyFunction("entity_area", -1, (c, t, lv) -> {
            if (lv.size() < 3) {
                throw new InternalExpressionException("'entity_area' requires entity type, center and range arguments");
            }
            String who = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            CarpetContext cc = (CarpetContext)c;
            Vector3Argument centerLocator = Vector3Argument.findIn(cc, lv, 1);
            class_243 center = centerLocator.vec;
            if (centerLocator.fromBlock) {
                center.method_1031(0.5, 0.5, 0.5);
            }
            Vector3Argument rangeLocator = Vector3Argument.findIn(cc, lv, centerLocator.offset);
            if (rangeLocator.fromBlock) {
                throw new InternalExpressionException("Range of 'entity_area' cannot come from a block argument");
            }
            class_243 range = rangeLocator.vec;
            class_238 area = new class_238(center, center).method_1009(range.field_1352, range.field_1351, range.field_1350);
            EntityValue.EntityClassDescriptor eDesc = EntityValue.getEntityDescriptor(who);
            List entityList = ((CarpetContext)c).s.method_9225().method_18023(eDesc.directType, area, eDesc.filteringPredicate);
            ListValue retval = ListValue.wrap(entityList.stream().map(EntityValue::new).collect(Collectors.toList()));
            return (_c, _t) -> retval;
        });
        expression.addLazyFunction("entity_selector", -1, (c, t, lv) -> {
            String selector = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            ArrayList<EntityValue> retlist = new ArrayList<EntityValue>();
            for (class_1297 class_12972 : EntityValue.getEntitiesFromSelector(((CarpetContext)c).s, selector)) {
                retlist.add(new EntityValue(class_12972));
            }
            return (c_, t_) -> ListValue.wrap(retlist);
        });
        expression.addLazyFunction("query", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'query' takes entity as a first argument, and queried feature as a second");
            }
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to query should be an entity");
            }
            String what = ((LazyValue)lv.get(1)).evalValue((Context)c).getString();
            Value retval = lv.size() == 2 ? ((EntityValue)v).get(what, null) : (lv.size() == 3 ? ((EntityValue)v).get(what, ((LazyValue)lv.get(2)).evalValue((Context)c)) : ((EntityValue)v).get(what, ListValue.wrap(lv.subList(2, lv.size()).stream().map(vv -> vv.evalValue((Context)c)).collect(Collectors.toList()))));
            return (cc, tt) -> retval;
        });
        expression.addLazyFunction("modify", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'modify' takes entity as a first argument, and queried feature as a second");
            }
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to modify should be an entity");
            }
            String what = ((LazyValue)lv.get(1)).evalValue((Context)c).getString();
            if (lv.size() == 2) {
                ((EntityValue)v).set(what, null);
            } else if (lv.size() == 3) {
                ((EntityValue)v).set(what, ((LazyValue)lv.get(2)).evalValue((Context)c));
            } else {
                ((EntityValue)v).set(what, ListValue.wrap(lv.subList(2, lv.size()).stream().map(vv -> vv.evalValue((Context)c)).collect(Collectors.toList())));
            }
            return (cc, tt) -> v;
        });
        expression.addFunction("entity_types", lv -> {
            if (lv.size() > 1) {
                throw new InternalExpressionException("'entity_types' requires one or no arguments");
            }
            String desc = lv.size() == 1 ? ((Value)lv.get(0)).getString() : "*";
            return EntityValue.getEntityDescriptor((String)desc).listValue;
        });
        expression.addLazyFunction("entity_load_handler", -1, (c, t, lv) -> {
            if (c.host.isPerUser()) {
                throw new InternalExpressionException("'entity_load_handler' can only be called in apps with global scope");
            }
            if (lv.size() < 2) {
                throw new InternalExpressionException("'entity_load_handler' required the entity type, and a function to call");
            }
            Value entityValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
            List<String> descriptors = entityValue instanceof ListValue ? ((ListValue)entityValue).getItems().stream().map(Value::getString).collect(Collectors.toList()) : Collections.singletonList(entityValue.getString());
            HashSet types = new HashSet();
            descriptors.forEach(s -> types.addAll(EntityValue.getEntityDescriptor((String)s).typeList));
            FunctionArgument funArg = FunctionArgument.findIn(c, expression.module, lv, 1, false, true, false);
            CarpetEventServer events = ((CarpetScriptHost)c.host).getScriptServer().events;
            if (funArg.function == null) {
                types.forEach(et -> events.removeEventDirectly(CarpetEventServer.Event.getLoadEvent((class_1299<? extends class_1297>)et), c.host));
            } else {
                types.forEach(et -> events.addEventDirectly(CarpetEventServer.Event.getLoadEvent((class_1299<? extends class_1297>)et), c.host, funArg.function, FunctionValue.resolveArgs(funArg.args, c, t)));
            }
            NumericValue ret = new NumericValue(types.size());
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("entity_event", -1, (c, t, lv) -> {
            if (lv.size() < 3) {
                throw new InternalExpressionException("'entity_event' requires at least 3 arguments, entity, event to be handled, and function name, with optional arguments");
            }
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to entity_event should be an entity");
            }
            String what = ((LazyValue)lv.get(1)).evalValue((Context)c).getString();
            FunctionArgument funArg = FunctionArgument.findIn(c, expression.module, lv, 2, false, true, false);
            ((EntityValue)v).setEvent((CarpetContext)c, what, funArg.function, FunctionValue.resolveArgs(funArg.args, c, t));
            return LazyValue.NULL;
        });
    }
}

