/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.InternalExpressionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Tokenizer
implements Iterator<Token> {
    private static final char decimalSeparator = '.';
    private static final char minusSign = '-';
    private int pos = 0;
    private int lineno = 0;
    private int linepos = 0;
    private boolean comments;
    private boolean newLinesMarkers;
    private String input;
    private Token previousToken;
    private Expression expression;
    private Context context;

    Tokenizer(Context c, Expression expr, String input, boolean allowComments, boolean allowNewLineMakers) {
        this.input = input;
        this.expression = expr;
        this.context = c;
        this.comments = allowComments;
        this.newLinesMarkers = allowNewLineMakers;
    }

    public List<Token> postProcess() {
        Iterable iterable = () -> this;
        List originalTokens = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
        ArrayList<Token> cleanedTokens = new ArrayList<Token>();
        Token last = null;
        while (originalTokens.size() > 0) {
            Token current = (Token)originalTokens.remove(originalTokens.size() - 1);
            if (current.type == Token.TokenType.MARKER && current.surface.startsWith("//")) continue;
            if (!Tokenizer.isSemicolon(current) || last != null && last.type != Token.TokenType.CLOSE_PAREN && last.type != Token.TokenType.COMMA && !Tokenizer.isSemicolon(last)) {
                if (Tokenizer.isSemicolon(current)) {
                    current.surface = ";";
                    current.type = Token.TokenType.OPERATOR;
                }
                if (current.type == Token.TokenType.MARKER) {
                    if ("{".equals(current.surface)) {
                        cleanedTokens.add(current.morphedInto(Token.TokenType.OPEN_PAREN, "("));
                        current.morph(Token.TokenType.FUNCTION, "m");
                    } else if ("[".equals(current.surface)) {
                        cleanedTokens.add(current.morphedInto(Token.TokenType.OPEN_PAREN, "("));
                        current.morph(Token.TokenType.FUNCTION, "l");
                    } else if ("}".equals(current.surface) || "]".equals(current.surface)) {
                        current.morph(Token.TokenType.CLOSE_PAREN, ")");
                    }
                }
                cleanedTokens.add(current);
            }
            if (current.type == Token.TokenType.MARKER && current.surface.equals("$")) continue;
            last = current;
        }
        Collections.reverse(cleanedTokens);
        return cleanedTokens;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.input.length();
    }

    private char peekNextChar() {
        return this.pos < this.input.length() - 1 ? this.input.charAt(this.pos + 1) : (char)'\u0000';
    }

    private boolean isHexDigit(char ch) {
        return ch == 'x' || ch == 'X' || ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private static boolean isSemicolon(Token tok) {
        return tok.type == Token.TokenType.OPERATOR && tok.surface.equals(";") || tok.type == Token.TokenType.UNARY_OPERATOR && tok.surface.equals(";u");
    }

    public static List<Token> simplepass(String input) {
        Tokenizer tok = new Tokenizer(null, null, input, false, false);
        ArrayList<Token> res = new ArrayList<Token>();
        while (tok.hasNext()) {
            res.add(tok.next());
        }
        return res;
    }

    @Override
    public Token next() {
        Token token = new Token();
        if (this.pos >= this.input.length()) {
            this.previousToken = null;
            return null;
        }
        char ch = this.input.charAt(this.pos);
        while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
            ++this.linepos;
            if (ch == '\n') {
                ++this.lineno;
                this.linepos = 0;
            }
            ch = this.input.charAt(++this.pos);
        }
        token.pos = this.pos++;
        token.lineno = this.lineno;
        token.linepos = this.linepos++;
        boolean isHex = false;
        if (Character.isDigit(ch)) {
            if (ch == '0' && (this.peekNextChar() == 'x' || this.peekNextChar() == 'X')) {
                isHex = true;
            }
            while (isHex && this.isHexDigit(ch) || (Character.isDigit(ch) || ch == '.' || ch == 'e' || ch == 'E' || ch == '-' && token.length() > 0 && ('e' == token.charAt(token.length() - 1) || 'E' == token.charAt(token.length() - 1)) || ch == '+' && token.length() > 0 && ('e' == token.charAt(token.length() - 1) || 'E' == token.charAt(token.length() - 1))) && this.pos < this.input.length()) {
                token.append(this.input.charAt(this.pos++));
                ++this.linepos;
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            }
            token.type = isHex ? Token.TokenType.HEX_LITERAL : Token.TokenType.LITERAL;
        } else if (ch == '\'') {
            token.type = Token.TokenType.STRINGPARAM;
            if (this.pos == this.input.length() && this.expression != null && this.context != null) {
                throw new ExpressionException(this.context, this.expression, token, "Program truncated");
            }
            ch = this.input.charAt(this.pos);
            while (ch != '\'') {
                if (ch == '\\') {
                    char nextChar = this.peekNextChar();
                    if (nextChar == 'n') {
                        token.append('\n');
                    } else if (nextChar == 't') {
                        token.append('\t');
                    } else {
                        if (nextChar == 'r') {
                            throw new ExpressionException(this.context, this.expression, token, "Carriage return character is not supported");
                        }
                        if (nextChar == '\\' || nextChar == '\'') {
                            token.append(nextChar);
                        } else {
                            --this.pos;
                            --this.linepos;
                        }
                    }
                    this.pos += 2;
                    this.linepos += 2;
                    if (this.pos == this.input.length() && this.expression != null && this.context != null) {
                        throw new ExpressionException(this.context, this.expression, token, "Program truncated");
                    }
                } else {
                    token.append(this.input.charAt(this.pos++));
                    ++this.linepos;
                    if (ch == '\n') {
                        ++this.lineno;
                        this.linepos = 0;
                    }
                    if (this.pos == this.input.length() && this.expression != null && this.context != null) {
                        throw new ExpressionException(this.context, this.expression, token, "Program truncated");
                    }
                }
                ch = this.input.charAt(this.pos);
            }
            ++this.pos;
            ++this.linepos;
        } else if (Character.isLetter(ch) || "_".indexOf(ch) >= 0) {
            while ((Character.isLetter(ch) || Character.isDigit(ch) || "_".indexOf(ch) >= 0 || token.length() == 0 && "_".indexOf(ch) >= 0) && this.pos < this.input.length()) {
                token.append(this.input.charAt(this.pos++));
                ++this.linepos;
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            }
            if (Character.isWhitespace(ch)) {
                while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
                    ch = this.input.charAt(this.pos++);
                    ++this.linepos;
                    if (ch != '\n') continue;
                    ++this.lineno;
                    this.linepos = 0;
                }
                --this.pos;
                --this.linepos;
            }
            token.type = ch == '(' ? Token.TokenType.FUNCTION : Token.TokenType.VARIABLE;
        } else if (ch == '(' || ch == ')' || ch == ',' || ch == '{' || ch == '}' || ch == '[' || ch == ']') {
            token.type = ch == '(' ? Token.TokenType.OPEN_PAREN : (ch == ')' ? Token.TokenType.CLOSE_PAREN : (ch == ',' ? Token.TokenType.COMMA : Token.TokenType.MARKER));
            token.append(ch);
            ++this.pos;
            ++this.linepos;
            if (!(this.expression == null || this.context == null || this.previousToken == null || this.previousToken.type != Token.TokenType.OPERATOR || ch != ')' && ch != ',' && ch != ']' && ch != '}' || this.previousToken.surface.equalsIgnoreCase(";"))) {
                throw new ExpressionException(this.context, this.expression, this.previousToken, "Can't have operator " + this.previousToken.surface + " at the end of a subexpression");
            }
        } else {
            String greedyMatch = "";
            int initialPos = this.pos;
            int initialLinePos = this.linepos;
            ch = this.input.charAt(this.pos);
            int validOperatorSeenUntil = -1;
            while (!(Character.isLetter(ch) || Character.isDigit(ch) || "_".indexOf(ch) >= 0 || Character.isWhitespace(ch) || ch == '(' || ch == ')' || ch == ',' || this.pos >= this.input.length())) {
                greedyMatch = greedyMatch + ch;
                if (this.comments && "//".equals(greedyMatch)) {
                    while (ch != '\n' && this.pos < this.input.length()) {
                        ch = this.input.charAt(this.pos++);
                        ++this.linepos;
                        greedyMatch = greedyMatch + ch;
                    }
                    if (ch == '\n') {
                        ++this.lineno;
                        this.linepos = 0;
                    }
                    token.append(greedyMatch);
                    token.type = Token.TokenType.MARKER;
                    return token;
                }
                ++this.pos;
                ++this.linepos;
                if (Expression.none.isAnOperator(greedyMatch)) {
                    validOperatorSeenUntil = this.pos;
                }
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            }
            if (this.newLinesMarkers && "$".equals(greedyMatch)) {
                ++this.lineno;
                this.linepos = 0;
                token.type = Token.TokenType.MARKER;
                token.append('$');
                return token;
            }
            if (validOperatorSeenUntil != -1) {
                token.append(this.input.substring(initialPos, validOperatorSeenUntil));
                this.pos = validOperatorSeenUntil;
                this.linepos = initialLinePos + validOperatorSeenUntil - initialPos;
            } else {
                token.append(greedyMatch);
            }
            if (this.previousToken == null || this.previousToken.type == Token.TokenType.OPERATOR || this.previousToken.type == Token.TokenType.OPEN_PAREN || this.previousToken.type == Token.TokenType.COMMA || this.previousToken.type == Token.TokenType.MARKER && (this.previousToken.surface.equals("{") || this.previousToken.surface.equals("["))) {
                token.surface = token.surface + "u";
                token.type = Token.TokenType.UNARY_OPERATOR;
            } else {
                token.type = Token.TokenType.OPERATOR;
            }
        }
        if (this.expression != null && this.context != null && this.previousToken != null && (token.type == Token.TokenType.LITERAL || token.type == Token.TokenType.HEX_LITERAL || token.type == Token.TokenType.VARIABLE || token.type == Token.TokenType.STRINGPARAM || token.type == Token.TokenType.MARKER && (this.previousToken.surface.equalsIgnoreCase("{") || this.previousToken.surface.equalsIgnoreCase("[")) || token.type == Token.TokenType.FUNCTION) && (this.previousToken.type == Token.TokenType.VARIABLE || this.previousToken.type == Token.TokenType.FUNCTION || this.previousToken.type == Token.TokenType.LITERAL || this.previousToken.type == Token.TokenType.CLOSE_PAREN || this.previousToken.type == Token.TokenType.MARKER && (this.previousToken.surface.equalsIgnoreCase("}") || this.previousToken.surface.equalsIgnoreCase("]")) || this.previousToken.type == Token.TokenType.HEX_LITERAL || this.previousToken.type == Token.TokenType.STRINGPARAM)) {
            throw new ExpressionException(this.context, this.expression, this.previousToken, "'" + token.surface + "' is not allowed after '" + this.previousToken.surface + "'");
        }
        this.previousToken = token;
        return this.previousToken;
    }

    @Override
    public void remove() {
        throw new InternalExpressionException("remove() not supported");
    }

    public static class Token {
        public String surface = "";
        public TokenType type;
        public int pos;
        public int linepos;
        public int lineno;

        public Token morphedInto(TokenType newType, String newSurface) {
            Token created = new Token();
            created.surface = newSurface;
            created.type = newType;
            created.pos = this.pos;
            created.linepos = this.linepos;
            created.lineno = this.lineno;
            return created;
        }

        public void morph(TokenType type, String s) {
            this.type = type;
            this.surface = s;
        }

        public void append(char c) {
            this.surface = this.surface + c;
        }

        public void append(String s) {
            this.surface = this.surface + s;
        }

        public char charAt(int pos) {
            return this.surface.charAt(pos);
        }

        public int length() {
            return this.surface.length();
        }

        public String toString() {
            return this.surface;
        }

        static enum TokenType {
            VARIABLE,
            FUNCTION,
            LITERAL,
            OPERATOR,
            UNARY_OPERATOR,
            OPEN_PAREN,
            COMMA,
            CLOSE_PAREN,
            HEX_LITERAL,
            STRINGPARAM,
            MARKER;

        }
    }
}

