/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.helpers.TickSpeed;
import carpet.network.CarpetClient;
import carpet.settings.ParsedRule;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_746;

public class ClientNetworkHandler {
    private static Map<String, BiConsumer<class_746, class_2520>> dataHandlers = new HashMap<String, BiConsumer<class_746, class_2520>>(){
        {
            this.put("Rules", (p, t) -> {
                class_2487 ruleset = (class_2487)t;
                for (String ruleName : ruleset.method_10541()) {
                    ParsedRule<?> rule = CarpetServer.settingsManager.getRule(ruleName);
                    if (rule == null) {
                        CarpetSettings.LOG.error("Received unknown rule: " + ruleName);
                        continue;
                    }
                    class_2487 ruleNBT = (class_2487)ruleset.method_10580(ruleName);
                    String value = ruleNBT.method_10558("Value");
                    rule.set(null, value);
                }
            });
            this.put("TickRate", (p, t) -> TickSpeed.tickrate(((class_2514)t).method_10700(), false));
            this.put("scShape", (p, t) -> {
                if (CarpetClient.shapes != null) {
                    CarpetClient.shapes.addShape((class_2487)t);
                }
            });
            this.put("scShapes", (p, t) -> {
                if (CarpetClient.shapes != null) {
                    CarpetClient.shapes.addShapes((class_2499)t);
                }
            });
            this.put("clientCommand", (p, t) -> CarpetClient.onClientCommand(t));
        }
    };

    public static void handleData(class_2540 data, class_746 player) {
        if (data != null) {
            int id = data.method_10816();
            if (id == 69) {
                ClientNetworkHandler.onHi(data);
            }
            if (id == 1) {
                ClientNetworkHandler.onSyncData(data, player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onHi(class_2540 data) {
        Object object = CarpetClient.sync;
        synchronized (object) {
            CarpetClient.setCarpet();
            CarpetClient.serverCarpetVersion = data.method_10800(64);
            if ("1.4.16+v201105".equals(CarpetClient.serverCarpetVersion)) {
                CarpetSettings.LOG.info("Joined carpet server with matching carpet version");
            } else {
                CarpetSettings.LOG.warn("Joined carpet server with another carpet version: " + CarpetClient.serverCarpetVersion);
            }
            if (CarpetClient.getPlayer() != null) {
                ClientNetworkHandler.respondHello();
            }
        }
    }

    public static void respondHello() {
        CarpetClient.getPlayer().field_3944.method_2883((class_2596)new class_2817(CarpetClient.CARPET_CHANNEL, new class_2540(Unpooled.buffer()).method_10804(420).method_10814("1.4.16+v201105")));
    }

    private static void onSyncData(class_2540 data, class_746 player) {
        class_2487 compound = data.method_10798();
        if (compound == null) {
            return;
        }
        for (String key : compound.method_10541()) {
            if (dataHandlers.containsKey(key)) {
                dataHandlers.get(key).accept(player, compound.method_10580(key));
                continue;
            }
            CarpetSettings.LOG.error("Unknown carpet data: " + key);
        }
    }

    public static void clientCommand(String command) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", command);
        tag.method_10582("command", command);
        class_2487 outer = new class_2487();
        outer.method_10566("clientCommand", (class_2520)tag);
        CarpetClient.getPlayer().field_3944.method_2883((class_2596)new class_2817(CarpetClient.CARPET_CHANNEL, new class_2540(Unpooled.buffer()).method_10804(1).method_10794(outer)));
    }
}

