/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.transfer.RecipeTransferErrorInternal;
import mezz.jei.util.ItemStackMatchable;
import mezz.jei.util.MatchingIterable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecipeTransferUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RecipeTransferUtil() {
    }

    @Nullable
    public static IRecipeTransferError getTransferRecipeError(RecipeTransferManager recipeTransferManager, Container container, RecipeLayout<?> recipeLayout, PlayerEntity player) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, false, false);
    }

    public static boolean transferRecipe(RecipeTransferManager recipeTransferManager, Container container, RecipeLayout<?> recipeLayout, PlayerEntity player, boolean maxTransfer) {
        IRecipeTransferError error = RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, maxTransfer, true);
        return RecipeTransferUtil.allowsTransfer(error);
    }

    @Nullable
    private static <T extends Container> IRecipeTransferError transferRecipe(RecipeTransferManager recipeTransferManager, T container, RecipeLayout<?> recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime == null) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        IRecipeTransferHandler<T> transferHandler = recipeTransferManager.getRecipeTransferHandler(container, recipeLayout.getRecipeCategory());
        if (transferHandler == null) {
            if (doTransfer) {
                LOGGER.error("No Recipe Transfer handler for container {}", container.getClass());
            }
            return RecipeTransferErrorInternal.INSTANCE;
        }
        return transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeLayout, player, maxTransfer, doTransfer);
    }

    public static boolean allowsTransfer(@Nullable IRecipeTransferError error) {
        return error == null || error.getType() == IRecipeTransferError.Type.COSMETIC;
    }

    public static MatchingItemsResult getMatchingItems(IStackHelper stackhelper, Map<Integer, ItemStack> availableItemStacks, Map<Integer, ? extends IGuiIngredient<ItemStack>> ingredientsMap) {
        MatchingItemsResult matchingItemResult = new MatchingItemsResult();
        int recipeSlotNumber = -1;
        TreeSet<Integer> keys = new TreeSet<Integer>(ingredientsMap.keySet());
        for (Integer key : keys) {
            IGuiIngredient<ItemStack> ingredient = ingredientsMap.get(key);
            if (!ingredient.isInput()) continue;
            ++recipeSlotNumber;
            List<ItemStack> requiredStacks = ingredient.getAllIngredients();
            if (requiredStacks.isEmpty()) continue;
            Integer matching = RecipeTransferUtil.containsAnyStackIndexed(stackhelper, availableItemStacks, requiredStacks);
            if (matching == null) {
                matchingItemResult.missingItems.add(key);
                continue;
            }
            ItemStack matchingStack = availableItemStacks.get(matching);
            matchingStack.func_190918_g(1);
            if (matchingStack.func_190916_E() == 0) {
                availableItemStacks.remove(matching);
            }
            matchingItemResult.matchingItems.put(recipeSlotNumber, matching);
        }
        return matchingItemResult;
    }

    @Nullable
    public static Integer containsAnyStackIndexed(IStackHelper stackhelper, Map<Integer, ItemStack> stacks, Iterable<ItemStack> contains) {
        MatchingIndexed matchingStacks = new MatchingIndexed(stacks);
        MatchingIterable matchingContains = new MatchingIterable(contains);
        return RecipeTransferUtil.containsStackMatchable(stackhelper, matchingStacks, matchingContains);
    }

    @Nullable
    public static <R, T> R containsStackMatchable(IStackHelper stackhelper, Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<T>> contains) {
        for (ItemStackMatchable<T> containStack : contains) {
            R matchingStack = RecipeTransferUtil.containsStack(stackhelper, stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public static <R> R containsStack(IStackHelper stackHelper, Iterable<ItemStackMatchable<R>> stacks, ItemStackMatchable<?> contains) {
        for (ItemStackMatchable<R> stack : stacks) {
            if (!stackHelper.isEquivalent(contains.getStack(), stack.getStack(), UidContext.Recipe)) continue;
            return stack.getResult();
        }
        return null;
    }

    private static class MatchingIndexed
    implements Iterable<ItemStackMatchable<Integer>> {
        private final Map<Integer, ItemStack> map;

        public MatchingIndexed(Map<Integer, ItemStack> map) {
            this.map = map;
        }

        @Override
        public Iterator<ItemStackMatchable<Integer>> iterator() {
            return new MatchingIterable.DelegateIterator<Map.Entry<Integer, ItemStack>, ItemStackMatchable<Integer>>(this.map.entrySet().iterator()){

                @Override
                public ItemStackMatchable<Integer> next() {
                    final Map.Entry entry = (Map.Entry)this.delegate.next();
                    return new ItemStackMatchable<Integer>(){

                        @Override
                        public ItemStack getStack() {
                            return (ItemStack)entry.getValue();
                        }

                        @Override
                        public Integer getResult() {
                            return (Integer)entry.getKey();
                        }
                    };
                }
            };
        }
    }

    public static class MatchingItemsResult {
        public final Map<Integer, Integer> matchingItems = new HashMap<Integer, Integer>();
        public final List<Integer> missingItems = new ArrayList<Integer>();
    }
}

