/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.util.Translator;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public final class IngredientInformation {
    private IngredientInformation() {
    }

    public static <T> String getDisplayName(T ingredient, IIngredientHelper<T> ingredientHelper) {
        String displayName = ingredientHelper.getDisplayName(ingredient);
        return IngredientInformation.removeChatFormatting(displayName);
    }

    public static <T> List<String> getTooltipStrings(T ingredient, IIngredientRenderer<T> ingredientRenderer, Set<String> toRemove, IIngredientFilterConfig config) {
        ITooltipFlag.TooltipFlags tooltipFlag = config.getSearchAdvancedTooltips() ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        List<ITextComponent> tooltip = ingredientRenderer.getTooltip(ingredient, (ITooltipFlag)tooltipFlag);
        ArrayList<String> cleanTooltip = new ArrayList<String>(tooltip.size());
        for (ITextComponent lineComponent : tooltip) {
            String line = lineComponent.getString();
            line = IngredientInformation.removeChatFormatting(line);
            line = Translator.toLowercaseWithLocale(line);
            for (String excludeWord : toRemove) {
                line = line.replace(excludeWord, "");
            }
            if (StringUtils.func_151246_b((String)line)) continue;
            cleanTooltip.add(line);
        }
        return cleanTooltip;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = TextFormatting.func_110646_a((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    public static <V> Collection<String> getColorStrings(V ingredient, IIngredientHelper<V> ingredientHelper) {
        Iterable<Integer> colors = ingredientHelper.getColors(ingredient);
        ColorNamer colorNamer = Internal.getColorNamer();
        return colorNamer.getColorNames(colors, true);
    }

    public static <V> List<String> getUniqueIdsWithWildcard(IIngredientHelper<V> ingredientHelper, V ingredient, UidContext context) {
        String uidWild;
        String uid = ingredientHelper.getUniqueId(ingredient, context);
        if (uid.equals(uidWild = ingredientHelper.getWildcardId(ingredient))) {
            return Collections.singletonList(uid);
        }
        return Arrays.asList(uid, uidWild);
    }
}

