"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseSubscriptionMarble = void 0;
const SubscriptionLog_1 = require("rxjs/internal/testing/SubscriptionLog");
const ObservableMarbleToken_1 = require("./ObservableMarbleToken");
const tokenParseReducer_1 = require("./tokenParseReducer");
const parseSubscriptionMarble = (marble, frameTimeFactor = 1, maxFrame = 1000) => {
    if (!marble) {
        return new SubscriptionLog_1.SubscriptionLog(Number.POSITIVE_INFINITY);
    }
    const marbleTokenArray = Array.from(marble).filter(token => token !== ObservableMarbleToken_1.ObservableMarbleToken.NOOP);
    const value = marbleTokenArray.reduce(tokenParseReducer_1.subscriptionTokenParseReducer(frameTimeFactor, maxFrame), {
        currentTimeFrame: 0,
        subscriptionFrame: Number.POSITIVE_INFINITY,
        unsubscriptionFrame: Number.POSITIVE_INFINITY,
        simultaneousGrouped: false,
        expandingTokenCount: 0,
        expandingValue: []
    });
    return value.unsubscriptionFrame === Number.POSITIVE_INFINITY
        ? new SubscriptionLog_1.SubscriptionLog(value.subscriptionFrame)
        : new SubscriptionLog_1.SubscriptionLog(value.subscriptionFrame, value.unsubscriptionFrame);
};
exports.parseSubscriptionMarble = parseSubscriptionMarble;
//# sourceMappingURL=parseSubscriptionMarble.js.map