import { MichelsonV1Expression, ScriptResponse } from '@taquito/rpc';
import { BigMapKeyType, Semantic } from '../tokens/token';
import { RpcTransaction } from './model';
declare const schemaTypeSymbol: unique symbol;
/**
 * @warn Our current smart contract abstraction feature is currently in preview. It's API is not final, and it may not cover every use case (yet). We will greatly appreciate any feedback on this feature.
 */
export declare class Schema {
    private root;
    [schemaTypeSymbol]: boolean;
    static isSchema(obj: any): obj is Schema;
    private bigMap?;
    static fromRPCResponse(val: {
        script: ScriptResponse;
    }): Schema;
    private isExpressionExtended;
    constructor(val: MichelsonV1Expression);
    private removeTopLevelAnnotation;
    Execute(val: any, semantics?: Semantic): any;
    Typecheck(val: any): boolean;
    ExecuteOnBigMapDiff(diff: any[], semantics?: Semantic): any;
    ExecuteOnBigMapValue(key: any, semantics?: Semantic): any;
    EncodeBigMapKey(key: BigMapKeyType): {
        key: {
            [key: string]: string | object[];
        };
        type: {
            prim: string;
            args?: object[] | undefined;
        };
    };
    Encode(_value?: any): any;
    ExtractSchema(): any;
    /**
     * @deprecated
     */
    ComputeState(tx: RpcTransaction[], state: any): any;
    /**
     * @description Look up in top-level pairs of the storage to find a value matching the specified type
     *
     * @returns The first value found that match the type or `undefined` if no value is found
     *
     * @param storage storage to parse to find the value
     * @param valueType type of value to look for
     *
     */
    FindFirstInTopLevelPair<T extends MichelsonV1Expression>(storage: any, valueType: any): T | undefined;
    private findValue;
}
export {};
