export declare class ScanError extends Error {
    src: string;
    idx: number;
    constructor(src: string, idx: number, message?: string);
}
export declare enum Literal {
    Comment = 0,
    Number = 1,
    String = 2,
    Bytes = 3,
    Ident = 4
}
export declare type TokenType = "(" | ")" | "{" | "}" | ";" | Literal;
export interface Token {
    t: TokenType;
    v: string;
    first: number;
    last: number;
}
export declare function scan(src: string, scanComments?: boolean): Generator<Token, void>;
