"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.emitMicheline = void 0;
var micheline_1 = require("./micheline");
var Formatter = /** @class */ (function () {
    function Formatter(opt, lev) {
        if (lev === void 0) { lev = 0; }
        this.opt = opt;
        this.lev = lev;
    }
    Formatter.prototype.indent = function (n) {
        var _a;
        if (n === void 0) { n = 0; }
        var ret = "";
        if (((_a = this.opt) === null || _a === void 0 ? void 0 : _a.indent) !== undefined) {
            for (var i = this.lev + n; i > 0; i--) {
                ret += this.opt.indent;
            }
        }
        return ret;
    };
    Object.defineProperty(Formatter.prototype, "lf", {
        get: function () {
            var _a;
            return ((_a = this.opt) === null || _a === void 0 ? void 0 : _a.newline) || "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Formatter.prototype, "lfsp", {
        get: function () {
            var _a;
            return ((_a = this.opt) === null || _a === void 0 ? void 0 : _a.newline) || " ";
        },
        enumerable: false,
        configurable: true
    });
    Formatter.prototype.down = function (n) {
        return new Formatter(this.opt, this.lev + n);
    };
    return Formatter;
}());
function hasArgs(node) {
    return ("prim" in node) &&
        ((node.annots !== undefined && node.annots.length !== 0) ||
            (node.args !== undefined && node.args.length !== 0));
}
function isMultiline(node) {
    var e_1, _a;
    if (node.args !== undefined) {
        try {
            for (var _b = __values(node.args), _c = _b.next(); !_c.done; _c = _b.next()) {
                var a = _c.value;
                if (Array.isArray(a) || hasArgs(a)) {
                    return true;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    return false;
}
function emitExpr(node, f, foldMacros) {
    var e_2, _a, e_3, _b;
    var _c;
    var macro = (_c = node[micheline_1.sourceReference]) === null || _c === void 0 ? void 0 : _c.macro;
    if (foldMacros && macro) {
        return emitExpr(macro, f, foldMacros);
    }
    if (Array.isArray(node)) {
        return emitSeq(node, f, foldMacros);
    }
    else if ("string" in node) {
        return JSON.stringify(node.string);
    }
    else if ("int" in node) {
        return node.int;
    }
    else if ("bytes" in node) {
        return "0x" + node.bytes;
    }
    else {
        if ((node.annots === undefined || node.annots.length === 0) &&
            (node.args === undefined || node.args.length === 0)) {
            return node.prim;
        }
        var ret = "(" + node.prim;
        if (node.annots !== undefined) {
            try {
                for (var _d = __values(node.annots), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var a = _e.value;
                    ret += " " + a;
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        if (node.args !== undefined) {
            var multiline = isMultiline(node);
            try {
                for (var _f = __values(node.args), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var a = _g.value;
                    if (multiline) {
                        ret += f.lfsp + f.indent(1) + emitExpr(a, f.down(1), foldMacros);
                    }
                    else {
                        ret += " " + emitExpr(a, f, foldMacros);
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
        return ret + ")";
    }
}
function emitSeq(node, f, foldMacros) {
    var e_4, _a, e_5, _b, e_6, _c;
    var ret = "{" + f.lf;
    var i = node.length;
    try {
        for (var node_1 = __values(node), node_1_1 = node_1.next(); !node_1_1.done; node_1_1 = node_1.next()) {
            var el = node_1_1.value;
            ret += f.indent(1);
            if ("prim" in el) {
                ret += el.prim;
                if (el.annots !== undefined) {
                    try {
                        for (var _d = (e_5 = void 0, __values(el.annots)), _e = _d.next(); !_e.done; _e = _d.next()) {
                            var a = _e.value;
                            ret += " " + a;
                        }
                    }
                    catch (e_5_1) { e_5 = { error: e_5_1 }; }
                    finally {
                        try {
                            if (_e && !_e.done && (_b = _d.return)) _b.call(_d);
                        }
                        finally { if (e_5) throw e_5.error; }
                    }
                }
                if (el.args !== undefined) {
                    var multiline = isMultiline(el);
                    try {
                        for (var _f = (e_6 = void 0, __values(el.args)), _g = _f.next(); !_g.done; _g = _f.next()) {
                            var a = _g.value;
                            if (multiline) {
                                ret += f.lfsp + f.indent(2) + emitExpr(a, f.down(2), foldMacros);
                            }
                            else {
                                ret += " " + emitExpr(a, f, foldMacros);
                            }
                        }
                    }
                    catch (e_6_1) { e_6 = { error: e_6_1 }; }
                    finally {
                        try {
                            if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
                        }
                        finally { if (e_6) throw e_6.error; }
                    }
                }
            }
            else {
                ret += emitExpr(el, f.down(1), foldMacros);
            }
            ret += (i > 1 ? ";" + f.lfsp : f.lf);
            i--;
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (node_1_1 && !node_1_1.done && (_a = node_1.return)) _a.call(node_1);
        }
        finally { if (e_4) throw e_4.error; }
    }
    return ret + f.indent() + "}";
}
/**
 * Formats Micheline expression
 * @param expr An AST node
 * @param opt Options
 */
function emitMicheline(expr, opt, foldMacros) {
    if (foldMacros === void 0) { foldMacros = false; }
    // tslint:disable-next-line: strict-type-predicates
    if (typeof expr !== "object") {
        throw new TypeError("object type was expected, got " + typeof expr + " instead");
    }
    return emitExpr(expr, new Formatter(opt), foldMacros);
}
exports.emitMicheline = emitMicheline;
//# sourceMappingURL=micheline-emitter.js.map