'use strict';

angular.module('ajenti.check_certificates', ['core']);


'use strict';

angular.module('ajenti.check_certificates').config(function ($routeProvider) {
    $routeProvider.when('/view/check_cert/certificates', {
        templateUrl: '/check_certificates:resources/partial/index.html',
        controller: 'CertIndexController'
    });
});


// Generated by CoffeeScript 1.7.1
(function() {
  angular.module('ajenti.check_certificates').controller('CertIndexController', function($scope, $http, $interval, $timeout, notify, pageTitle, messagebox, gettext, config) {
    pageTitle.set(gettext('Check certificates'));
    $scope.status = [];
    $scope.addNewVisible = false;
    config.getUserConfig().then(function(userConfig) {
      var url, _i, _len, _ref, _results;
      $scope.userConfig = userConfig;
      $scope.userConfig.certificates = $scope.userConfig.certificates || {
        'domain': []
      };
      _ref = $scope.userConfig.certificates.domain;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        url = _ref[_i];
        _results.push($http.post('/api/check_cert', {
          url: url
        }).then(function(resp) {
          return $scope.status.push(resp.data);
        }));
      }
      return _results;
    });
    $scope.openNew = function() {
      $scope.addNewVisible = true;
      $scope.newUrl = '';
      return $scope.newPort = 443;
    };
    $scope.closeNew = function() {
      return $scope.addNewVisible = false;
    };
    $scope.add = function() {
      var url;
      if (!$scope.newPort) {
        $scope.newPort = 443;
      }
      url = "" + $scope.newUrl + ":" + $scope.newPort;
      $http.post('/api/check_cert', {
        url: url
      }).then(function(resp) {
        return $scope.status.push(resp.data);
      });
      $scope.userConfig.certificates.domain.push(url);
      $scope.closeNew();
      return $scope.save();
    };
    $scope.remove = function(status) {
      var url;
      url = status.url;
      return messagebox.show({
        text: gettext('Remove the url ' + url + '?'),
        positive: gettext('Remove'),
        negative: gettext('Cancel')
      }).then(function() {
        var index;
        index = $scope.userConfig.certificates.domain.indexOf(url);
        $scope.userConfig.certificates.domain.splice(index, 1);
        $scope.save();
        index = $scope.status.indexOf(status);
        return $scope.status.splice(index, 1);
      });
    };
    return $scope.save = function() {
      return config.setUserConfig($scope.userConfig);
    };
  });

}).call(this);

'use strict';

angular.module('ajenti.check_certificates').controller('CertWidgetController', function ($scope, $http, config) {
    return $scope.$on('widget-update', function ($event, id, data) {
        if (id !== $scope.widget.id) {
            return;
        }

        if (data) {

            $scope.status = [];
            $scope.sync = 'start';

            config.getUserConfig().then(function (userConfig) {
                $scope.userConfig = userConfig;

                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = $scope.userConfig.certificates.domain[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var url = _step.value;

                        $http.post('/api/check_cert/test', { url: url }).then(function (resp) {
                            if (resp.data.status == 'danger' || resp.data.status == 'warning') $scope.status.push(resp.data);
                            $scope.sync = 'done';
                        });
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }
            });
        }
    });
});


