import random


def randomUuid() -> str:
    """
    生成随机的uuid
    :return: 随机的uuid
    """
    import uuid
    return str(uuid.uuid3(uuid.uuid4(), str(uuid.uuid1())))


def randomInt(start: int = 0, end: int = 100, step=None) -> int:
    """
    随机生成指定范围内的整数
    :param start: 开始范围
    :param end: 结束范围
    :param step: 步长
    :return: 随机整数
    """
    if step:
        return random.randrange(start, end, step)
    return random.randint(start, end)


def randomFloat(start: float = 0, end: float = 1, scale=None) -> float:
    """
    随机生成指定范围内的浮点数
    :param start: 开始范围
    :param end: 结束范围
    :param scale: 精度
    :return:
    """
    if scale and scale > 0:
        return round(random.uniform(start, end), scale)
    return random.uniform(start, end)


def randomBool() -> bool:
    """
    随机一个bool值
    :return:
    """
    return randomFloat() > 0.5


def randomItem(items: (list, set, tuple, str)):
    """
    随机一个元素
    :param items: 元素集合
    :return: 随机一个元素
    """
    if items:
        return random.choice(items)


def randomItems(items: (list, set, tuple, str), size=1, distinct=False) -> list:
    """
    随机一个元素列表
    :param items: 元素集合
    :param size: 随机个数
    :param distinct: 是否去重
    :return: 随机元素列表
    """
    if items:
        if distinct:
            items = list(set(items))
            if 0 < size == len(items):
                random.shuffle(items)
                return items
            if 0 < size < len(items):
                lists = []
                while len(lists) < size:
                    it = random.choice(items)
                    if not lists.__contains__(it):
                        lists.append(it)
                return lists
            else:
                raise RuntimeError("distinct item len < random size")
        else:
            if size > 0:
                lists = []
                while len(lists) < size:
                    lists.append(random.choice(items))
                return lists


def randomChars(size: int, distinct=False) -> str:
    """
    随机生成指定长度的可见字符串
    :param size:
    :param distinct:
    :return:
    """
    items = []
    items.extend(range(48, 57))
    items.extend(range(65, 90))
    items.extend(range(97, 122))
    random.shuffle(items)
    rItems = randomItems(items, size, distinct)
    return "".join([chr(item) for item in rItems])


def randomNumberStr(size: int, distinct=False) -> str:
    """
    随机生成指定长度的数字字符串
    :param size:
    :param distinct:
    :return:
    """
    items = []
    items.extend(range(0, 10))
    random.shuffle(items)
    rItems = randomItems(items, size, distinct)
    return "".join([str(item) for item in rItems])


def randomMobile(*pres) -> str:
    """
    随机生成手机号
        randomMobile(180,136,185)
    :param pres:手机号前缀
    :return: 手机号码
    """
    preStr = "1"
    if pres:
        preStr = str(randomItem(pres))
    randomSize = 11 - len(preStr)
    if randomSize > 0:
        return preStr + "".join(randomItems("0123456789", randomSize))
    else:
        return preStr[0:11]


def randomMobiles(*pres, size: int = 1) -> list[str]:
    """
    随机生成一批手机号
        randomMobiles(180,136,185, size=10)
    :param pres:手机号前缀
    :param size:批量大小
    :return: 手机号码
    """
    mobiles = set()
    if size <= 0:
        return []
    while len(mobiles) < size:
        mobiles.add(randomMobile(*pres))
    return list(mobiles)


class NameCreator(object):
    def __init__(self):
        nameStr = "赵,钱,孙,李,周,吴,郑,王,冯,陈,褚,卫,蒋,沈,韩,杨,朱,秦,尤,许,何,吕,施,张,孔,曹,严,华,金,魏,陶,姜,戚,谢,邹,喻,柏,水,窦,章,云,苏,潘,葛,奚,范,彭,郎,鲁," \
                  "韦,昌,马,苗,凤,花,方,俞,任,袁,柳,酆,鲍,史,唐,费,廉,岑,薛,雷,贺,倪,汤,滕,殷,罗,毕,郝,邬,安,常,乐,于,时,傅,皮,卞,齐,康,伍,余,元,卜,顾,孟,平,黄,和,穆," \
                  "萧,尹,姚,邵,湛,汪,祁,毛,禹,狄,米,贝,明,臧,计,伏,成,戴,谈,宋,茅,庞,熊,纪,舒,屈,项,祝,董,梁,杜,阮,蓝,闵,席,季,麻,强,贾,路,娄,危,江,童,颜,郭,梅,盛,林," \
                  "刁,锺,徐,丘,骆,高,夏,蔡,田,樊,胡,凌,霍,虞,万,支,柯,昝,管,卢,莫,经,房,裘,缪,干,解,应,宗,丁,宣,贲,邓,郁,单,杭,洪,包,诸,左,石,崔,吉,钮,龚,程,嵇,邢,滑," \
                  "裴,陆,荣,翁,荀,羊,於,惠,甄,麹,家,封,芮,羿,储,靳,汲,邴,糜,松,井,段,富,巫,乌,焦,巴,弓,牧,隗,山,谷,车,侯,宓,蓬,全,郗,班,仰,秋,仲,伊,宫,甯,仇,栾,暴,甘," \
                  "钭,厉,戎,祖,武,符,刘,景,詹,束,龙,叶,幸,司,韶,郜,黎,蓟,薄,印,宿,白,怀,蒲,邰,从,鄂,索,咸,籍,赖,卓,蔺,屠,蒙,池,乔,阴,鬱,胥,能,苍,双,闻,莘,党,翟,谭,贡," \
                  "劳,逄,姬,申,扶,堵,冉,宰,郦,雍,郤,璩,桑,桂,濮,牛,寿,通,边,扈,燕,冀,郏,浦,尚,农,温,别,庄,晏,柴,瞿,阎,充,慕,连,茹,习,宦,艾,鱼,容,向,古,易,慎,戈,廖,庾," \
                  "终,暨,居,衡,步,都,耿,满,弘,匡,国,文,寇,广,禄,阙,东,欧,殳,沃,利,蔚,越,夔,隆,师,巩,厍,聂,晁,勾,敖,融,冷,訾,辛,阚,那,简,饶,空,曾,毋,沙,乜,养,鞠,须,丰," \
                  "巢,关,蒯,相,查,后,荆,红,游,竺,权,逯,盖,益,桓,公,万俟,司马,上官,欧阳,夏侯,诸葛,闻人,东方,赫连,皇甫,尉迟,公羊,澹台,公冶,宗政,濮阳,淳于,单于,太叔,申屠,公孙,仲孙," \
                  "轩辕,令狐,锺离,宇文,长孙,慕容,鲜于,闾丘,司徒,司空,亓官,司寇,仉,督,子车,颛孙,端木,巫马,公西,漆雕,乐正,壤驷,公良,拓跋,夹谷,宰父,穀梁,晋,楚,闫,法,汝,鄢,涂,钦,段干," \
                  "百里,东郭,南门,呼延,归海,羊舌,微生,岳,帅,缑,亢,况,後,有,琴,梁丘,左丘,东门,西门,商,牟,佘,佴,伯,赏,南宫,墨,哈,谯,笪,年,爱,阳,佟,第五,言,福 "
        bodyNameStr = "壮,昱杰,开虎,叶行,家越,煜文,家惟,龄之,俊有,啸威,浩一,向红,军,建荣,紫威,彬,作为,博轩,爵,榕轩,韦聿,仁腾,诏涣,勇宁,东阁,泰寰,春军,翼帆,诏炀,培帆,又淇,谦韵," \
                      "子柏,永慧,仲泉,恒一,恒源,凯,大奇,兴宁,笑野,浩峰,宪,伟平,彦博,树魏,坚武,梓华,啸吟,华繁,啸宇,健奇,艺臣,一同,疾风,伟洪,镜敏,政浩,子旭,玉轩,子林,延赤,禾,环球," \
                      "亚韬,昊俊,嘉汶,纯德,天宇,盛世,华山,兆临,泽光,栗,樯,一辉,闻博,国洋,毅杰,建可,惠山,谦之,连喜,溪俨,学江,树鹏,鹏,天友,庆宇,本凤,少涛,键程,厚霖,泽一,清嵘,车亦," \
                      "新民,志东,剑清,海霖,一溪,融渝,玺剑,超宇,永润,人月,炳荣,冰博,季栋,仁赫,兰斌,嘉伟,军军,鄂,思华,建青,兴华,冀川,赞平,佳汛,万鹏,飞平,树隶,子桁,志忠,柯茗,佛晓," \
                      "之帆,晟尔,守均,茁壮,梁宇,博洪,亚军,翼成,胜轩,子皿,记博,博玉,继优,翰琨,均培,敦强,浩羽,先登,明津,潇添,燃,章见,本三,仁甫,小磊,文福,鹏云,成虎,家正,来麟,树木," \
                      "超勇,榀荃,博涛,炳越,宝全,浩然,明华,士琪,自逊,风力,世玉,文禹,付增,戊石,天麟,新宇,彭弘,玉松,绍优,熹伟,才铭,以优,丰,文丁,凯菱,霆,禹萌,唯,建捷,韦仅,立安,星博," \
                      "文誉,洛漾,丰翌,心我,榛元,承乐,运晟,霆锋,明鉴,宝愈,国宇,维稼,乐玺,二,张钰,柏晨,铱,尊,晓斌,益思,敬敏,艺怊,嘉增,栋良,棁,家宇,思宜,恩昊,逸鹤,雍颐,光煜,智怡," \
                      "培治,涛远,东东,文舆,怿,健民,如意,万昆,腾中,明德,铨坤,招,道军,书畅,万祥,名川,雨沛,英钧,禹诚,湘溢,咏壹,丁翱,志虎,黎烘,艺言,照临,泓敖,志男,赫名,传金,晖涵,轩齐," \
                      "启宇,韬淘,熙恒,渡,晓戈,兆均,旭九,能嘉,佳尧,天松,毛瘩,胜尧,米黄,福伦,林烨,邦鑫,奕臣,会军,泽江,云辉,志皓,之烨,焕起,逸宁,庆国,晏霆,桡铭,子地,家辉,鹏飞,辉煌," \
                      "于瑞,梓棕,中彦,锦尧,福昌,辛戎,寰宇,家雨,立刚,城石,侦烨,记政,威新,润兵,天添,磐石,礼发,苏联,一豪,义彪,霄,再熠,于皙,嘉韬,胜群,宝同,一了,冠毅,红中,宇捷,卿,政昊," \
                      "博文,培然,粲粲,昱天,一铄,廷,丁,西成,茂赓,克帅,惠达,世洲,郁安,振舫,三瑞,哲昱,源源,云起,吉尔,黎鑫,鳅锋,钰满,致辉,培海,立华,灿昕,新颜,子灏,京辉,晋尧,争,逸舟," \
                      "镐,小峰,择石,吾行,天硕,宇飞,钧哲,睿,恺越,锦彦,子豫,绅缘,力飞,昊坤,紫昊,雨凡,生诩,黎泓,方欣,大帝,青,奕融,博松,士海,煜烽,柏铎,晋,誉皓,献军,鸿儒,家维,晨旭," \
                      "发全,松俊,厚林,若帆,匀浩,广明,甫元,本烽,水泉,天赐,士红,更航,汉涛,纬,相淇,渊龙,近任,彦钧,铄,易磊,雏腾,步财,力帆,先智,岩,畦嵘,之恒,霈焱,文相,诚之,临渊,嘉靖," \
                      "昊鑫,宇辰,锶齐,育博,忠泽,国文,绎皓,晏玮,丁予,晖,大兴,恒翡,元八,学军,尚印,立志,绍友,献林,永生,军旗,亚,泳嘉,云岩,宏敏,倍林,煜濮,又元,颢继,志博,子晟,哲骞,洪贤," \
                      "思危,学斌,新平,驰云,泽峰,耀明,竟凯,天彤,钰文,国权,健深,家瑜,大伟,丞,前坤,志洋,世强,颖军,支聿,栋宇,子尘,缘博,卫,仁东,现春,保建,丞扬,禹宣,嘉恒,明翰,昊军,飞仰," \
                      "煊,弛,志豪,世智,文祥,嘉骐,镇,晓龙,盛名,晋嘉,允,鸣哲,思锐,子宏,效金,恪震,稼,文程,树文,天意,金勇,义山,卫东,富仪,国威,泯柱,羲峰,元三,明章,玮新,鼎余,新立,旭飞," \
                      "冠发,子钱,玉峰,晨硕,智杰,跃明,东森,薪扬,俊宝,宝强,敬宁,钰竣,润,梓城,冰溢,艺洋,柏言,一涵,国维,学而,子彧,晓皓,增,杰,明顼,渝,家一,振中,阗田,伟,钰逵,晶皓,泺杰," \
                      "晟之,孟利,维,宏康,兴云,奭彧,新昊,华良,应腾,晋坤,泉景,益玮,偌石,曦恒,德,博武,陆鑫,耀崎,志民,泓轩,家祺,勇搏,莘源,永进,子源,山,乐轩,帆,文斌,长鑫,修铭,罡毅," \
                      "火根,金朱,熹远,子鼎,鸿羽,鸿峰,贺迪,伟明,引平,财茂,深泉,储剑,己辉,振东,偲齐,劲杉,垒,风宝,泽众,宇军,仲源,彦乐,鸿义,新悦,哓翕,旭军,保真,会勇,永红,建安,天烘," \
                      "金忠,祎藤,自鸣,志超,立荣,逸清,多旭,大采,必杰,承智,岭楠,锦伟,忆罗,亚辉,剑锋,子鹰,稿,玮霁,轶铭,宏民,悟石,奔,鑫田,书行,寒峻,伟东,云驰,新钧,时立,润和,裕,彦," \
                      "子珩,荐程,嘉政,昕源,畦尧,祖东,雨卓,潍,志琪,涵博,乐平,浩坤,厚郴,俊熙,进,新忠,绍涵,震天,哲力,峻,明军,沛帆,志朋,无悔,煜燊,剑飞,开宇,韶荨,民成,子岩,健,棋西,程," \
                      "云杰,皓坤,为民,耀建,成伟,翊程,宏谟,叮咚,泳杰,儒绅,锦浩,柽锘,达,子忱,晓旭,伯伟,雄霸,怀民,豫,本祯,月东,永菜,洲,宁,霄城,钰润,宇佳,瑞林,树勋,永圯,中芏,生明," \
                      "霄龙,臻安,维强,亦多,文启,艺逞,宗寿,勇刚,佳祥,怀仁,家祥,柯言,若熙,立东,付华,光宇,文靖,康,熹玮,联博,志勇,子千,泽辉,雍仪,新源,忱,彦文,裕淼,阳阳,一鸣,天琪,晓垒," \
                      "国庆,建华,搏涵,越羲,子辰,瀚为,峻逸,昀天,全心,铭浩,云,浩成,建明,新文,闻涛,中进,印螺,思胤,子才,哲栋,小霄,永利,子宣,抱石,平宁,依贻,永兴,华彬,匡胤,焕军,会初," \
                      "文俨,银全,禹然,付荣,小龙,泉盛,黎弘,文行,煜恒,力玮,清满,怀荣,永波,炳珲,光雷,建珂,江立,记策,佳洲,英策,旭君,韦迪,子欣,贤文,鹏远,子丞,梓希,霖,泽生,永淇,文铧," \
                      "广勇,呈,力苇,颢,晓生,大国,绍教,焙,渝川,尧,厚相,崇,偲煜,恩,扬,致墚,桐瑞,宜帆,辉华,易恒,盟潞,刘一,诚诚,欣煜,子骐,学海,烙豪,子震,智友,智永,志鸣,小文,李杰," \
                      "艺什,均伟,宝良,俊男,选军,文振,禹森,靖玮,哲轩,健程,毅轩,守君,子良,寅,柏泽,之琰,子竞,言,绍珺,鑫哲,亚鹏,海根,树楷,榄,义杨,佳腾,晨帅,奕宁,岩松,艺明,悦阳,名," \
                      "本安,雨晨,吾稷,诣修,子信,广修,禹函,方方,新新,天舒,鹏智,议麦,子峰,品桦,致,钰昆,智敏,碧宝,子安,卞聿,子腾,黎宏,民琦,安琪,国旭,西俊,志乔,元一,瑞俊,隆,良枝,源荣," \
                      "东,丰文,厚彬,厚楚,儒祥,铁军,天玄,津川,国辉,子弘,宏海,嘉贤,恒欣,纯烨,晓涛,建国,嘉诚,斌宇,鸿潍,懿良,路,勃,永锋,钊,毅瑞,树岗,卓羲,子太,聿珂,林峰,煜铠,传昌," \
                      "旷元,子恩,焱年,妙丰,俊皓,泽元,连仲,跖,孙侃,靖,为正,子钦,傲立,元五,锷,东明,诩,大圣,烁贻,煜熙,译文,占环,梓言,西雷,长凇,志玮,临旭,延波,竞博,沩,庆威,元聿,琦逸," \
                      "宏韦,俊峻,可东,宝玉,烨之,烨明,鹏博,亦尘,泽之,子琛,之涣,砚,天鹏,思谐,浩震,学宁,戈雷,思愚,子亮,启,贵有,嘉牧,有科,沛淮,礼义,轶文,铄海,宇钦,俊彦,焯楷,森东,文起," \
                      "琪逸,玉忠,波,闵柱,锐柏,鸿敏,旌任,贝宠,继龙,子熙,天田,秋廷,凯瑞,首钧,书瀚,钽轶,立新,志文,华君,综融,湘汝,恒宽,平峡,轩海,书玉,屹玮,常明,昊,雨童,福胜,鲑埔,佳明," \
                      "丁元,迄,文志,红兵,志威,宪军,庆军,凡玄,桂超,明红,如昕,玄峰,惟,北北,新雨,巍,保刚,鼎天,国正,步高,鑫源,淼淼,太阳,叶宣,本艇,财明,贝聿,煜钢,君平,方成,秦,心砚," \
                      "安勇,醇烨,誉怀,得亮,广嘉,立宏,紫腾,炬,联锋,占波,劲,梓洋,文俊,霈然,毅剀,海宾,洪君,顺娃,国沧,大大,树立,腾辉,语宇,务石,钰坤,剑柯,志锁,普加,亚伟,彬杰,荐成,相龙," \
                      "诗泽,晨洋,玉胜,崇岳,鼎民,兴疆,嘉福,玮珀,飞帅,士杰,笑山,盟坷,官全,星昊,天依,同安,天俞,均炜,启越,子赫,彦淮,允禄,翰宇,遭,本亮,乙征,三奔,燮林,经程,天骥,值浩,滔," \
                      "万海,宇晨,寒骏,师心,小凯,飞麟,中锴,凯聆,金铢,勤,利军,昌盛,庆,建志,龠曦,宇,朕,长鸣,淳烨,桂鸣,育栋,小,嘉喜,延龙,韦稼,岩郊,心念,文廷,梓俨,鹏宇,建谨,灿,宇恒," \
                      "颐轩,为为,栀荣,梓烨,礽宠,鼓腾,涵一,传艮,伟新,锶铭,坤澎,宽巧,富强,新路,鳅渔,舒同,天问,心宝,彦恺,晋中,勤元,继之,梓成,全,昭炀,言郊,清栋,吉平,开石,华臣,博虎," \
                      "学汉,仁,海波,鹤,铭桐,永屹,轩鸣,泓扬,铭学,博宇,进兴,德军,禹暄,田,家宝,晋帷,成梓,宏潍,友碧,景博,大琦,清荣,雪中,万里,钦,一庭,溯溯,大勇,承,化忠,京津,鑫磊,加乐," \
                      "培玉,启策,正刚,柯涵,辛昊,安各,志会,钊恒,令锋,烁,全昆,成科,天国,树威,鲁愚,伯虎,诩生,文哲,赢文,崇楦,铁成,金波,文海,梓平,旭敏,铎海,顺利,鸿维,润军,铭轶,洪川,灼," \
                      "金城,才恒,鼎弘,孚融,东博,文林,梯烨,旺旺,焱宁,衍昀,义芝,神,泸,国荣,康宁,世伟,家连,跃建,建平,渝淇,科州,凌博,立明,柽铭,乐瑞,恒铭,记昀,速捷,宏维,涵文,吾光,云轩," \
                      "俊入,义,锁川,寄平,丁曦,国明,文栋,纪苏,成昊,广玉,四昱,光强,晨扬,奕炜,一晗,金梁,明勇,钰澄,飞,伟鹰,李谊,晓翰,浚,世平,爱国,安铃,雪酉,大峰,鸣世,文霖,德志,竟胜," \
                      "泺漾,伟铭,欣汝,玉斌,钟海,崤龙,思言,育恒,慧来,亚峰,墨然,烁桐,爱民,浩智,桂柱,张晨,赫明,立群,程枫,皞晖,怀东,珉柱,烜,献武,瑞华,禧贤,子育,皓文,博林,红涛,源太," \
                      "绍军,野,璨,金迟,悦边,伟力,羽其,昭,文双,书兵,广同,宏儒,书航,开华,恒德,会光,延岭,元七,贺僮,博思,友恒,士铭,赫铭,子鉴,子天,郝宇,天榆,昊泽,旺牛,思博,国全,洪勋," \
                      "南星,纪超,一闻,剑峰,赢,子鹏,海澎,振胜,厚哲,恒薪,时予,黄米,良缘,树彪,冠玉,振宜,野夫,占华,楚一,瑜涛,茗辉,仁秋,福山,文青,宝国,道能,晓明,云贵,嘉尧,宝贤,友仅," \
                      "添锦,曦,钧崴,永杰,稳锋,与彦,治铭,宏卫,彦民,逸飞,云天,仁会,沛之,吾航,茗柱,问谨,学潼,旭彤,炳超,少江,子狄,浩雄,冰剀,应彬,树伟,天福,雨辰,挺,广,懿轩,岭南,毅," \
                      "建成,效忠,瑞,吉根,盛利,世泽,仪宇,浩权,璞煜,艺桥,常鸣,伟林,锌轩,齐恺,其明,玉文,思洗,亚斌,泰钧,亚伦,宗羲,锃,铭钐,皓元,戟,一宁,彬洲,子翔,朝府,佛霆,无极,用颐," \
                      "建龙,志强,子晨,见波,鹏珂,全琨,胤燃,高雅,跃,蛟蛟,煜轶,学奇,胤贤,柏慧,传奇,泽云,永熠,恺稷,祖寿,海涛,敏沣,泽林,稽,杰成,天鸿,宣辰,涛,文骐,建飞,战平,文滔,熙宇," \
                      "汉翀,浩骅,浩晟,华桥,建基,本初,天昀,杰俊,杨又,凯怡,鸿艺,屹森,琭珧,晨晖,淏轩,旭阳,荣荣,鸿基,雨杰,振铭,忠雷,天玉,河征,则石,振明,东梁,小才,玺宇,志为,德胜,树廷," \
                      "子清,佳程,辛宇,宇欣,银发,有祥,文府,学峰,建深,栗源,科淇,宇帅,夕优,台,心均,家荣,本强,孟勇,天烁,建方,国敏,子封,嘉生,艳强,尔丰,荃坤,晏瑞,今朱,荣德,埔铖,子聪," \
                      "文敬,子琦,光辉,白卓,子宬,耀哲,财华,庆友,聪宇,朝蓬,宁仁,荣达,子桀,烁哲,安戈,无克,锐哲,旺,晓珲,征,树辉,祚誉,海洲,诏,辰若,熔石,政,易贻,君卓,晨煜,海彬,天爱," \
                      "林鹏,力,晨罡,力邦,龙泽,成振,世升,名琛,克豪,洛嘉,梓源,元九,启丞,天齐,勒,新会,林霄,新刚,松康,昱升,楚煊,福宣,家伟,雨龙,皓,晟铭,艺巩,锫帆,永辉,明浩,拓,崇俊," \
                      "可欣,邵敏,荣华,燕鹏,可光,信崴,逸吉,明刚,寓原,晓凡,泉宇,久彬,欣圣,科晴,殿红,煜铭,一廷,洛,文力,睿扬,水欣,广军,占龙,水莘,剑,鸣,余荣,圆源,善宏,连华,紫豪,彦锦," \
                      "祥刚,讯谟,屿,球,桓铭,云州,奕卿,淇尔,建博,淋,述平,文玄,新国,灵博,思凡,厚湘,冰汝,晨阳,元二,惠宣,九龄,雷,泉,杉,悦鑫,墨晗,紫翰,爱新,天龙,力铭,梓研,钊华,沛晟," \
                      "禹轩,竞锐,若石,宜程,沛天,添,瀚文,胜,思渐,常入,超,民柱,瑞希,天辉,成刚,浩斌,与,筌贰,仕海,林宾,诗育,思彦,添易,济恺,人之,帅奕,思恒,健生,弘韬,如,铁平,嘉正,文富," \
                      "鼎凯,均,思谚,健凯,梁东,呈炜,义琛,超越,竟轩,强,海云,赞,晨祺,雨晟,治华,斯祁,文熙,浩嘉,英浩,鑫仪,耀匀,紊文,清漾,崇源,政喃,飞扬,山川,允潇,鞠国,春杰,文余,邦峰," \
                      "如稷,信孜,文昕,李承,邻溪,宇轩,佳林,赵勇,鼎愚,怀友,崴,成彪,士立,江宇,凯彦,贵元,县科,兆轩,轶震,元十,永兵,毅怊,子烨,胜玉,金华,甲辉,欣源,子昕,益波,广垒,荣,钏海," \
                      "清淞,礼维,为政,国超,云奇,胤诚,紫瀚,春天,弘力,丁天,小丁,小皓,苠柱,清哲,淘淘,伟伟,子雷,海亮,祺法,文澜,泰,利帆,仅开,若盛,成程,彪石,尉一,迦乐,雨鑫,振学,博寒," \
                      "山山,思镐,佳乐,立民,飞雄,江龙,铭峰,彬哲,福荣,彦祺,铭,希林,乾坤,越恒,德录,元乃,同举,岩石,泽华,金,硕恒,承文,正,德智,天合,春铭,新录,筹,震舫,紫炜,瑞涛,焉平," \
                      "一征,本焱,天阳,闵闵,景智,德耿,长荣,金塔,兴月,敬云,洪杰,铮海,琪亮,凤岐,天洪,子豪,释予,师禹,继耐,捷,家成,小伟,向华,建永,绰鉴,兴俊,洪涛,蔚波,火霄,正阳,开吉," \
                      "木椟,大增,必胜,大宇,艺胜,泰力,诚,海琛,韶齐,雪健,潇凯,畔,焱森,力川,杰城,豫暄,子贵,弘维,元四,玉杰,之初,淮南,禹权,智海,又辉,增沂,涵宇,达生,泽川,灿灿,保红,嘉境," \
                      "翔,喜顺,小瑞,思尧,哲文,聪欣,增荣,仁杰,杰晟,柳稳,顺敏,富平,勃松,旌宇,凌棱,众,雍,兴雨,日广,林溪,富城,杨广,一彤,永亮,武飞,利宝,恒铨,中民,笑铭,珑译,耀希,侦驰," \
                      "车羽,哲,胤然,煜玺,源,弈儒,糟,椿烨,通震,轩祐,旭星,小华,泓维,瑞杰,东海,力弘,思波,林玉,国石,云哲,尚轶,学勤,舒民,林,红东,煜权,人稼,祺恺,竞,凯明,柽铎,瀚宇,文晋," \
                      "守禄,衍,韦众,志宏,啸龙,梏,昶然,东琛,文良,瀚引,品谋,玮炜,水源,天羽,智渊,成云,天红,贺淇,志刚,家墨,起林,金石,毫晨,释之,叙淳,海,子扬,则玉,栗琛,建杰,鸿志,凌晟," \
                      "晔,柏,纤昊,勃滨,克平,禄,要攀,诏震,皓寓,孜洋,世杰,了一,宸豪,子亲,威皓,炫锋,露中,建人,达宁,泽岐,贤先,建洪,玉富,晓峰,海冰,恪铭,钰麟,奎胜,梓立,煜盛,曲坤,子昱," \
                      "浩润,嘉轩,家豪,本航,本田,宇凡,羽粲,天佑,士硕,昕宇,洪源,健树,特,子伯,厚汀,蛟,宏,浩伟,涌太,天琦,华冰,胤言,春明,江,云祥,翌轩,政皓,震坤,春龙,超刚,刘畅,振,科理," \
                      "占久,财将,高,近冬,官,凯翎,斯旗,友林,润恒,尉,腾,羲,清洋,智俊,子凡,迦勒,贺彤,轶华,俊星,焕,瑞熙,维杰,晋伟,雨亭,振宇,志儒,隆吉,嘉乐,锐,小东,自川,濂敏,李轩," \
                      "共金,永贤,靖百,腾达,田烽,鼎儒,种,学山,卫华,友清,亚涛,明雨,唯德,仅众,联全,友烨,富华,献,峻艺,祥洲,紫石,楷铭,长亦,雪山,张黄,天,余晗,忠世,志诚,文超,继承,炳文," \
                      "鸿灏,一诺,春皓,胜文,鹏举,丞含,政权,举纲,靖嘉,文庭,献文,言骄,承民,崇懿,享眠,邯,明涛,琥诚,首军,瀚,孟达,新澳,李诚,韦臣,曾刚,宜宣,家鸣,越,祁强,宏宇,维东,凡雨," \
                      "宇通,杨航,谦昊,海中,维新,怀亮,竞胜,晟烨,叶良,存吉,畦山,名柱,一峰,熙,佳伟,立杉,景波,凯仪,隽,航滔,大海,文睿,汝杰,天祥,仕杰,峰铭,思渠,志昕,午光,思渤,泽滟,芪," \
                      "永俊,一水,雪飞,洧,拙羽,兵,河江,长征,海岩,之荣,牧,飞羽,子涵,卫新,丁文,文涵,咏辉,基栋,翎西,奂奂,星宸,柽名,冲,梓伟,呈珉,壹冰,炜鹰,尔泰,龙文,吉松,荪,殊言,帅克," \
                      "闯,军伟,传君,一钰,德银,宇栋,占平,加琛,子亚,叶航,卓雨,凇,子渊,轩豪,宪君,纬新,珑,梁栋,益坚,晓东,巴聿,世恩,延年,智泽,玉一,元旦,凯昕,若钢,黎俊,傲伟,韶奇,之栋," \
                      "皕,涣晟,硕楠,蛸龙,益甫,爱军,祥雨,泽霆,嘉锡,凯杰,利安,正飞,雪涛,煜汀,华,武盾,圣群,硕,雨桐,莘田,其,楚宁,文博,泊泽,研博,官钱,洪敏,政哲,德俊,广森,岳灿,青洋,矛," \
                      "前进,建席,国生,隽巍,世缘,秉彰,林佳,玉祥,臻,逸卿,红力,艺众,泳淇,齐,明宇,子伟,兆启,恒轶,李博,筱林,繇,怡浩,庆平,亨太,海培,相茗,啸,侦仲,莜昊,笠仲,梓严,宇琨," \
                      "佳坤,元瑞,维龙,永康,钝海,铎馨,书铭,朝洋,为一,厚杳,振波,鑫铭,德利,安,辰宇,瑜生,心源,宝,竹林,智墚,森栋,凯晨,国飞,忠洁,建宁,明星,天宝,臣,新禄,若焕,策钧,辛生," \
                      "子健,艺皓,清伟,字逊,成龙,宇乐,车聿,昀程,晋文,号号,桂成,俊,青松,文明,思禹,飞雨,炯,椿雨,文兵,奇,成,庭境,隆石,用,凡子,恒,镇雄,阔,伟佳,宜靖,行,颢冰,绍赓,若辰," \
                      "天洋,兴利,禹芪,建艺,闻宇,子灵,泽皓,福胤,雪吉,博伦,天瑜,兴贤,泽瑜,耀辉,缙尧,永泉,一羲,谢书,天宁,焕平,阵,伍一,嘉誊,子孜,帅权,继忠,硕颀,嘉林,业龙,明泽,江红," \
                      "少勇,钰哲,肇明,培天,聪灿,煜田,畅鑫,思维,远理,迅崭,嘉畦,璞,安之,永以,晟恺,淇,名渊,泽鑫,乐,文宝,振鹏,政豪,德勤,昌正,贵云,立虎,骅,术祥,滨勃,佛廷,凌波,福宝," \
                      "乐杉,友田,子栩,帷,若刚,国钧,浩南,风,旺财,嘉锐,君入,彪,耀新,崇巍,禹阳,定星,笑添,立双,赞品,连科,文浩,奕晨,岷柱,章钰,辰维,骁纹,嘉庚,小兵,统元,泽俊,志杰,洪伟," \
                      "庆喜,悦洋,文新,林熙,志欣,文瑜,卜亓,宝黎,椿宇,禹,麒森,御言,春宇,贺任,梁,鹏义,怀曦,志缘,学桐,胜利,振宁,智博,子枫,丰岚,小攀,七七,建荩,威廉,啸博,明,勇阳,钧威," \
                      "海文,昱珂,树棋,增才,家宏,健声,本升,君麟,文亮,锡康,岩平,攀锋,昱承,禹诺,记福,凌林,明成,韵锡,田丰,亦溪,元哩,建郁,峥旭,渭,满意,红博,圳,斯文,汝杉,麒淞,安军,文楠," \
                      "怀宁,海双,夔闼,奋仁,俊安,智稼,宏建,恒通,利国,弈舟,禹芩,普华,利,伟杰,抚山,珈铭,品幕,振林,宏炜,一童,羽拙,柏林,旭岩,久翔,恩石,熠桐,昊东,凯华,思进,骜,银海,槿铭," \
                      "祥俊,明松,梓杭,小康,翊暄,欣宇,凡卜,爱铭,中宝,诚程,佐英,重庆,记顺,子琪,武,子谦,杰然,吉伟,天白,义磊,惟新,双川,了,玉强,凯信,永斌,方洲,长发,可人,天弘,炫锐,富明," \
                      "俊枫 "
        girlNameStr = "小玉,蓝,琬郡,琛青,予舴,妙妙,焱诺,艺歆,芮熙,悦优,艺杨,艺惠,爱芬,含因,楚菊,佳禾,婧妗,玉容,文莉,娅雯,碧连,芊菲,宇娜,志妍,天馨,静,涵雅,辰语,瀚樱,小捧,丹丹,黎腩," \
                      "丹华,文璐,芳辉,浚丽,才霞,采嫦,梦琪,泥,映月,铱芳,馨馨,媛鑫,紫萱,玉春,韶玥,紫玉,丽静,藤娟,朵,贞,佼悦,珍宝,千叶,嘉琪,丙芳,玉琴,丽雅,影祺,潇琳,寒凝,赛,竹梅," \
                      "颜婷,靓颖,亦菲,颖萌,筵彤,岚羽,茜柔,钦玥,伊茗,嘉韵,花玲,蕤,子歌,佛瑶,云丽,彩杰,稼妮,华蓉,彦芳,笑,尹真,笑榕,语潼,雪虹,婧雯,玉菡,欣妍,佳丽,盈乐,思佳,卜鸾,建婷," \
                      "桐菲,岑,雅彦,婧颖,氏艳,舒畅,谦雅,馨文,帼玮,子鲜,惠君,成艳,言婷,美琪,轺骊,诗青,慧英,凤霞,琼也,贝,湘玉,鑫卉,巧兰,姝英,惜颖,珈,靖茹,予易,艺涟,冰竺,兰锁,菁鹤," \
                      "理微,瑛,盼望,楚含,雯舜,歆翌,迪欣,菡韵,桂芳,贵英,艺榕,跹,键蓉,歆迪,草,爱素,丽景,春笑,慧娟,玉佳,密密,译诺,雯煜,雪晴,骊莉,贝瑶,文琼,淑莲,子娇,珍瑜,水芯,晨芳," \
                      "岚爱,琳艳,冬萍,成梅,冬梅,茜茹,恬语,恬,睬嫦,珂芯,旖旎,金芝,紫凝,希颖,淑仙,亚萍,佳钰,雪冰,兆珍,冰涵,静飞,昱瑶,启玲,韵,英英,露瑶,含裴,屏,梅娥,亚卿,橼丹,琬琪," \
                      "华梅,三红,灿荧,佳颖,纯杉,春雨,碧雪,悦兮,雅星,甜甜,惠珺,润梅,雪琴,梦迪,莺罂,钰荣,悦颜,若琪,静如,可露,雅晴,淑杰,雨柔,紫佟,青桐,淑志,白茹,伟玲,肖竹,佩君,羽桐," \
                      "玉凤,宗艳,艺萍,爱佳,志玲,雪萍,筱玲,华兰,玉馨,孜萱,伶黎,雁溪,松燕,润琳,晓蜜,立英,巧灵,真希,梦凡,欣奕,婷,网娣,月露,妮娟,沁雯,岚瑛,悦辰,静妍,籽铃,淑雅,小白," \
                      "翠萍,紫桐,索菲,盈盈,巍璇,欣雨,思苏,美珍,若芸,思蓓,婷菲,娅,纯菁,昀琪,恩蕊,梓媛,晓君,闵琼,语珊,亟奕,姣平,施,彩芬,桂荣,广琴,蒙笑,晓萍,恋泯,枫栏,紫晴,德霞,雪晶," \
                      "翊含,紫楦,苓君,兆凤,文警,馨瑶,紫瑛,叶雯,温馨,婉晴,爱华,书琳,梓萱,思冉,艺潼,兰芬,卉彤,美鑫,玉兰,馨逸,伊诺,潇佳,静莎,秋凤,倩楠,奕瑶,培娟,玉霜,千菲,理薇,晨鹭," \
                      "淑景,碧莲,宝芳,雅婕,淑敏,卫芳,予晗,潇霄,丽婧,铁娟,茜榆,晓霞,月嫦,妍熙,春娥,心艳,嫘迩,智娟,羚淯,芷洁,怡嘉,雪芹,伶藜,黛媛,左婕,心羽,蕴蔷,倩可,晶淋,茵桐,悦淇," \
                      "桂榕,琇赑,姝玉,珞彤,心瑶,禹晴,怡然,杰兰,美祎,晓琳,灵宵,子怡,雅烨,迦兰,黛妤,曾弈,嘉玲,宇蔓,英兰,文珏,籽萱,仁艳,蔓茗,盈馨,吴瑾,露予,英博,紫嫱,樱,馨怡,艺苔," \
                      "海珍,瑾晶,莹爱,奕晴,航旖,馨贤,亚冰,贞如,兰同,苡露,昕玉,之菁,梅珠,雅玲,惠梅,嘉雯,溪茹,金绣,翊倩,思竹,译予,邦蓉,为艳,甜冶,语菲,湘孜,樱琼,诗妤,钰桐,玲梦,曼珂," \
                      "玥熹,思姚,韫金,鹛邡,蓉蓉,茵芝,芝君,娇宁,玺露,肖冰,琼,敏捷,家媛,少虹,轶芳,珏媚,朝娣,晓雨,菲箐,若诗,惠娴,艺越,伶利,姝雅,荠蔚,婧宇,洁莹,梅玲,婷恣,雅莉,紫贤," \
                      "思蕊,星月,开梅,籍丹,筵栖,思冰,稼婷,琴,邦婕,婧菡,琪雨,瑞琪,黎楠,易含,翠雅,馨妍,滢滢,一枚,正英,淑贞,邦雯,佃芳,茜颖,田妮,铃,瑞凤,艳洁,琬悦,骊元,霈雨,加姿,海晶," \
                      "栩园,紫欣,立静,雯絮,苏菲,梓钥,晏佳,茉然,锦鸽,羽晴,悦茜,元圆,渔雪,俊琴,思霞,利花,雨朦,栩圆,玲芬,兰军,留霞,若嘉,睛,弈盈,邦莎,钰荥,珏欢,沂蓉,瑛琪,婉,冬琦,寒微," \
                      "畦芎,如怡,思斯,朱琴,绽雪,文琴,欣,新雅,剑萍,蔓泽,新慧,琳翊,籽妙,君蕊,诗雨,韵琳,青春,芳,亚欣,盼兮,晓钰,思琰,巧稚,芸,缠曦,丁丹,蕾镭,艳霞,小雨,东玲,讳隽,瑜茜," \
                      "美荣,六梅,婕宇,沁彤,风青,欣桐,美媛,树燕,昱芊,彩霞,岚昀,紫雯,小羽,灵儿,芬芬,烨涵,雨楠,宵蕙,维香,映荷,毓萱,艺囝,艳娇,筵蕊,雨菡,新菊,王菲,静男,雪岩,斯诺,向娟," \
                      "子璇,语墨,颐雯,珂欣,辰颖,静玉,沁范,海艳,晓洁,煜萍,甜茜,珺莉,姝雯,伊瑶,婧璇,翊茹,可涵,萩薇,梓妙,瑞菊,依彤,巧,妤芊,玟琳,夏月,润眉,影,正美,娅琳,靖菲,喻露,馨茹," \
                      "心如,颖桦,珊妹,悦然,黎娜,盈羽,晋玥,漫霓,渫晴,滢茔,浣西,欣羽,真茜,紫梓,一媛,程茵,宇馨,梦玲,娅冰,逸舒,文萍,斯琴,景红,清梅,月英,翕颖,翠英,梓丽,冰蕊,楚函,绚海," \
                      "晓雪,彦茹,慧慧,馨辰,楚依,婉合,占莉,立琴,亚莉,荧,蒙萌,蔓辰,婷曦,玲平,子琼,倩怡,当当,雯耀,雯佳,鹳央,雅淇,凤茹,沁帆,若嫣,梓伊,琫晖,茄霖,钰淼,湘匀,菁胭,虹,运蓉," \
                      "囡囡,保玲,淑璇,若思,佳榕,卓茜,晓瑞,聪洁,婉仪,筵朋,珏悦,潇颖,湉蕊,静江,玉莹,韵菡,茵彤,舒彤,可盈,秀丽,伶俐,慧郡,静柔,若羽,冰茜,旭姻,淑,舆敏,译月,桂卿,冰芳," \
                      "邦丽,舒雅,沁菲,玥,馨予,容琨,娇娇,令菲,伶,宝英,迎婷,英坤,懿珈,靖晴,萍华,安霞,才梅,艺含,梦杰,美月,远芳,诗雅,宁娟,静芳,曾伊,唤清,洽恰,屿彤,诗毓,宇璐,海媚,昱丹," \
                      "晓菁,露壬,田甜,盼希,王丽,桂芬,诺焱,蔓菱,璇玥,桂洋,巧芸,紫韩,真儿,素君,静怡,心悦,歆月,乐薇,予馨,茔茔,婉萍,予涵,奕涵,思昀,静伟,小阅,璐桢,靖悦,雨诺,小雯,晓燕," \
                      "梦娜,微茹,奕凤,琇,金涵,艳敏,含汶,迎瑕,亦雯,清妍,紫,铃铃,欣甜,肇娟,乙黛,运丽,嘉伊,翊筠,欣欣,向静,静琰,玥淼,新萍,梦兰,智晴,俊婷,艳诚,荔,虹烨,雪境,家兰,蜜蜜," \
                      "冬英,桂娇,千艳,荟君,洁宁,慕白,荟筠,建珍,謦,洪侠,雨婕,妍,茗蕊,尹,春柳,丽蓉,力香,祎甜,小燕,冰瑶,美美,世娟,雨珂,雨蒙,馨媛,娃娃,杰婷,佳瑜,巧韵,香菏,斐禾,梓茜," \
                      "雅馨,晓曦,智雅,格筵,慧仪,景梅,海英,佳琪,付燕,馨笛,紫奕,思菁,彩画,沅梦,纳文,书韵,箬晗,妃妃,洁,昀萱,雅文,笑宁,丁丽,弈雯,婉钧,小思,育娜,晓萁,春菲,惜源,玉雪," \
                      "楚洁,一玫,铄滢,雪颖,聪丽,鑫雅,美秀,茗寒,心心,忆如,梓萌,妁,雪媛,琳鑫,娟鹏,子媛,文瑛,潇涵,婵,丽岚,美茜,静琳,怡欢,威茹,笑函,真萍,苗亦,丹,岑茵,聆可,梅香,筵冬," \
                      "珈影,彩文,海雯,艳飞,曦颖,应琴,偌菡,俊芳,彦颇,祈蓝,彦妍,金露,立玲,县丽,培芳,采薇,倩倩,玲华,英,海红,珺娴,怡雯,改玲,艺童,燕婷,孟雪,海珠,心迪,洪丽,于影,昕予," \
                      "以琳,瑞婕,姝月,黍洁,薰今,东曼,雨琪,语佟,林露,燕萍,唯玮,淑茗,惠华,鸿燕,雯辉,金莲,乙靓,桂红,雅静,娜瑛,妍嘉,乃琚,丽淑,静嫣,语心,沁,家姿,爱宁,梦海,彩芳,纤亦,栏," \
                      "凤珍,淖翔,红梅,雪儿,春红,兰颖,军霞,姿,雯予,莉芬,嘉玉,玉英,艳焱,雅琪,巧瑛,蒽诺,临芳,秀利,凤焉,贻茜,玮环,香涵,米,洳洳,玉,洁鑫,玉童,静菡,语,芷晴,惠圆,欣如,珺," \
                      "烨菲,茜,延婷,婧琦,熠绮,颖,径盈,舒然,书悦,丹熠,珂馨,义琴,思沫,一晴,又丹,歆桐,斯研,纳,苏颖,韵雅,靖雯,惠颖,璐祺,惠郡,心歌,雅真,喜兰,竹莎,予敏,烟雨,荔荔,涵凝," \
                      "琬迪,如思,晓艺,娜祺,季语,珈乐,潇湉,俊婕,尤玥,玉涵,俊娴,美玉,妤亭,红琴,葭,艾琪,莺,智瑶,萧尹,丽丽,曾泓,依涵,冰凝,梅英,雅儒,妍溪,新颖,丽荣,楠钰,丹其,筱蒙,雪焦," \
                      "馨雨,姝瑛,湘雨,凯妍,盼溪,贵梅,巧婵,巧宁,馥瑞,业蓉,丹凤,茵程,如忆,海娟,珏朋,丽达,胜菊,岱雯,紫聪,菲凡,昭容,姝涵,昱苹,一惠,豆叮,彩云,若岚,丹琦,琳青,思,莺桦,芬," \
                      "漫呢,云娜,楚君,炳娟,英雪,妤熙,俪潆,雪彤,婧焱,韵非,雅利,芷瑜,利芳,菲晴,星语,昕颖,新熳,煜玲,岩婷,黎荭,湉心,珍珠,美萍,彦秀,钰涓,满红,良妍,颖菲,雅漩,研婷,偌遥," \
                      "贤芝,霓,斯雯,雪恬,淑芹,一萌,佳恬,俪婷,顺琼,漫旎,潇雅,猗,优优,黍娴,细霞,琇淼,翠花,黛一,淑贵,美华,于咏,爱枝,伶郦,紫佳,紫慧,茗,艺楚,艺扉,琳慧,含玥,晓薇,思燕," \
                      "馨元,晴雯,季秋,莉娜,湘君,智仙,若丝,巾谰,疏桐,春梅,钥,兰峰,雪琦,菲蕾,欣静,美红,姬,占翠,知琳,筱筱,翊岚,红岩,竞予,小花,漫,力鳗,蒙雪,云慧,英菲,瑗,占艳,红雨," \
                      "思语,思瑜,剑芳,云闲,艳花,文婕,欢欢,熠菲,夕娴,浚莉,钰萤,姚伶,叶瑶,婉琳,容韪,紫菡,黛源,筵芮,璎萌,函翊,妞,静蓉,亚男,楚苹,满雪,怀蓉,逸萌,煜葶,风瑜,黛怡,珍珍," \
                      "彩峡,安婷,苡柔,晶馨,琀骊,榆婷,静琨,蓝月,盈淼,真,淑雨,雨欣,俪予,紫琀,亚朋,小瑗,紫瑞,玉蓉,茗萱,帆菲,素琴,蒂,瑞芝,春晴,旭莺,语彤,瑾,嘉潼,哩哩,娉婷,贤雅,颖颖," \
                      "延霞,茜婷,小叶,小萌,丽,陈嫦,丹蕊,曾熠,琦瑶,从侠,海侠,珏琪,茗栾,海妹,梦童,梓潼,子菲,馨茉,又分,秋娴,鹭,琫,翠奉,偌瑶,书芳,珈嘉,晨伊,欣怡,玉滢,朋筵,苡菲,译男," \
                      "茵瞳,小莹,春慧,欣瑶,蓦瑶,熙雯,语洋,玉慧,桂莲,黎英,曾逸,惠榕,嘉姿,填艳,秋锦,尤艳,方艳,女馨,逸芳,梓舒,国兰,雨婷,茹,益兰,梦洁,虹蕾,菲帆,笑涵,岚颖,彤梦,艺萌," \
                      "婧妤,红月,洁贞,春懿,芯,讳郡,晓淇,玫莹,芹霞,春婷,金珠,均瑶,雪竹,晓霜,泽璇,丹红,伶莉,若缺,丽慧,铭淑,慧丽,保芳,译易,佳缘,柔婷,思伽,久娣,业丽,丹艺,钰茹,沁浛," \
                      "旃婴,楠,静烟,心慈,采清,作娟,晓欢,淑宇,婧宏,婧琰,盼好,子娴,蔓宸,雯鼎,莲生,思羽,智馨,圣玲,丝媛,菁璠,晓晶,萌笑,蕊,黎男,云艳,欣语,玉露,媛媛,雪倩,莉霞,芯伶,筵晰," \
                      "煜莹,筱奕,露瑾,文蕊,蓝分,甜也,楚潼,子琀,缘朋,二媛,微晞,佳晏,诗颖,辰菲,焱嫦,藜静,舒,凤娇,琨晶,菊芹,梦欣,冬菊,絮哲,媛曳,幸红,心昕,桂云,榕蕴,佳茵,盼盼,韵斐," \
                      "诗瑜,含,芹,净妃,静静,矜钥,嘉钥,雨萌,思恬,蔓瑶,莹姝,乃慧,月晗,海韵,悦恬,彩,淑英,语麦,欣艾,雅姿,艳婷,金娣,婷婷,月恬,曾谊,洪梅,建娥,占美,冰月,丽霞,倩茹,洁霖," \
                      "闲云,黎赧,恋,漪妃,芷蕾,琬昱,媛苑,碧丹,靖琪,含音,子雯,荟乐,湉仪,佳羽,艺珺,苓翊,巧荣,晓琴,文韫,茹译,舒译,松琴,乃芸,瑾璞,樱淇,琪悦,恒美,思桠,凤荣,滢舒,秀荣," \
                      "栗梅,姗娜,亦珊,慕贞,秀乡,小凤,碧月,黍沁,潇燕,静雯,米淇,盈曦,乔楠,学蓉,纯雯,璞玥,黛月,冰淼,惠丽,雨含,玉涓,爱菊,奕雯,艺霏,嵛爱,雨晴,蕙郡,梦晗,祎恬,苛茜,珏变," \
                      "晓莉,彦涵,絮琪,华英,霓芝,双双,英迪,灵,明香,新芬,善美,乐园,琬琬,玉秋,丁莉,月菱,娅书,芳茜,黛熙,琰莹,爱云,玉芳,世慧,紫璐,黎红,妙玲,招英,笑怡,瑞玉,滢淼,画,靓," \
                      "聪敏,毓婷,倩如,蕴,晓楠,雨寒,春英,义珍,雪琳,婧媛,冰晴,梦伊,耐花,亚隽,倩雅,秋梅,诗兰,子蕊,凤芝,雯怡,菲烨,艳荣,雅丽,昕心,亚茹,霁倩,梓玥,卉郡,婧菲,辰玥,漪楠," \
                      "淑霞,馨月,海霞,丽瑾,湉馨,娟芳,孓乜,悦涵,怀瑶,栩瑶,佳琳,容欢,玉璠,宝凤,靖萱,菲菲,敏嘉,小朋,雅君,巧悦,琬敏,鹃,婧彤,榕珈,绮绮,璠,语晗,楚蓠,羽菲,奕丹,宝蓓,欣竞," \
                      "橼香,溢溶,巧洁,翘,小薇,皎月,黍涓,汉娜,洪霞,溢蓉,彩桦,玲菱,璀蝉,杰媛,圆圆,毓琪,楚萍,翠翠,筵溪,玉静,霞斌,含婴,佐洁,芮儒,辛怡,晓雯,艺竞,菁涵,清雪,宇琼,思桐," \
                      "占香,慧华,子晶,瑞梅,荑,卜露,虹苏,丹梓,文侠,格畅,妮颖,思怡,琼仙,潞涵,雨娜,艺融,之倩,蕴蓥,蒙欣,露婵,嘉怡,籽柔,恬悦,译心,宝玲,玫,静胭,思飘,颖哲,芷萌,莜苒,翊妍," \
                      "月云,雯杰,佳珂,惠芳,婉菁,玉情,智岚,修兰,娅娜,巧英,茂玲,欣蕊,茵僮,金兰,雅雅,春丽,育梅,惠玲,钰清,唯依,悦琴,玉冰,芯悦,美,若雪,天英,开艳,子婴,一瑗,梦佳,雯叙," \
                      "芯蕊,永霞,鑫蕾,馨静,真艺,娉,学艳,鑫莹,云菊,静菲,婷文,格,秋,彦妮,韶婕,惠黎,容,艺涵,应梅,欣然,冰雪,凤斐,露凝,溪媛,蕾蕾,梦桃,朦月,容轩,苡馨,有琴,静贤,芝瑗," \
                      "雾瑕,艺潞,依雯,妤炯,心彤,素敏,净,晗琪,乔荟,心爱,樱萱,芯玙,俊菊,培珍,玲英,小双,靖虹,梓函,容伊,邦薇,靖晗,墨涵,冰蝉,艺晗,素芹,钰淇,莉红,惠媛,芷莹,彩嫦,潇,芷真," \
                      "二翠,春月,艳芬,沁湘,梦涵,晓兰,蕴潇,兰谊,译君,紫云,欣玥,旭瑛,秀粉,冰柠,翎,慧梅,静轩,安妮,晓春,一萍,萸艳,恚捃,筱竟,淑平,佳昕,又芬,立娜,秀容,枘雨,庆秀,春燕," \
                      "苏瑶,筵颉,芷源,可莹,绘郡,黛宁,中艳,俏寒,亚秋,雪平,梦茹,俪曦,钰妃,慧贞,巧利,净桐,世霞,荟郡,昱霏,韵奕,忻瑶,溪蕾,艾萍,嘉歆,艳辉,乙晶,秀,语昕,琳琳,邦莉,孟妍," \
                      "一珺,孝菊,涧晴,与芊,爱萍,依笑,美婷,美娟,菁妍,丽洁,昭瑗,贤翠,雪蓉,珂茜,沁韵,晶琨,丽丰,婼宝,炜婷,月煜,薪欣,丽珊,笳卉,玉瑛,纯微,仪雨,肖红,惠芬,利娟,真花,威洁," \
                      "妮妮,琳力,蕾明,艳艳,诗语,楚凤,圆,芷姗,歆,晶欣,贤珺,伟芬,心盈,双涵,梓艺,笑昀,芳敏,晓倩,桂宁,国梅,译匀,欣悦,韵寒,铁萍,邝邑,涵悦,采霞,书媛,晏彤,紫菲,云砾,鑫蕙," \
                      "梦亭,秋凝,一男,煦晴,化英,邦妹,寒素,莹琨,岚,紫暄,林芳,淑琴,巧玲,彦敏,胜娟,新艳,馨丹,改娣,梓莹,雅倩,丽威,丽市,云琦,峻莉,梓盈,馨宇,思寒,清莉,晓园,敬茹,玲玲," \
                      "采妮,雪菡,小慈,聪妮,蔓莹,小芳,小娟,馨方,先媛,雨诗,春姝,诗怡,婕,凤丹,伶妗,玥玥,珺骊,冰俏,水莲,文霞,利娜,师娴,梨梨,筵郗,娣,静焱,姝婷,羲颖,筵格,郦,英杰,迎雪," \
                      "丝嘉,媛琪,丽欣,灵琴,雪会,寒莹,媚莹,薇,芝榕,晓慧,斯语,雁冰,青敏,莎莎,秀慧,倩云,荣珠,惠璞,晗涵,英睿,舒馨,平芝,真瑜,丽惠,苓菱,雅琦,钰洁,黎喃,办艳,育红,海燕," \
                      "弈茹,筵曦,予婕,湄姗,一卉,仪凡,嫦茜,佳湘,紫薇,慧宇,云芳,芸菁,小珊,雅秋,俏明,紫帆,淑芬,薇文,晓涵,昭雪,溶依,丽华,芮曦,竞男,叶,淑烨,舒沁,琳茜,佳,娉娉,群媚,晓云," \
                      "津樱,桐俏,蕴茴,心兰,立萍,缠糯,瑗琪,艾娜,润妍,云霞,语童,秋香,蓓,颜,月琪,彦婕,境薇,秀瑛,凤贵,雨霏,悦含,颖佳,彤彤,飒,嘉薇,丹扬,兴茹,中花,一菲,唯伊,锦芝,佳咨," \
                      "乙潞,筱宇,潇蔷,秋花,宇萱,思晨,一萱,金瑶,紫莹,芝华,伟娟,珏文,佐婕,玉儿,津芝,璧儿,斓菲,飘,笑萱,玉翠,颖乙,敏焰,金枝,苗潇,鑫媛,朵菡,雪蕊,艳,美雯,永兰,庆玲,聪娅," \
                      "籽烨,恭兰,家珍,仪涵,常秀,文娟,玄睫,焕莉,漫妮,子萱,冬青,薇茹,了尹,敬莎,路语,潇缤,晗彤,竞丹,婧文,甜语,曾翊,嘉琳,昭茜,若兰,祺玥,婧,汝雯,彦瑾,丽鑫,婷玉,以柔," \
                      "旭缨,佳姊,语燕,秀美,紫寒,泺滢,莛,小丽,丽菲,若涵,馨田,奕洁,雅雯,秀云,云舒,筠,娈,婉杉,沁涵,琳佳,沁雅,思晗,莺宁,旭晶,尹倩,庭凤,菁琰,芷蔓,彦芹,秋月,晓漫,馨仪," \
                      "韶韵,苏钰,忆琛,盼曦,嫣,业莹,晓侠,子莉,姬月,佳梓,曼婷,焕婷,靓妍,远萍,依霖,薇茜,丽珠,黛毓,晨思,国艳,君玉,芮,菁菡,骊骊,兮艳,书沁,邰璇,如艺,怡甜,丹璐,乙彤,晗悦," \
                      "漫雪,尘香,芷涵,讳筠,宁忆,蕴萦,雪,英华,东丽,景芳,寒怡,琳,思楠,湘佳,菲雪,韵舒,誉玲,冰露,芸萌,雨舒,婧帆,水馨,雪娇,思予,雅芙,淑华,浚俐,增彩,栖蕴,玺凤,藤容,元芳," \
                      "景月,双男,笑雯,珏灵,雨烟,小琴,索霏,湘语,誉艳,箐,雯跃,润芳,爱芝,珏婷,芮萱,楚涵,雪拽,紫璇,奕妍,煜婷,可悦,彦莲,朵朵,苏苏,琴燕,智燕,娟花,贝贝,敬玲,鹤丹,丹奇," \
                      "馨卉,思仪,学玲,靖芝,诗涵,苡葶,英芳,妍姿,馨伊,琰婷,雨雯,昭媛,雁茹,华妮,舒文,萍玲,羽亭,溪铃,俊霞,月心,莹,兰子,嘉薪,建仙,阅涵,钰芳,昕怡,蔓宇,芷槿,海聆,子婵,旎," \
                      "亚玲,秋六,萌烨,文娇,瑞兰,克娥,乙涵,丹冰,海丽,梓含,义芳,片艳,菁蕊,春霞,玲娟,菁嫣,栖含,佁函,笛笛,思暮,桂香,季月,乙露,惠惠,雯琳,椿燕,凤仙,思侠,爱桐,湘梦,煜莺," \
                      "敬怡,文静,绣玲,爱媛,歆洁,玉淇,筱彦,雅苹,苏诺,煊婷,邦倩,怡芮,佳芮,宝琴,斐然,绮晗,媛,旭瑶,乙伊,谦影,楠楠,荔莉,语瞳,小语,之侠,书莲,姿萱,妤伊,金花,莲珍,羽潼," \
                      "予绮,若晴,莲泯,紫沐,诗琴,崴茹,伊涵,心怡,乐怡,菀莹,佛兰,僖玉,蕴涵,语桐,曾宜,瑞巧,惠丹,慧,艺琼,清红,昱惠,芮菡,克娟,溪潺,书瑶,沁凡,舒晨,星慧,倩菲,美玲,姣姣," \
                      "艾珂,彦静,玉芝,惠,亚君,翠华,凯媛,芮希,笑卿,紫玥,宁茜,蒴,婕媛,婧宁,嗉凤,守芬,雪昕,秀琴,红云,翊函,星燕,月淼,紫耘,佼,晓娟,琬童,英舜,鹤馨,钰滢,琬,佳沐,燕妮," \
                      "晓珊,秀杰,惠琳,英春,馨忆,婕杏,贤凤,妍卿,素云,筠鸿,春茜,庆霞,馥琳,一莉,红果,喏璐,泓曾,运珍,伶丽,海含,碧悦,婕羽,羽洁,浛,秀芹,佳心,凤艳,静姝,爱卿,诗韵,巧云," \
                      "悦婷,佳旋,田娅,颖鑫,幸溶,欢,世琴,燕玲,邦梅,如兰,苡荣,凤麟,灿蓓,骊,弦月,雪凡,亚琛,晓佳,雯一,弈莹,竹连,静虹,葑,睿馥,敏,秋虹,莎,晓红,艳波,梦珍,寒冰,秀娥,斯妍," \
                      "绮鑫,军花,珊,冬莲,窈嫒,世美,银珠,欣湉,彭媛,欣霏,菁焰,玲鑫,如诗,绍莲,菲梵,若音,江丽,文秀,美琳,茜宝,佳孜,利英,左洁,艳平,文婷,玉鹃,琪琪,影萍,艺雯,月蘅,寒笛," \
                      "冰禅,雯华,静岩,建英,小瑶,淑慧,栉烨,佳姿,颖巍,彦萌,淑征,偌晗,语湘,什艳,宏丽,斯羽,禹菡,琨静,璇海,于娴,韵沁,晓琪,萌昀,黍婵,金荟,志茹,晶婧,秀彦,允琳,容容,黎虹," \
                      "琪蔚,筱淇,慧扬,建秀,玲丽,琳颉,思悦,琨莹,巍娟,碧桃,菡悦,鑫洁,露露,文菊,彤屿,锦月,纨,桂芝,舒帆,慧蓉,素萍,秀茹,恬妞,新月,才茹,一霏,书琴,婧懿,茹春,玥心,淑存," \
                      "雅慈,一靓,璇,雯淇,桠菽,赛琦,琰萍,光雯,小慧,大珍,婧暄,月晶,含颖,妍熹,旭慧,梓喃,秋莲,潇莹,荟冰,筠莉,昆丽,丽婷,雅湘,锦芳,俊英,小筱,内艳,雯露,心菁,紫涵,茜如," \
                      "誉娟,娴,馨如,籽昱,若晗,云媛,瑶蓓,聪雅,歆童,又砾,碧君,亚春,童漩,纤男,雯岚,源梦,萌乐,俊菲,小霞,炎婷,晰晴,新英,梓茵,海蓉,语娜,馨琦,晓馥,佳翊 "
        self.names = nameStr.split(",")
        self.bodyNames = bodyNameStr.split(",")
        self.girlNames = girlNameStr.split(",")

    def getBodyName(self):
        """
        随机获取一个男孩姓名
        :return:
        """
        fullName = f"{randomItem(self.names)}{randomItem(self.bodyNames)}"
        return fullName

    def getGirlName(self):
        """
        随机获取一个女孩姓名
        :return:
        """
        fullName = f"{randomItem(self.names)}{randomItem(self.girlNames)}"
        return fullName

    def getName(self):
        """
        随机获取一个姓名
        :return:
        """
        return randomBool() and self.getBodyName() or self.getGirlName()


__name_creator = NameCreator()


def randomBodyName():
    """
    随机获取一个男孩姓名
    :return:
    """
    return __name_creator.getBodyName()


def randomGirlName():
    """
    随机获取一个女孩姓名
    :return:
    """
    return __name_creator.getGirlName()


def randomName():
    """
    随机获取一个姓名
    :return:
    """
    return __name_creator.getName()
